package mods.PamHarvestCraft.bushes.sunflower;

import java.util.Random;

import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import cpw.mods.fml.common.IWorldGenerator;

public class PamSunflowerGenerator 
implements IWorldGenerator
{

	@Override
	public void generate(Random random, int chunkX, int chunkZ, World world,
			IChunkProvider chunkGenerator, IChunkProvider chunkProvider) 
	{
	      generateSurface(world, random, chunkX * 16, chunkZ * 16);
	}

	public void generateSurface(World world, Random rand, int chunkX, int chunkZ)
    {
    	BiomeGenBase biome = world.getWorldChunkManager().getBiomeGenAt(chunkX, chunkZ);
    	
    	
    		for (int i = 0; i < PamHCSunflower.wildbushrarity; i++)
    		{
    			int flowerType = rand.nextInt(1);
    			int randPosX = chunkX + rand.nextInt(16) + 8;
    			int randPosY = rand.nextInt(128);
    			int randPosZ = chunkZ + rand.nextInt(16) + 8;
    			(new WorldGenPamSunflower(PamHCSunflower.pamsunflowerWild.blockID, flowerType)).generate(world, rand, randPosX, randPosY, randPosZ);
    		}
    	
    }

}
