package mods.PamHarvestCraft.bushes.sunflower;

import java.util.logging.Level;

import mods.PamHarvestCraft.BlockPamStorage;
import mods.PamHarvestCraft.ItemPam;
import mods.PamHarvestCraft.ItemPamFood;
import mods.PamHarvestCraft.ItemPamSeed;
import mods.PamHarvestCraft.bushes.cactusfruit.PamCactusfruitBonemealEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.src.ModLoader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod(modid = "PamHCSunflower", name = "Pam's HarvestCraft Sunflower", version = "1.0")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)

public class PamHCSunflower
{
	@SidedProxy(clientSide = "mods.PamHarvestCraft.bushes.sunflower.ClientProxyPamHCSunflower", serverSide = "mods.PamHarvestCraft.bushes.sunflower.CommonProxyPamHCSunflower")
	public static CommonProxyPamHCSunflower proxy;
	
	public static int sunflowercropID = 3937;
	public static int sunflowerstorageID = 3938;
	public static int sunflowerwildID = 3939;
	public static int sunflowerID = 15681;
	public static int sunflowerseedID = 15682;
	public static int sunflowerseedpacketID = 15683;
	public static int sunflowerseedboxID = 15684;

	public static boolean seeddropfromgrass = false;
	public static int sunflowercropfoodrestore = 1;
	public static int seedrarity = 2;
	public static boolean wildbushgeneration = true;
	public static int wildbushrarity = 2;
	
    @PreInit
	public void preInit(FMLPreInitializationEvent event) {
    	MinecraftForge.EVENT_BUS.register(new PamSunflowerBonemealEvent());
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try {
			cfg.load();
			sunflowercropID = cfg.get(cfg.CATEGORY_BLOCK,"sunflowercropID", 3937).getInt();
			sunflowerstorageID = cfg.get(cfg.CATEGORY_BLOCK,"sunflowerstorageID", 3938).getInt();
			sunflowerwildID = cfg.get(cfg.CATEGORY_BLOCK,"sunflowerwildID", 3939).getInt();
			sunflowerID = cfg.get(cfg.CATEGORY_ITEM,"sunflowerID", 15681).getInt();
			sunflowerseedID = cfg.get(cfg.CATEGORY_ITEM,"sunflowerseedID", 15682).getInt();
			sunflowerseedpacketID = cfg.get(cfg.CATEGORY_ITEM,"sunflowerseedpacketID", 15683).getInt();
			sunflowerseedboxID = cfg.get(cfg.CATEGORY_ITEM,"sunflowerseedboxID", 15684).getInt();

			seeddropfromgrass = cfg.get(cfg.CATEGORY_GENERAL,"seeddropfromgrass", false).getBoolean(false);
			sunflowercropfoodrestore = cfg.get(cfg.CATEGORY_GENERAL,"sunflowercropfoodrestore", 1).getInt();
			seedrarity = cfg.get(cfg.CATEGORY_GENERAL,"seedrarity", 2).getInt();
			wildbushgeneration = cfg.get(cfg.CATEGORY_GENERAL,"wildbushgeneration", true).getBoolean(true);
			wildbushrarity = cfg.get(cfg.CATEGORY_GENERAL,"wildbushrarity", 2).getInt();
		} catch (Exception e) {
			FMLLog.log(Level.SEVERE, e, "PamHCSunflower has a problem loading it's configuration");
		} finally {
			cfg.save();
		}
	}
    
	public static Block pamsunflowerCrop;
	public static Block pamsunflowerStorage;
	public static Block pamsunflowerWild;
	public static Item sunflowerseedsItem;
	public static Item sunflowerseedItem;
	public static Item sunflowerseedpacketItem;
	public static Item sunflowerseedboxItem;

	public static ItemStack sunflowerWild;
    public static ItemStack sunflowerStorage;

	@Init
	 public void load(FMLInitializationEvent event)
	 {
		proxy.registerRenderThings();
		
		pamsunflowerCrop = new BlockPamSunflowerCrop(sunflowercropID, "sunflower");
		pamsunflowerStorage = new BlockPamStorage(sunflowerstorageID, 0).setUnlocalizedName("PamHarvestCraft:sunflowerStorage");
		pamsunflowerWild = new BlockPamSunflowerWild(sunflowerwildID, "sunflower").setUnlocalizedName("PamHarvestCraft:sunflowercrop_7");
		
		sunflowerseedsItem = new ItemPamFood(sunflowerID, sunflowercropfoodrestore, 1.2F, false).setUnlocalizedName("PamHarvestCraft:sunflowerseedsItem");
		sunflowerseedItem = new ItemPamSeed(sunflowerseedID, PamHCSunflower.pamsunflowerCrop.blockID, Block.tilledField.blockID).setUnlocalizedName("PamHarvestCraft:sunflowerseedItem");
		sunflowerseedpacketItem = new ItemPam(sunflowerseedpacketID).setUnlocalizedName("PamHarvestCraft:sunflowerseedpacketItem");
		sunflowerseedboxItem = new ItemPam(sunflowerseedboxID).setUnlocalizedName("PamHarvestCraft:sunflowerseedboxItem");

		if (seeddropfromgrass)
    	{
    		MinecraftForge.addGrassSeed((new ItemStack(sunflowerseedItem.itemID, 1, 0)), seedrarity);
    	}
		
		MinecraftForge.addGrassPlant(pamsunflowerWild, 0, 25);
		
		ModLoader.registerBlock(pamsunflowerCrop);
		ModLoader.registerBlock(pamsunflowerStorage);
		
		//Block Names
				sunflowerStorage = new ItemStack(pamsunflowerStorage, 1, 0);
		        
		        LanguageRegistry.addName(sunflowerStorage, "Sunflower Seeds Crate");
		        
		        LanguageRegistry.addName(sunflowerseedsItem, "Sunflower Seeds");
		LanguageRegistry.addName(sunflowerseedItem, "Sunflower Seed");
		LanguageRegistry.addName(sunflowerseedpacketItem, "Sunflower Seed Packet");
		LanguageRegistry.addName(sunflowerseedboxItem, "Sunflower Seed Box");


	    
		OreDictionary.registerOre("cropSunflower", PamHCSunflower.sunflowerseedsItem);
		OreDictionary.registerOre("seedSunflower", PamHCSunflower.sunflowerseedItem);


		
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCSunflower.sunflowerseedItem, sunflowerseedsItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCSunflower.sunflowerseedsItem, 2), "cropSunflower", "cropSunflower"));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCSunflower.pamsunflowerStorage, sunflowerseedsItem, sunflowerseedsItem, sunflowerseedsItem, sunflowerseedsItem, sunflowerseedsItem, sunflowerseedsItem, sunflowerseedsItem, sunflowerseedsItem, sunflowerseedsItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCSunflower.sunflowerseedsItem, 9), pamsunflowerStorage));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCSunflower.sunflowerseedpacketItem, sunflowerseedItem, sunflowerseedItem, sunflowerseedItem, sunflowerseedItem, sunflowerseedItem, sunflowerseedItem, sunflowerseedItem, sunflowerseedItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCSunflower.sunflowerseedItem, 8), sunflowerseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(PamHCSunflower.sunflowerseedboxItem, sunflowerseedpacketItem, sunflowerseedpacketItem, sunflowerseedpacketItem, sunflowerseedpacketItem, sunflowerseedpacketItem, sunflowerseedpacketItem, sunflowerseedpacketItem, sunflowerseedpacketItem));
		CraftingManager.getInstance().getRecipeList().add(new ShapelessOreRecipe(new ItemStack(PamHCSunflower.sunflowerseedpacketItem, 8), sunflowerseedboxItem));
		
if (wildbushgeneration)
		{
		GameRegistry.registerWorldGenerator(new PamSunflowerGenerator());
		}
		
	 }

}