package kegare.caveworld.util;

import java.io.File;
import java.net.URL;
import java.util.List;

import com.google.common.collect.Lists;

public class ResourceInstaller
{
	private final File destDir;
	private final List<Entry> srcList = Lists.newArrayList();
	private Class<?> srcClass;
	private boolean hasInstalled = false;

	public ResourceInstaller(File destDir)
	{
		this.destDir = destDir;
		this.srcClass = this.getClass();
	}

	public void addResource(String path, String filename)
	{
		URL url = srcClass.getResource(path);
		Entry entry = new Entry(url, filename);

		srcList.add(entry);
	}

	public void install()
	{
		for (Entry resource : srcList)
		{
			File destFile = new File(destDir, resource.filename);
			FileCopy fc = new FileCopy(resource.url, destFile);

			if (fc.verify())
			{
				continue;
			}

			System.out.printf("Installing: %s%n", destFile.getName());
			hasInstalled = true;

			fc.copy();

			if (!fc.verify())
			{
				System.out.printf("Failed to install: %s%n", destFile.getName());
				destFile.delete();
			}
		}
	}

	public void setResourceClass(Class<?> clazz)
	{
		srcClass = clazz;
	}

	public boolean hasInstalled()
	{
		return hasInstalled;
	}

	private class Entry
	{
		private final String filename;
		private final URL url;

		private Entry(URL url, String filename)
		{
			this.url = url;
			this.filename = filename;
		}
	}
}
