package kegare.caveworld.proxy;

import java.io.File;

import kegare.caveworld.renderer.RenderPortalCaveworld;
import kegare.caveworld.util.CaveLog;
import kegare.caveworld.util.ResourceInstaller;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.server.MinecraftServer;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class ClientProxy extends CommonProxy
{
	@Override
	public void installSoundFiles()
	{
		Minecraft mc = FMLClientHandler.instance().getClient();
		File soundDir = new File(mc.getMinecraftDir(), "resources/mod/sound/caveworld");

		if (!soundDir.exists() && !soundDir.mkdirs())
		{
			CaveLog.warning("Failed to make 'Caveworld' directory in " + soundDir.getAbsolutePath());

			return;
		}

		ResourceInstaller installer = new ResourceInstaller(soundDir);
		installer.addResource("/mods/caveworld/sound/caveworld_portal.ogg", "caveworld_portal.ogg");
		installer.install();

		if (installer.hasInstalled())
		{
			CaveLog.info("Done installing sound files");
		}
	}

	@Override
	public void registerRenderers()
	{
		RenderPortalCaveworld.renderIdPortal = RenderingRegistry.getNextAvailableRenderId();

		RenderingRegistry.registerBlockHandler(new RenderPortalCaveworld());
	}

	@Override
	public void addEffect(EntityFX entityFX)
	{
		FMLClientHandler.instance().getClient().effectRenderer.addEffect(entityFX);
	}

	@Override
	public MinecraftServer getServer()
	{
		return FMLClientHandler.instance().getServer();
	}
}