package kegare.caveworld.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import kegare.caveworld.block.CaveBlock;
import kegare.caveworld.handler.CaveConnectionHandler;
import kegare.caveworld.handler.CaveEventHooks;
import kegare.caveworld.handler.CavePacketHandler;
import kegare.caveworld.proxy.CommonProxy;
import kegare.caveworld.util.CaveLog;
import kegare.caveworld.util.Version;
import kegare.caveworld.world.WorldProviderCaveworld;
import net.minecraftforge.classloading.FMLForgePlugin;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;

import com.google.common.base.Charsets;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.Metadata;
import cpw.mods.fml.common.Mod.PostInit;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.Mod.ServerStarting;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.LanguageRegistry;

@Mod
(
	modid = "kegare.caveworld"
)
@NetworkMod
(
	clientSideRequired = true,
	serverSideRequired = false,
	channels = {"caveworld.sync"},
	packetHandler = CavePacketHandler.class,
	connectionHandler = CaveConnectionHandler.class
)
public class Caveworld
{
	@Metadata("kegare.caveworld")
	public static ModMetadata metadata;

	@SidedProxy(modId = "kegare.caveworld", clientSide = "kegare.caveworld.proxy.ClientProxy", serverSide = "kegare.caveworld.proxy.CommonProxy")
	public static CommonProxy proxy;

	@PreInit
	public void preInit(FMLPreInitializationEvent event)
	{
		Version.versionCheck();

		Config.buildConfig();
		Config.initialize();

		CaveBlock.configure();

		proxy.installSoundFiles();
	}

	@Init
	public void init(FMLInitializationEvent event)
	{
		DimensionManager.registerProviderType(Config.dimensionCaveworld, WorldProviderCaveworld.class, true);
		DimensionManager.registerDimension(Config.dimensionCaveworld, Config.dimensionCaveworld);

		MinecraftForge.EVENT_BUS.register(new CaveEventHooks());

		proxy.registerRenderers();
	}

	@PostInit
	public void postInit(FMLPostInitializationEvent event)
	{
		Config.saveConfig(false);

		try
		{
			ModContainer mod = Loader.instance().activeModContainer();

			if (mod != null && mod.getModId().equals("kegare.caveworld"))
			{
				File source = mod.getSource();

				if (source != null && source.exists())
				{
					Properties properties = new Properties();

					if (source.isFile())
					{
						ZipFile zf = new ZipFile(source);

						for (Enumeration<? extends ZipEntry> e = zf.entries(); e.hasMoreElements();)
						{
							ZipEntry ze = e.nextElement();
							String name = ze.getName();

							if (!ze.isDirectory() && name.startsWith("mods/caveworld/lang") && name.endsWith(".lang"))
							{
								String lang = name.substring(name.lastIndexOf('/') + 1, name.lastIndexOf('.'));

								properties.clear();
								properties.load(new InputStreamReader(zf.getInputStream(ze), Charsets.UTF_8));

								LanguageRegistry.instance().addStringLocalization(properties, lang);
							}
						}

						zf.close();
					}
					else
					{
						File langDir = new File(source, "mods/caveworld/lang");

						if (!langDir.exists())
						{
							langDir.mkdirs();
						}

						if (langDir.isDirectory())
						{
							for (File file : langDir.listFiles())
							{
								String name = file.getName();

								if (file.isFile() && name.endsWith(".lang"))
								{
									String lang = name.substring(0, name.lastIndexOf('.'));

									properties.clear();
									properties.load(new InputStreamReader(new FileInputStream(file), Charsets.UTF_8));

									LanguageRegistry.instance().addStringLocalization(properties, lang);
								}
							}
						}
					}
				}
			}
		}
		catch (Exception e)
		{
			CaveLog.severe(e);
		}
	}

	@ServerStarting
	public void serverStarting(FMLServerStartingEvent event)
	{
		event.registerServerCommand(new CommandCaveworld());

		if (event.getSide().isServer() && (!FMLForgePlugin.RUNTIME_DEOBF || Config.versionNotify && Version.isOutdated()))
		{
			event.getServer().logInfo("A new Caveworld version is available : " + Version.LATEST.or(Version.CURRENT.orNull()));
		}
	}
}