/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaks;
import invtweaks.InvTweaksConfig;
import invtweaks.InvTweaksConfigSortingRule;
import invtweaks.InvTweaksConst;
import invtweaks.InvTweaksContainerManager;
import invtweaks.InvTweaksContainerSectionManager;
import invtweaks.InvTweaksItemTree;
import invtweaks.InvTweaksItemTreeItem;
import invtweaks.InvTweaksObfuscation;
import invtweaks.api.ContainerSection;
import invtweaks.forge.InvTweaksMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class InvTweaksHandlerSorting
extends InvTweaksObfuscation {
    private static final Logger log = InvTweaks.log;
    public static final boolean STACK_NOT_EMPTIED = true;
    public static final boolean STACK_EMPTIED = false;
    private static int[] DEFAULT_LOCK_PRIORITIES = null;
    private static boolean[] DEFAULT_FROZEN_SLOTS = null;
    private static final int MAX_CONTAINER_SIZE = 999;
    public static final int ALGORITHM_DEFAULT = 0;
    public static final int ALGORITHM_VERTICAL = 1;
    public static final int ALGORITHM_HORIZONTAL = 2;
    public static final int ALGORITHM_INVENTORY = 3;
    public static final int ALGORITHM_EVEN_STACKS = 4;
    private InvTweaksContainerSectionManager containerMgr;
    private int algorithm;
    private int size;
    private boolean sortArmorParts;
    private InvTweaksItemTree tree;
    private Vector<InvTweaksConfigSortingRule> rules;
    private int[] rulePriority;
    private int[] keywordOrder;
    private int[] lockPriorities;
    private boolean[] frozenSlots;

    public InvTweaksHandlerSorting(Minecraft minecraft, InvTweaksConfig invTweaksConfig, ContainerSection containerSection, int n, int n2) throws Exception {
        super(minecraft);
        int n3;
        if (DEFAULT_LOCK_PRIORITIES == null) {
            DEFAULT_LOCK_PRIORITIES = new int[999];
            for (n3 = 0; n3 < 999; ++n3) {
                InvTweaksHandlerSorting.DEFAULT_LOCK_PRIORITIES[n3] = 0;
            }
        }
        if (DEFAULT_FROZEN_SLOTS == null) {
            DEFAULT_FROZEN_SLOTS = new boolean[999];
            for (n3 = 0; n3 < 999; ++n3) {
                InvTweaksHandlerSorting.DEFAULT_FROZEN_SLOTS[n3] = false;
            }
        }
        this.containerMgr = new InvTweaksContainerSectionManager(minecraft, containerSection);
        this.size = this.containerMgr.getSize();
        this.sortArmorParts = invTweaksConfig.getProperty("enableAutoEquipArmor").equals("true") && !this.isGuiInventoryCreative(this.getCurrentScreen());
        this.rules = invTweaksConfig.getRules();
        this.tree = invTweaksConfig.getTree();
        if (containerSection == ContainerSection.INVENTORY) {
            this.lockPriorities = invTweaksConfig.getLockPriorities();
            this.frozenSlots = invTweaksConfig.getFrozenSlots();
            this.algorithm = 3;
        } else {
            this.lockPriorities = DEFAULT_LOCK_PRIORITIES;
            this.frozenSlots = DEFAULT_FROZEN_SLOTS;
            this.algorithm = n;
            if (n != 0) {
                this.computeLineSortingRules(n2, n == 2);
            }
        }
        this.rulePriority = new int[this.size];
        this.keywordOrder = new int[this.size];
        for (n3 = 0; n3 < this.size; ++n3) {
            this.rulePriority[n3] = -1;
            ItemStack itemStack = this.containerMgr.getItemStack(n3);
            this.keywordOrder[n3] = itemStack != null ? this.getItemOrder(itemStack) : -1;
        }
    }

    public void sort() throws TimeoutException {
        int n;
        long l = System.nanoTime();
        InvTweaksContainerManager invTweaksContainerManager = new InvTweaksContainerManager(this.mc);
        if (this.getHeldStack() != null) {
            n = invTweaksContainerManager.getFirstEmptyIndex(ContainerSection.INVENTORY);
            if (n != -1) {
                invTweaksContainerManager.putHoldItemDown(ContainerSection.INVENTORY, n);
            } else {
                return;
            }
        }
        if (this.algorithm != 0) {
            if (this.algorithm == 4) {
                this.sortEvenStacks();
            } else if (this.algorithm == 3) {
                this.sortInventory(invTweaksContainerManager);
            }
            this.sortWithRules();
        }
        this.defaultSorting();
        if (log.getLevel() == InvTweaksConst.DEBUG) {
            l = System.nanoTime() - l;
            log.info("Sorting done in " + l + "ns");
        }
        if (this.getHeldStack() != null && (n = invTweaksContainerManager.getFirstEmptyIndex(ContainerSection.INVENTORY)) != -1) {
            invTweaksContainerManager.putHoldItemDown(ContainerSection.INVENTORY, n);
        }
        InvTweaksMod.proxy.sortComplete();
    }

    private void sortWithRules() throws TimeoutException {
        log.info("Applying rules.");
        for (InvTweaksConfigSortingRule invTweaksConfigSortingRule : this.rules) {
            int n = invTweaksConfigSortingRule.getPriority();
            if (log.getLevel() == InvTweaksConst.DEBUG) {
                log.info("Rule : " + invTweaksConfigSortingRule.getKeyword() + "(" + n + ")");
            }
            block1: for (int i = 0; i < this.size; ++i) {
                List<InvTweaksItemTreeItem> list;
                ItemStack itemStack = this.containerMgr.getItemStack(i);
                if (!this.hasToBeMoved(i) || this.lockPriorities[i] >= n || !this.tree.matches(list = this.tree.getItems(this.getItemID(itemStack), this.getItemDamage(itemStack)), invTweaksConfigSortingRule.getKeyword())) continue;
                int[] nArray = invTweaksConfigSortingRule.getPreferredSlots();
                int n2 = i;
                for (int j = 0; j < nArray.length; ++j) {
                    int n3 = nArray[j];
                    int n4 = this.move(n2, n3, n);
                    if (n4 == -1) continue;
                    if (n4 == n3 || !this.tree.matches(list = this.tree.getItems(this.getItemID(itemStack = this.containerMgr.getItemStack(n4)), this.getItemDamage(itemStack)), invTweaksConfigSortingRule.getKeyword())) continue block1;
                    n2 = n4;
                    j = -1;
                }
            }
        }
        log.info("Locking stacks.");
        for (int i = 0; i < this.size; ++i) {
            if (!this.hasToBeMoved(i) || this.lockPriorities[i] <= 0) continue;
            this.markAsMoved(i, 1);
        }
    }

    private void sortInventory(InvTweaksContainerManager invTweaksContainerManager) throws TimeoutException {
        log.info("Handling crafting slots.");
        if (invTweaksContainerManager.hasSection(ContainerSection.CRAFTING_IN)) {
            List<Slot> list = invTweaksContainerManager.getSlots(ContainerSection.CRAFTING_IN);
            int n = invTweaksContainerManager.getFirstEmptyIndex(ContainerSection.INVENTORY);
            if (n != -1) {
                for (Slot slot : list) {
                    if (!this.hasStack(slot)) continue;
                    invTweaksContainerManager.move(ContainerSection.CRAFTING_IN, invTweaksContainerManager.getSlotIndex(this.getSlotNumber(slot)), ContainerSection.INVENTORY, n);
                    n = invTweaksContainerManager.getFirstEmptyIndex(ContainerSection.INVENTORY);
                    if (n != -1) continue;
                    break;
                }
            }
        }
        this.sortMergeArmor(invTweaksContainerManager);
    }

    private void sortMergeArmor(InvTweaksContainerManager invTweaksContainerManager) throws TimeoutException {
        log.info("Merging stacks.");
        for (int i = this.size - 1; i >= 0; --i) {
            ItemStack itemStack = this.containerMgr.getItemStack(i);
            if (itemStack == null) continue;
            Item item = this.getItem(itemStack);
            if (this.isDamageable(item)) {
                this.moveArmor(invTweaksContainerManager, i, itemStack, item);
                continue;
            }
            this.mergeItem(i, itemStack);
        }
    }

    private void mergeItem(int n, ItemStack itemStack) throws TimeoutException {
        int n2 = 0;
        int[] nArray = this.lockPriorities;
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            ItemStack itemStack2;
            Integer n4 = nArray[i];
            if (n4 > 0 && (itemStack2 = this.containerMgr.getItemStack(n2)) != null && this.areItemsStackable(itemStack, itemStack2)) {
                this.move(n, n2, Integer.MAX_VALUE);
                this.markAsNotMoved(n2);
                if (this.containerMgr.getItemStack(n) == null) break;
            }
            ++n2;
        }
    }

    private void moveArmor(InvTweaksContainerManager invTweaksContainerManager, int n, ItemStack itemStack, Item item) {
        if (this.sortArmorParts && this.isItemArmor(item)) {
            ItemArmor itemArmor = this.asItemArmor(item);
            if (invTweaksContainerManager.hasSection(ContainerSection.ARMOR)) {
                List<Slot> list = invTweaksContainerManager.getSlots(ContainerSection.ARMOR);
                for (Slot slot : list) {
                    boolean bl = false;
                    if (!this.hasStack(slot)) {
                        bl = true;
                    } else {
                        Item item2 = this.getItem(this.getStack(slot));
                        if (this.isItemArmor(item2)) {
                            int n2 = this.getArmorLevel(this.asItemArmor(item2));
                            if (n2 < this.getArmorLevel(itemArmor) || n2 == this.getArmorLevel(itemArmor) && this.getItemDamage(this.getStack(slot)) < this.getItemDamage(itemStack)) {
                                bl = true;
                            }
                        } else {
                            bl = true;
                        }
                    }
                    if (!this.areSlotAndStackCompatible(slot, itemStack) || !bl) continue;
                    invTweaksContainerManager.move(ContainerSection.INVENTORY, n, ContainerSection.ARMOR, invTweaksContainerManager.getSlotIndex(this.getSlotNumber(slot)));
                }
            }
        }
    }

    private void sortEvenStacks() throws TimeoutException {
        int[] nArray;
        List<Integer> list;
        log.info("Distributing items.");
        HashMap<List<Integer>, int[]> hashMap = new HashMap<List<Integer>, int[]>();
        for (int i = 0; i < this.size; ++i) {
            ItemStack object = this.containerMgr.getItemStack(i);
            if (object == null) continue;
            list = Arrays.asList(this.getItemID(object), this.getItemDamage(object));
            nArray = (int[])hashMap.get(list);
            if (nArray == null) {
                int[] nArray2 = new int[]{this.getStackSize(object), 1};
                hashMap.put(list, nArray2);
                continue;
            }
            nArray[0] = nArray[0] + this.getStackSize(object);
            nArray[1] = nArray[1] + 1;
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            int n;
            int n2;
            list = (List<Integer>)entry.getKey();
            nArray = (int[])entry.getValue();
            int n3 = nArray[0] / nArray[1];
            if (n3 > this.getMaxStackSize(new ItemStack(list.get(0).intValue(), 1, 0))) continue;
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
            for (n2 = 0; n2 < this.size; ++n2) {
                ItemStack n6 = this.containerMgr.getItemStack(n2);
                if (n6 == null || !((Object)Arrays.asList(this.getItemID(n6), this.getItemDamage(n6))).equals(list)) continue;
                n = this.getStackSize(n6);
                if (n > n3) {
                    linkedList2.offer(n2);
                    continue;
                }
                if (n >= n3) continue;
                linkedList.offer(n2);
            }
            while (!linkedList.isEmpty()) {
                n2 = (Integer)linkedList2.peek();
                int n4 = this.getStackSize(this.containerMgr.getItemStack(n2));
                n = (Integer)linkedList.peek();
                int n5 = this.getStackSize(this.containerMgr.getItemStack(n));
                this.containerMgr.moveSome(n2, n, Math.min(n3 - n5, n4 - n3));
                n4 = this.getStackSize(this.containerMgr.getItemStack(n2));
                n5 = this.getStackSize(this.containerMgr.getItemStack(n));
                if (n4 == n3) {
                    linkedList2.remove();
                }
                if (n5 != n3) continue;
                linkedList.remove();
            }
            while (linkedList2.size() > 1) {
                n2 = (Integer)linkedList2.poll();
                int n6 = this.getStackSize(this.containerMgr.getItemStack(n2));
                this.containerMgr.moveSome(n2, (Integer)linkedList2.peek(), n6 - n3);
            }
        }
        for (int i = 0; i < this.size; ++i) {
            this.markAsMoved(i, 1);
        }
    }

    private void defaultSorting() throws TimeoutException {
        int n;
        log.info("Default sorting.");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n = 0; n < this.size; ++n) {
            if (!this.hasToBeMoved(n)) continue;
            arrayList.add(n);
            arrayList2.add(n);
        }
        n = 0;
        while (arrayList.size() > 0 && n++ < 50) {
            Iterator iterator = arrayList.iterator();
            block2: while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                if (this.hasToBeMoved(n2)) {
                    for (int i = 0; i < this.size; ++i) {
                        if (this.move(n2, i, 1) == -1) continue;
                        arrayList2.remove((Object)i);
                        continue block2;
                    }
                    continue;
                }
                arrayList2.remove((Object)n2);
            }
            arrayList.clear();
            arrayList.addAll(arrayList2);
        }
        if (n == 100) {
            log.warning("Sorting takes too long, aborting.");
        }
    }

    private boolean canMove(int n, int n2, int n3) {
        ItemStack itemStack = this.containerMgr.getItemStack(n);
        ItemStack itemStack2 = this.containerMgr.getItemStack(n2);
        if (itemStack == null || this.frozenSlots[n2] || this.frozenSlots[n] || this.lockPriorities[n] > n3) {
            return false;
        }
        if (n == n2) {
            return true;
        }
        if (itemStack2 == null) {
            return this.lockPriorities[n2] <= n3 && !this.frozenSlots[n2];
        }
        return this.canSwapSlots(n, n2, n3) || this.canMergeStacks(itemStack, itemStack2);
    }

    private boolean canMergeStacks(ItemStack itemStack, ItemStack itemStack2) {
        if (this.areItemsStackable(itemStack, itemStack2)) {
            if (this.getStackSize(itemStack) > this.getMaxStackSize(itemStack)) {
                return false;
            }
            if (this.getStackSize(itemStack2) < this.getMaxStackSize(itemStack2)) {
                return true;
            }
        }
        return false;
    }

    private boolean canSwapSlots(int n, int n2, int n3) {
        return this.lockPriorities[n2] <= n3 && (this.rulePriority[n2] < n3 || this.rulePriority[n2] == n3 && this.isOrderedBefore(n, n2));
    }

    private int move(int n, int n2, int n3) throws TimeoutException {
        ItemStack itemStack = this.containerMgr.getItemStack(n);
        ItemStack itemStack2 = this.containerMgr.getItemStack(n2);
        if (itemStack == null || this.frozenSlots[n2] || this.frozenSlots[n]) {
            return -1;
        }
        if (this.lockPriorities[n] <= n3) {
            if (n == n2) {
                this.markAsMoved(n, n3);
                return n2;
            }
            if (itemStack2 == null && this.lockPriorities[n2] <= n3 && !this.frozenSlots[n2]) {
                this.rulePriority[n] = -1;
                this.keywordOrder[n] = -1;
                this.rulePriority[n2] = n3;
                this.keywordOrder[n2] = this.getItemOrder(itemStack);
                this.containerMgr.move(n, n2);
                return n2;
            }
            if (itemStack2 != null && (this.canSwapSlots(n, n2, n3) || this.canMergeStacks(itemStack, itemStack2))) {
                this.keywordOrder[n2] = this.keywordOrder[n];
                this.rulePriority[n2] = n3;
                this.rulePriority[n] = -1;
                this.containerMgr.move(n, n2);
                ItemStack itemStack3 = this.containerMgr.getItemStack(n);
                if (itemStack3 != null) {
                    int n4 = n;
                    if (this.lockPriorities[n2] > this.lockPriorities[n]) {
                        for (int i = 0; i < this.size; ++i) {
                            if (this.containerMgr.getItemStack(i) != null || this.lockPriorities[i] != 0) continue;
                            n4 = i;
                            break;
                        }
                    }
                    if (n4 != n) {
                        this.containerMgr.move(n, n4);
                    }
                    this.rulePriority[n4] = -1;
                    this.keywordOrder[n4] = this.getItemOrder(itemStack3);
                    return n4;
                }
                return n2;
            }
        }
        return -1;
    }

    private void markAsMoved(int n, int n2) {
        this.rulePriority[n] = n2;
    }

    private void markAsNotMoved(int n) {
        this.rulePriority[n] = -1;
    }

    private boolean hasToBeMoved(int n) {
        return this.containerMgr.getItemStack(n) != null && this.rulePriority[n] == -1;
    }

    private boolean isOrderedBefore(int n, int n2) {
        ItemStack itemStack = this.containerMgr.getItemStack(n);
        ItemStack itemStack2 = this.containerMgr.getItemStack(n2);
        if (itemStack2 == null) {
            return true;
        }
        if (itemStack == null || this.keywordOrder[n] == -1) {
            return false;
        }
        if (this.keywordOrder[n] == this.keywordOrder[n2]) {
            if (this.getItemID(itemStack) == this.getItemID(itemStack2)) {
                Object object;
                Object object2;
                boolean bl = itemStack.func_82837_s();
                boolean bl2 = itemStack2.func_82837_s();
                if (bl || bl2) {
                    if (!bl) {
                        return false;
                    }
                    if (!bl2) {
                        return true;
                    }
                    object2 = itemStack.func_82833_r();
                    if (!((String)object2).equals(object = itemStack2.func_82833_r())) {
                        return ((String)object2).compareTo((String)object) < 0;
                    }
                }
                object2 = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
                object = EnchantmentHelper.func_82781_a((ItemStack)itemStack2);
                if (object2.size() == object.size()) {
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    for (Map.Entry entry : object2.entrySet()) {
                        if ((Integer)entry.getValue() > n4) {
                            n3 = (Integer)entry.getKey();
                            n4 = (Integer)entry.getValue();
                            continue;
                        }
                        if ((Integer)entry.getValue() != n4 || (Integer)entry.getKey() <= n3) continue;
                        n3 = (Integer)entry.getKey();
                    }
                    for (Map.Entry entry : object.entrySet()) {
                        if ((Integer)entry.getValue() > n6) {
                            n5 = (Integer)entry.getKey();
                            n6 = (Integer)entry.getValue();
                            continue;
                        }
                        if ((Integer)entry.getValue() != n6 || (Integer)entry.getKey() <= n5) continue;
                        n5 = (Integer)entry.getKey();
                    }
                    if (n3 == n5) {
                        if (n4 == n6) {
                            if (this.getItemDamage(itemStack) != this.getItemDamage(itemStack2)) {
                                if (this.isItemStackDamageable(itemStack)) {
                                    return this.getItemDamage(itemStack) > this.getItemDamage(itemStack2);
                                }
                                return this.getItemDamage(itemStack) < this.getItemDamage(itemStack2);
                            }
                            return this.getStackSize(itemStack) > this.getStackSize(itemStack2);
                        }
                        return n4 > n6;
                    }
                    return n3 > n5;
                }
                return object2.size() > object.size();
            }
            return this.getItemID(itemStack) > this.getItemID(itemStack2);
        }
        return this.keywordOrder[n] < this.keywordOrder[n2];
    }

    private int getItemOrder(ItemStack itemStack) {
        List<InvTweaksItemTreeItem> list = this.tree.getItems(this.getItemID(itemStack), this.getItemDamage(itemStack));
        return list != null && list.size() > 0 ? list.get(0).getOrder() : Integer.MAX_VALUE;
    }

    private void computeLineSortingRules(int n, boolean bl) {
        int n2;
        int n3;
        this.rules = new Vector();
        Map<InvTweaksItemTreeItem, Integer> map = this.computeContainerStats();
        ArrayList<InvTweaksItemTreeItem> arrayList = new ArrayList<InvTweaksItemTreeItem>();
        int n4 = map.size();
        int n5 = this.getContainerColumnSize(n);
        int n6 = this.size;
        int n7 = 0;
        for (Integer n8 : map.values()) {
            n7 += n8.intValue();
        }
        if (n4 == 0) {
            return;
        }
        ArrayList<InvTweaksItemTreeItem> arrayList2 = new ArrayList<InvTweaksItemTreeItem>(map.keySet());
        boolean bl2 = true;
        block1: while (bl2) {
            bl2 = false;
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                InvTweaksItemTreeItem invTweaksItemTreeItem = (InvTweaksItemTreeItem)iterator.next();
                Integer n9 = map.get(invTweaksItemTreeItem);
                if (n9 <= (bl ? n : n5) || arrayList.contains(invTweaksItemTreeItem)) continue;
                bl2 = true;
                arrayList.add(invTweaksItemTreeItem);
                arrayList2.remove(invTweaksItemTreeItem);
                continue block1;
            }
        }
        Collections.sort(arrayList2, Collections.reverseOrder());
        arrayList.addAll(arrayList2);
        if (bl) {
            n3 = 1;
            n2 = n / ((n4 + n5 - 1) / n5);
        } else {
            n2 = 1;
            n3 = n5 / ((n4 + n - 1) / n);
        }
        char c = 'a';
        char c2 = (char)(c - 1 + n5);
        char c3 = '1';
        char c4 = (char)(c3 - 1 + n);
        for (InvTweaksItemTreeItem invTweaksItemTreeItem : arrayList) {
            int n10 = n2;
            int n11 = n3;
            while (map.get(invTweaksItemTreeItem) > n11 * n10) {
                if (bl) {
                    if (c3 + n10 < c4) {
                        n10 = c4 - c3 + 1;
                        continue;
                    }
                    if (c + n11 >= c2) break;
                    ++n11;
                    continue;
                }
                if (c + n11 < c2) {
                    n11 = c2 - c + 1;
                    continue;
                }
                if (c3 + n10 >= c4) break;
                ++n10;
            }
            if (bl && c3 + n10 == c4) {
                ++n10;
            } else if (!bl && c + n11 == c2) {
                ++n11;
            }
            String string = c + "" + c3 + "-" + (char)(c - '\u0001' + n11) + (char)(c3 - '\u0001' + n10);
            if (!bl) {
                string = string + 'v';
            }
            this.rules.add(new InvTweaksConfigSortingRule(this.tree, string, invTweaksItemTreeItem.getName(), this.size, n));
            if ((n6 -= n11 * n10) < (n7 -= map.get(invTweaksItemTreeItem).intValue())) break;
            if (bl) {
                if (c3 + n10 + n2 <= c4 + '\u0001') {
                    c3 = (char)(c3 + n10);
                } else {
                    c3 = '1';
                    c = (char)(c + n11);
                }
            } else if (c + n11 + n3 <= c2 + '\u0001') {
                c = (char)(c + n11);
            } else {
                c = 'a';
                c3 = (char)(c3 + n10);
            }
            if (c <= c2 && c3 <= c4) continue;
            break;
        }
        String string = bl ? c2 + "1-a" + c4 : "a" + c4 + "-" + c2 + "1v";
        this.rules.add(new InvTweaksConfigSortingRule(this.tree, string, this.tree.getRootCategory().getName(), this.size, n));
    }

    private Map<InvTweaksItemTreeItem, Integer> computeContainerStats() {
        HashMap<InvTweaksItemTreeItem, Integer> hashMap = new HashMap<InvTweaksItemTreeItem, Integer>();
        HashMap<Integer, InvTweaksItemTreeItem> hashMap2 = new HashMap<Integer, InvTweaksItemTreeItem>();
        for (int i = 0; i < this.size; ++i) {
            ItemStack itemStack = this.containerMgr.getItemStack(i);
            if (itemStack == null) continue;
            int n = this.getItemID(itemStack) * 100000 + (this.getMaxStackSize(itemStack) != 1 ? this.getItemDamage(itemStack) : 0);
            InvTweaksItemTreeItem invTweaksItemTreeItem = (InvTweaksItemTreeItem)hashMap2.get(n);
            if (invTweaksItemTreeItem == null) {
                invTweaksItemTreeItem = this.tree.getItems(this.getItemID(itemStack), this.getItemDamage(itemStack)).get(0);
                hashMap2.put(n, invTweaksItemTreeItem);
                hashMap.put(invTweaksItemTreeItem, 1);
                continue;
            }
            hashMap.put(invTweaksItemTreeItem, (Integer)hashMap.get(invTweaksItemTreeItem) + 1);
        }
        return hashMap;
    }

    private int getContainerColumnSize(int n) {
        return this.size / n;
    }
}

