/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public abstract class TileEntityTransformer
extends TileEntityBlock
implements IEnergySink,
IEnergySource {
    public int lowOutput;
    public int highOutput;
    public int maxStorage;
    public int energy = 0;
    public boolean redstone = false;
    public boolean addedToEnergyNet = false;

    public TileEntityTransformer(int low, int high, int max) {
        this.lowOutput = low;
        this.highOutput = high;
        this.maxStorage = max;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.energy = nbttagcompound.func_74762_e("energy");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("energy", this.energy);
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public void func_70316_g() {
        super.func_70316_g();
        this.updateRedstone();
        if (this.redstone) {
            if (this.energy >= this.highOutput) {
                EnergyTileSourceEvent event = new EnergyTileSourceEvent(this, this.highOutput);
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.energy -= this.highOutput - event.amount;
            }
        } else {
            for (int i = 0; i < 4 && this.energy >= this.lowOutput; ++i) {
                EnergyTileSourceEvent event = new EnergyTileSourceEvent(this, this.lowOutput);
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.energy -= this.lowOutput - event.amount;
            }
        }
    }

    public void updateRedstone() {
        boolean red = this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (red != this.redstone) {
            if (this.addedToEnergyNet) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this.addedToEnergyNet = false;
            this.redstone = red;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
            this.setActive(this.redstone);
        }
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        if (this.redstone) {
            return !this.facingMatchesDirection(direction);
        }
        return this.facingMatchesDirection(direction);
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        if (this.redstone) {
            return this.facingMatchesDirection(direction);
        }
        return !this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(Direction direction) {
        return direction.toSideValue() == this.getFacing();
    }

    @Override
    public int getMaxEnergyOutput() {
        if (this.redstone) {
            return this.highOutput;
        }
        return this.lowOutput;
    }

    @Override
    public int demandsEnergy() {
        return this.maxStorage - this.energy;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.getMaxSafeInput()) {
            IC2.explodeMachineAt(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return 0;
        }
        if (this.energy >= this.maxStorage) {
            return amount;
        }
        this.energy += amount;
        return 0;
    }

    @Override
    public int getMaxSafeInput() {
        if (this.redstone) {
            return this.lowOutput;
        }
        if (this.highOutput != 2048) {
            return this.highOutput;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short side) {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        super.setFacing(side);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
    }
}

