/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.EnergyNet;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.wiring.BlockCable;
import ic2.core.block.wiring.TileEntityLuminator;
import java.util.List;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityCable
extends TileEntityBlock
implements IEnergyConductor,
INetworkTileEntityEventListener {
    public short cableType = 0;
    public short color = 0;
    public byte foamed = 0;
    public byte foamColor = 0;
    public int[] retextureRefId;
    public int[] retextureRefMeta;
    public int[] retextureRefSide;
    public byte connectivity = 0;
    public byte renderSide = 0;
    private byte prevFoamed = 0;
    public boolean addedToEnergyNet = false;
    private ITickCallback continuousTickCallback = null;
    private static final int EventRemoveConductor = 0;

    public TileEntityCable(short type) {
        this.cableType = type;
    }

    public TileEntityCable() {
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.cableType = nbttagcompound.func_74765_d("cableType");
        this.color = nbttagcompound.func_74765_d("color");
        this.foamColor = nbttagcompound.func_74771_c("foamColor");
        this.foamed = nbttagcompound.func_74771_c("foamed");
        this.retextureRefId = nbttagcompound.func_74759_k("retextureRefId");
        this.retextureRefMeta = nbttagcompound.func_74759_k("retextureRefMeta");
        this.retextureRefSide = nbttagcompound.func_74759_k("retextureRefSide");
        if (this.retextureRefId.length != 6) {
            this.retextureRefId = null;
        }
        if (this.retextureRefMeta.length != 6) {
            this.retextureRefMeta = null;
        }
        if (this.retextureRefSide.length != 6) {
            this.retextureRefSide = null;
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74777_a("cableType", this.cableType);
        nbttagcompound.func_74777_a("color", this.color);
        nbttagcompound.func_74774_a("foamed", this.foamed);
        nbttagcompound.func_74774_a("foamColor", this.foamColor);
        if (this.retextureRefId != null) {
            nbttagcompound.func_74783_a("retextureRefId", this.retextureRefId);
            nbttagcompound.func_74783_a("retextureRefMeta", this.retextureRefMeta);
            nbttagcompound.func_74783_a("retextureRefSide", this.retextureRefSide);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
            this.onNeighborBlockChange();
            if (this.foamed == 1) {
                this.changeFoam(this.foamed, true);
            }
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        if (this.continuousTickCallback != null) {
            IC2.removeContinuousTickCallback(this.field_70331_k, this.continuousTickCallback);
            this.continuousTickCallback = null;
        }
        super.onUnloaded();
    }

    public void onNeighborBlockChange() {
        byte newConnectivity = 0;
        byte newRenderSide = 0;
        int mask = 1;
        for (Direction direction : Direction.values()) {
            TileEntity neighbor = EnergyNet.getForWorld(this.field_70331_k).getNeighbor(this, direction);
            if ((neighbor instanceof IEnergyAcceptor && ((IEnergyAcceptor)neighbor).acceptsEnergyFrom(this, direction.getInverse()) || neighbor instanceof IEnergyEmitter && ((IEnergyEmitter)neighbor).emitsEnergyTo(this, direction.getInverse())) && this.canInteractWith(neighbor)) {
                newConnectivity = (byte)(newConnectivity | mask);
                if (neighbor instanceof TileEntityCable && ((TileEntityCable)neighbor).getCableThickness() < this.getCableThickness()) {
                    newRenderSide = (byte)(newRenderSide | mask);
                }
            }
            mask *= 2;
        }
        if (this.connectivity != newConnectivity) {
            this.connectivity = newConnectivity;
            IC2.network.updateTileEntityField(this, "connectivity");
        }
        if (this.renderSide != newRenderSide) {
            this.renderSide = newRenderSide;
            IC2.network.updateTileEntityField(this, "renderSide");
        }
    }

    public boolean shouldRefresh(int oldID, int newID, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldID != newID;
    }

    public boolean changeColor(int newColor) {
        if (this.foamed == 0 && (this.color == newColor || this.cableType == 1 || this.cableType == 2 || this.cableType == 5 || this.cableType == 10 || this.cableType == 11 || this.cableType == 12) || this.foamed > 0 && this.foamColor == newColor) {
            return false;
        }
        if (IC2.platform.isSimulating()) {
            if (this.foamed == 0) {
                if (this.addedToEnergyNet) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
                }
                this.addedToEnergyNet = false;
                this.color = (short)newColor;
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
                this.addedToEnergyNet = true;
                IC2.network.updateTileEntityField(this, "color");
                this.onNeighborBlockChange();
            } else {
                this.foamColor = (byte)newColor;
                IC2.network.updateTileEntityField(this, "foamColor");
                this.retextureRefId = null;
                this.retextureRefMeta = null;
                this.retextureRefSide = null;
                IC2.network.updateTileEntityField(this, "retextureRefId");
                IC2.network.updateTileEntityField(this, "retextureRefMeta");
                IC2.network.updateTileEntityField(this, "retextureRefSide");
            }
        }
        return true;
    }

    public boolean changeFoam(byte foamed) {
        return this.changeFoam(foamed, false);
    }

    public boolean tryAddInsulation() {
        short target;
        switch (this.cableType) {
            case 1: {
                target = 0;
                break;
            }
            case 2: {
                target = 3;
                break;
            }
            case 3: {
                target = 4;
                break;
            }
            case 5: {
                target = 6;
                break;
            }
            case 6: {
                target = 7;
                break;
            }
            case 7: {
                target = 8;
                break;
            }
            default: {
                target = this.cableType;
            }
        }
        if (target != this.cableType) {
            if (IC2.platform.isSimulating()) {
                this.changeType(target);
            }
            return true;
        }
        return false;
    }

    public boolean tryRemoveInsulation() {
        short target;
        switch (this.cableType) {
            case 0: {
                target = 1;
                break;
            }
            case 3: {
                target = 2;
                break;
            }
            case 4: {
                target = 3;
                break;
            }
            case 6: {
                target = 5;
                break;
            }
            case 7: {
                target = 6;
                break;
            }
            case 8: {
                target = 7;
                break;
            }
            default: {
                target = this.cableType;
            }
        }
        if (target != this.cableType) {
            if (IC2.platform.isSimulating()) {
                this.changeType(target);
            }
            return true;
        }
        return false;
    }

    public void changeType(short cableType) {
        this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, (int)cableType, 7);
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        this.cableType = cableType;
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
        IC2.network.updateTileEntityField(this, "cableType");
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return this.canInteractWith(emitter);
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return this.canInteractWith(receiver);
    }

    public boolean canInteractWith(TileEntity te) {
        if (!(te instanceof IEnergyTile)) {
            return false;
        }
        if (te instanceof TileEntityCable) {
            return this.canInteractWithCable((TileEntityCable)te);
        }
        if (te instanceof TileEntityLuminator) {
            return ((TileEntityLuminator)te).canCableConnectFrom(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return true;
    }

    public boolean canInteractWithCable(TileEntityCable cable) {
        return this.color == 0 || cable.color == 0 || this.color == cable.color;
    }

    public float getCableThickness() {
        if (this.foamed == 2) {
            return 1.0f;
        }
        return TileEntityCable.getCableThickness(this.cableType);
    }

    public static float getCableThickness(int cableType) {
        float p = 1.0f;
        switch (cableType) {
            case 0: {
                p = 6.0f;
                break;
            }
            case 1: {
                p = 4.0f;
                break;
            }
            case 2: {
                p = 3.0f;
                break;
            }
            case 3: {
                p = 5.0f;
                break;
            }
            case 4: {
                p = 6.0f;
                break;
            }
            case 5: {
                p = 6.0f;
                break;
            }
            case 6: {
                p = 8.0f;
                break;
            }
            case 7: {
                p = 10.0f;
                break;
            }
            case 8: {
                p = 12.0f;
                break;
            }
            case 9: {
                p = 4.0f;
                break;
            }
            case 10: {
                p = 5.0f;
                break;
            }
            case 11: {
                p = 8.0f;
                break;
            }
            case 12: {
                p = 8.0f;
                break;
            }
            case 13: {
                p = 16.0f;
            }
        }
        return p / 16.0f;
    }

    @Override
    public double getConductionLoss() {
        switch (this.cableType) {
            case 0: {
                return 0.2;
            }
            case 1: {
                return 0.3;
            }
            case 2: {
                return 0.5;
            }
            case 3: {
                return 0.45;
            }
            case 4: {
                return 0.4;
            }
            case 5: {
                return 1.0;
            }
            case 6: {
                return 0.95;
            }
            case 7: {
                return 0.9;
            }
            case 8: {
                return 0.8;
            }
            case 9: {
                return 0.025;
            }
            case 10: {
                return 0.025;
            }
            case 11: {
                return 0.5;
            }
            case 12: {
                return 0.5;
            }
        }
        return 0.025;
    }

    @Override
    public int getInsulationEnergyAbsorption() {
        switch (this.cableType) {
            case 0: {
                return 32;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 32;
            }
            case 4: {
                return 128;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 128;
            }
            case 7: {
                return 512;
            }
            case 8: {
                return 9001;
            }
            case 9: {
                return 9001;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 9001;
            }
            case 12: {
                return 9001;
            }
        }
        return 0;
    }

    @Override
    public int getInsulationBreakdownEnergy() {
        return 9001;
    }

    @Override
    public int getConductorBreakdownEnergy() {
        switch (this.cableType) {
            case 0: {
                return 33;
            }
            case 1: {
                return 33;
            }
            case 2: {
                return 129;
            }
            case 3: {
                return 129;
            }
            case 4: {
                return 129;
            }
            case 5: {
                return 2049;
            }
            case 6: {
                return 2049;
            }
            case 7: {
                return 2049;
            }
            case 8: {
                return 2049;
            }
            case 9: {
                return 513;
            }
            case 10: {
                return 6;
            }
            case 11: {
                return 2049;
            }
            case 12: {
                return 2049;
            }
        }
        return 0;
    }

    @Override
    public void removeInsulation() {
    }

    @Override
    public void removeConductor() {
        this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0, 7);
        IC2.network.initiateTileEntityEvent(this, 0, true);
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>();
        ret.add("cableType");
        ret.add("color");
        ret.add("foamed");
        ret.add("foamColor");
        ret.add("retextureRefId");
        ret.add("retextureRefMeta");
        ret.add("retextureRefSide");
        ret.add("connectivity");
        ret.add("renderSide");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("foamed")) {
            if (this.prevFoamed != this.foamed) {
                if (this.foamed == 0 && this.prevFoamed != 1 || this.foamed == 2) {
                    this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, Ic2Items.insulatedCopperCableBlock.field_77993_c, (this.cableType + 1) % 16, 3);
                    this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, Ic2Items.insulatedCopperCableBlock.field_77993_c, (int)this.cableType, 3);
                } else {
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
                this.prevFoamed = this.foamed;
            }
        } else {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public void onNetworkEvent(int event) {
        switch (event) {
            case 0: {
                this.field_70331_k.func_72908_a((double)((float)this.field_70329_l + 0.5f), (double)((float)this.field_70330_m + 0.5f), (double)((float)this.field_70327_n + 0.5f), "random.fizz", 0.5f, 2.6f + (this.field_70331_k.field_73012_v.nextFloat() - this.field_70331_k.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    this.field_70331_k.func_72869_a("largesmoke", (double)this.field_70329_l + Math.random(), (double)this.field_70330_m + 1.2, (double)this.field_70327_n + Math.random(), 0.0, 0.0, 0.0);
                }
                break;
            }
            default: {
                IC2.platform.displayError("An unknown event type was received over multiplayer.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: event ID " + event + ", tile entity below)\n" + "T: " + this + " (" + this.field_70329_l + "," + this.field_70330_m + "," + this.field_70327_n + ")");
            }
        }
    }

    @Override
    public float getWrenchDropRate() {
        return 0.0f;
    }

    private boolean changeFoam(byte foamed, boolean duringLoad) {
        if (this.foamed == foamed && !duringLoad) {
            return false;
        }
        if (!IC2.platform.isSimulating()) {
            return true;
        }
        byte prevFoamed = this.foamed;
        this.foamed = foamed;
        if (this.continuousTickCallback != null) {
            IC2.removeContinuousTickCallback(this.field_70331_k, this.continuousTickCallback);
            this.continuousTickCallback = null;
        }
        if (foamed == 0 || foamed == 1) {
            if (this.retextureRefId != null) {
                this.retextureRefId = null;
                this.retextureRefMeta = null;
                this.retextureRefSide = null;
                if (!duringLoad) {
                    IC2.network.updateTileEntityField(this, "retextureRefId");
                    IC2.network.updateTileEntityField(this, "retextureRefMeta");
                    IC2.network.updateTileEntityField(this, "retextureRefSide");
                }
            }
            if (this.foamColor != 7) {
                this.foamColor = (byte)7;
                if (!duringLoad) {
                    IC2.network.updateTileEntityField(this, "foamColor");
                }
            }
        }
        if (foamed == 0 && prevFoamed != 1 || foamed == 2) {
            BlockCable blockCable = (BlockCable)Block.field_71973_m[Ic2Items.insulatedCopperCableBlock.field_77993_c];
            blockCable.enableBreakBlock = false;
            this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, Ic2Items.insulatedCopperCableBlock.field_77993_c, (this.cableType + 1) % 16, 7);
            this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, Ic2Items.insulatedCopperCableBlock.field_77993_c, (int)this.cableType, 7);
            this.onLoaded();
            blockCable.enableBreakBlock = true;
        } else if (foamed == 1) {
            this.continuousTickCallback = new ITickCallback(){

                @Override
                public void tickCallback(World world) {
                    if (world.field_73012_v.nextInt(500) == 0 && world.func_72957_l(TileEntityCable.this.field_70329_l, TileEntityCable.this.field_70330_m, TileEntityCable.this.field_70327_n) * 6 >= TileEntityCable.this.field_70331_k.field_73012_v.nextInt(1000)) {
                        TileEntityCable.this.changeFoam((byte)2);
                    }
                }
            };
            IC2.addContinuousTickCallback(this.field_70331_k, this.continuousTickCallback);
        }
        if (!duringLoad) {
            IC2.network.updateTileEntityField(this, "foamed");
        }
        return true;
    }

    public boolean retexture(int side, int referencedBlockId, int referencedMeta, int referencedSide) {
        if (this.foamed != 2) {
            return false;
        }
        boolean ret = false;
        boolean updateAll = false;
        if (this.retextureRefId == null) {
            this.retextureRefId = new int[6];
            this.retextureRefMeta = new int[6];
            this.retextureRefSide = new int[6];
            updateAll = true;
        }
        if (this.retextureRefId[side] != referencedBlockId || updateAll) {
            this.retextureRefId[side] = referencedBlockId;
            IC2.network.updateTileEntityField(this, "retextureRefId");
            ret = true;
        }
        if (this.retextureRefMeta[side] != referencedMeta || updateAll) {
            this.retextureRefMeta[side] = referencedMeta;
            IC2.network.updateTileEntityField(this, "retextureRefMeta");
            ret = true;
        }
        if (this.retextureRefSide[side] != referencedSide || updateAll) {
            this.retextureRefSide[side] = referencedSide;
            IC2.network.updateTileEntityField(this, "retextureRefSide");
            ret = true;
        }
        return ret;
    }
}

