/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableId;
import ic2.core.block.machine.ContainerElectrolyzer;
import ic2.core.block.machine.gui.GuiElectrolyzer;
import ic2.core.block.wiring.TileEntityElectricBlock;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityElectrolyzer
extends TileEntityInventory
implements IHasGui {
    public static Random randomizer = new Random();
    public short energy = 0;
    public TileEntityElectricBlock mfe = null;
    public int ticker = randomizer.nextInt(16);
    public final InvSlotConsumableId waterSlot;
    public final InvSlotConsumableId hydrogenSlot;

    public TileEntityElectrolyzer() {
        this.waterSlot = new InvSlotConsumableId((TileEntityInventory)this, "water", 0, InvSlot.Access.IO, 1, InvSlot.InvSide.TOP, Ic2Items.waterCell.field_77993_c);
        this.hydrogenSlot = new InvSlotConsumableId((TileEntityInventory)this, "hydrogen", 1, InvSlot.Access.IO, 1, InvSlot.InvSide.BOTTOM, Ic2Items.electrolyzedWaterCell.field_77993_c);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.energy = nbttagcompound.func_74765_d("energy");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74777_a("energy", this.energy);
    }

    @Override
    public String func_70303_b() {
        return "Electrolyzer";
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_70316_g() {
        super.func_70316_g();
        boolean needsInvUpdate = false;
        boolean turnActive = false;
        if (this.ticker++ % 16 == 0) {
            this.mfe = this.lookForMFE();
        }
        if (this.mfe == null) {
            return;
        }
        if (this.shouldDrain() && this.canDrain()) {
            needsInvUpdate = this.drain();
            turnActive = true;
        }
        if (this.shouldPower() && (this.canPower() || this.energy > 0)) {
            needsInvUpdate = this.power();
            turnActive = true;
        }
        if (this.getActive() != turnActive) {
            this.setActive(turnActive);
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    public boolean shouldDrain() {
        return this.mfe != null && (double)this.mfe.energy / (double)this.mfe.maxStorage >= 0.7;
    }

    public boolean shouldPower() {
        return this.mfe != null && (double)this.mfe.energy / (double)this.mfe.maxStorage <= 0.3;
    }

    public boolean canDrain() {
        return !this.waterSlot.isEmpty() && (this.hydrogenSlot.isEmpty() || this.hydrogenSlot.get().field_77994_a < this.hydrogenSlot.get().func_77976_d());
    }

    public boolean canPower() {
        return !this.hydrogenSlot.isEmpty() && (this.waterSlot.isEmpty() || this.waterSlot.get().field_77994_a < this.waterSlot.get().func_77976_d());
    }

    public boolean drain() {
        this.mfe.energy -= this.processRate();
        this.energy = (short)(this.energy + this.processRate());
        if (this.energy >= 20000) {
            this.energy = (short)(this.energy - 20000);
            this.waterSlot.consume(1);
            if (this.hydrogenSlot.isEmpty()) {
                this.hydrogenSlot.put(Ic2Items.electrolyzedWaterCell.func_77946_l());
            } else {
                ++this.hydrogenSlot.get().field_77994_a;
            }
            return true;
        }
        return false;
    }

    public boolean power() {
        if (this.energy > 0) {
            int out = Math.min(this.energy, this.processRate());
            this.energy = (short)(this.energy - out);
            this.mfe.energy += out;
            return false;
        }
        this.energy = (short)(this.energy + (12000 + 2000 * this.mfe.tier));
        this.hydrogenSlot.consume(1);
        if (this.waterSlot.isEmpty()) {
            this.waterSlot.put(Ic2Items.waterCell.func_77946_l());
        } else {
            ++this.waterSlot.get().field_77994_a;
        }
        return true;
    }

    public int processRate() {
        switch (this.mfe.tier) {
            default: {
                return 2;
            }
            case 2: {
                return 8;
            }
            case 3: 
        }
        return 32;
    }

    public TileEntityElectricBlock lookForMFE() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + dir.offsetX, this.field_70330_m + dir.offsetY, this.field_70327_n + dir.offsetZ);
            if (!(te instanceof TileEntityElectricBlock)) continue;
            return (TileEntityElectricBlock)te;
        }
        return null;
    }

    public int gaugeEnergyScaled(int i) {
        if (this.energy <= 0) {
            return 0;
        }
        int r = this.energy * i / 20000;
        if (r > i) {
            r = i;
        }
        return r;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerElectrolyzer(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiElectrolyzer(new ContainerElectrolyzer(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }
}

