/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.invslot;

import ic2.core.block.TileEntityInventory;
import ic2.core.util.StackUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InvSlot {
    public final TileEntityInventory base;
    public final String name;
    public final int oldStartIndex;
    private final ItemStack[] contents;
    protected final Access access;
    public final InvSide preferredSide;

    public InvSlot(TileEntityInventory base, String name, int oldStartIndex, Access access, int count) {
        this(base, name, oldStartIndex, access, count, InvSide.ANY);
    }

    public InvSlot(TileEntityInventory base, String name, int oldStartIndex, Access access, int count, InvSide preferredSide) {
        this.contents = new ItemStack[count];
        this.base = base;
        this.name = name;
        this.oldStartIndex = oldStartIndex;
        this.access = access;
        this.preferredSide = preferredSide;
        base.addInvSlot(this);
    }

    public void readFromNbt(NBTTagCompound nbtTagCompound) {
        NBTTagList contentsTag = nbtTagCompound.func_74761_m("Contents");
        for (int i = 0; i < contentsTag.func_74745_c(); ++i) {
            NBTTagCompound contentTag = (NBTTagCompound)contentsTag.func_74743_b(i);
            int index = contentTag.func_74771_c("Index") & 0xFF;
            this.put(index, ItemStack.func_77949_a((NBTTagCompound)contentTag));
        }
    }

    public void writeToNbt(NBTTagCompound nbtTagCompound) {
        NBTTagList contentsTag = new NBTTagList();
        for (int i = 0; i < this.contents.length; ++i) {
            if (this.contents[i] == null) continue;
            NBTTagCompound contentTag = new NBTTagCompound();
            contentTag.func_74774_a("Index", (byte)i);
            this.contents[i].func_77955_b(contentTag);
            contentsTag.func_74742_a((NBTBase)contentTag);
        }
        nbtTagCompound.func_74782_a("Contents", (NBTBase)contentsTag);
    }

    public int size() {
        return this.contents.length;
    }

    public ItemStack get() {
        return this.get(0);
    }

    public ItemStack get(int index) {
        return this.contents[index];
    }

    public void put(ItemStack content) {
        this.put(0, content);
    }

    public void put(int index, ItemStack content) {
        this.contents[index] = content;
    }

    public void clear() {
        for (int i = 0; i < this.contents.length; ++i) {
            this.contents[i] = null;
        }
    }

    public boolean accepts(ItemStack itemStack) {
        return true;
    }

    public boolean canInput() {
        return this.access == Access.I || this.access == Access.IO;
    }

    public boolean canOutput() {
        return this.access == Access.O || this.access == Access.IO;
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.contents) {
            if (itemStack == null) continue;
            return false;
        }
        return true;
    }

    public void organize() {
        block0: for (int dstIndex = 0; dstIndex < this.contents.length - 1; ++dstIndex) {
            ItemStack dst = this.contents[dstIndex];
            if (dst != null && dst.field_77994_a >= dst.func_77976_d()) continue;
            for (int srcIndex = dstIndex + 1; srcIndex < this.contents.length; ++srcIndex) {
                ItemStack src = this.contents[srcIndex];
                if (src == null) continue;
                if (dst == null) {
                    this.contents[srcIndex] = null;
                    this.contents[dstIndex] = dst = src;
                    continue;
                }
                if (!StackUtil.isStackEqual(dst, src)) continue;
                int space = dst.func_77976_d() - dst.field_77994_a;
                if (src.field_77994_a <= space) {
                    this.contents[srcIndex] = null;
                    dst.field_77994_a += src.field_77994_a;
                    continue;
                }
                src.field_77994_a -= space;
                dst.field_77994_a += space;
                continue block0;
            }
        }
    }

    public String toString() {
        String ret = this.name + "[" + this.contents.length + "]: ";
        for (int i = 0; i < this.contents.length; ++i) {
            ret = ret + this.contents[i];
            if (i >= this.contents.length - 1) continue;
            ret = ret + ", ";
        }
        return ret;
    }

    public static enum InvSide {
        ANY,
        TOP,
        BOTTOM,
        SIDE;


        public boolean matches(int side) {
            return this == ANY || side == 0 && this == BOTTOM || side == 1 && this == TOP || side >= 2 && side <= 5 && this == SIDE;
        }
    }

    public static enum Access {
        NONE,
        I,
        O,
        IO;

    }
}

