/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import java.lang.reflect.Array;

public class HashEntry {
    public final Object key;
    final int hash;
    HashEntry next;

    public HashEntry(Object key) {
        this.key = key;
        this.hash = key.hashCode();
    }

    public HashEntry next() {
        return this.next;
    }

    public static HashEntry get(HashEntry[] table, Object key) {
        Object k;
        int hash = key.hashCode();
        HashEntry e = table[hash & table.length - 1];
        while (e != null && (e.hash != hash || (k = e.key) != key && !key.equals(k))) {
            e = e.next;
        }
        return e;
    }

    public static void insertEntry(HashEntry[] table, HashEntry newEntry) {
        int idx = newEntry.hash & table.length - 1;
        newEntry.next = table[idx];
        table[idx] = newEntry;
    }

    public static HashEntry remove(HashEntry[] table, Object key) {
        Object k;
        int hash = key.hashCode();
        int idx = hash & table.length - 1;
        HashEntry e = table[idx];
        HashEntry p = null;
        while (e != null && (e.hash != hash || (k = e.key) != key && !key.equals(k))) {
            p = e;
            e = e.next;
        }
        if (e != null) {
            if (p != null) {
                p.next = e.next;
            } else {
                table[idx] = e.next;
            }
        }
        return e;
    }

    public static void remove(HashEntry[] table, HashEntry entry) {
        int idx = entry.hash & table.length - 1;
        HashEntry e = table[idx];
        if (e == entry) {
            table[idx] = e.next;
        } else {
            do {
                HashEntry p = e;
            } while ((e = e.next) != entry);
            p.next = e.next;
        }
    }

    public static HashEntry[] maybeResizeTable(HashEntry[] table, int usedCount) {
        if (usedCount * 4 > table.length * 3) {
            table = HashEntry.resizeTable(table, table.length * 2);
        }
        return table;
    }

    private static HashEntry[] resizeTable(HashEntry[] table, int newSize) {
        if (newSize < 4 || (newSize & newSize - 1) != 0) {
            throw new IllegalArgumentException("newSize");
        }
        HashEntry[] newTable = (HashEntry[])Array.newInstance(table.getClass().getComponentType(), newSize);
        for (HashEntry e : table) {
            while (e != null) {
                HashEntry ne = e.next;
                int ni = e.hash & newSize - 1;
                e.next = newTable[ni];
                newTable[ni] = e;
                e = ne;
            }
        }
        return newTable;
    }
}

