/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import de.matthiasmann.twl.utils.HashEntry;

public class CascadedHashMap {
    private Entry[] table;
    private int size;
    private CascadedHashMap fallback;

    public Object get(Object key) {
        Entry entry = CascadedHashMap.getEntry(this, key);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Object oldValue = null;
        if (this.table != null) {
            Entry entry = (Entry)HashEntry.get(this.table, key);
            if (entry != null) {
                oldValue = entry.value;
                entry.value = value;
                return oldValue;
            }
            if (this.fallback != null) {
                oldValue = this.fallback.get(key);
            }
        }
        this.insertEntry(key, value);
        return oldValue;
    }

    public void collapseAndSetFallback(CascadedHashMap map) {
        if (this.fallback != null) {
            this.collapsePutAll(this.fallback);
            this.fallback = null;
        }
        this.fallback = map;
    }

    protected static Entry getEntry(CascadedHashMap map, Object key) {
        do {
            Entry entry;
            if (map.table == null || (entry = (Entry)HashEntry.get(map.table, key)) == null) continue;
            return entry;
        } while ((map = map.fallback) != null);
        return null;
    }

    private void collapsePutAll(CascadedHashMap map) {
        do {
            Entry[] tab;
            if ((tab = map.table) == null) continue;
            int n = tab.length;
            for (int i = 0; i < n; ++i) {
                Entry e = tab[i];
                while (e != null) {
                    if (HashEntry.get(this.table, e.key) == null) {
                        this.insertEntry(e.key, e.value);
                    }
                    e = (Entry)e.next;
                }
            }
        } while ((map = map.fallback) != null);
    }

    private void insertEntry(Object key, Object value) {
        if (this.table == null) {
            this.table = new Entry[16];
        }
        this.table = (Entry[])HashEntry.maybeResizeTable(this.table, ++this.size);
        Entry entry = new Entry(key, value);
        HashEntry.insertEntry(this.table, entry);
    }

    protected static class Entry
    extends HashEntry {
        Object value;

        public Entry(Object key, Object value) {
            super(key);
            this.value = value;
        }
    }
}

