/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.theme;

import de.matthiasmann.twl.DebugHook;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.theme.ParameterMapImpl;
import de.matthiasmann.twl.theme.ThemeManager;
import de.matthiasmann.twl.utils.CascadedHashMap;

class ThemeInfoImpl
extends ParameterMapImpl
implements ThemeInfo {
    private final String name;
    private final CascadedHashMap children;
    boolean maybeUsedFromWildcard;
    String wildcardImportPath;

    public ThemeInfoImpl(ThemeManager manager, String name, ThemeInfoImpl parent) {
        super(manager, parent);
        this.name = name;
        this.children = new CascadedHashMap();
    }

    void copy(ThemeInfoImpl src) {
        super.copy(src);
        this.children.collapseAndSetFallback(src.children);
        this.wildcardImportPath = src.wildcardImportPath;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ThemeInfo getChildTheme(String theme) {
        return this.getChildThemeImpl(theme, true);
    }

    ThemeInfo getChildThemeImpl(String theme, boolean useFallback) {
        ThemeInfo info = (ThemeInfo)this.children.get(theme);
        if (info == null) {
            if (this.wildcardImportPath != null) {
                info = this.manager.resolveWildcard(this.wildcardImportPath, theme, useFallback);
            }
            if (info == null && useFallback) {
                DebugHook.getDebugHook().missingChildTheme(this, theme);
            }
        }
        return info;
    }

    final ThemeInfoImpl getTheme(String name) {
        return (ThemeInfoImpl)this.children.get(name);
    }

    void putTheme(String name, ThemeInfoImpl child) {
        this.children.put(name, child);
    }

    @Override
    public String getThemePath() {
        return this.getThemePath(0).toString();
    }

    private StringBuilder getThemePath(int length) {
        StringBuilder sb;
        length += this.getName().length();
        if (this.parent != null) {
            sb = this.parent.getThemePath(length + 1);
            sb.append('.');
        } else {
            sb = new StringBuilder(length);
        }
        sb.append(this.getName());
        return sb;
    }
}

