/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.theme;

import de.matthiasmann.twl.Border;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.theme.HasBorder;

class ComposedImage
implements Image,
HasBorder {
    private final Image[] layers;
    private final Border border;

    public ComposedImage(Image[] layers, Border border) {
        this.layers = layers;
        this.border = border;
    }

    @Override
    public void draw(AnimationState as, int x, int y) {
        this.draw(as, x, y, this.getWidth(), this.getHeight());
    }

    @Override
    public void draw(AnimationState as, int x, int y, int width, int height) {
        for (Image layer : this.layers) {
            layer.draw(as, x, y, width, height);
        }
    }

    @Override
    public int getHeight() {
        return this.layers[0].getHeight();
    }

    @Override
    public int getWidth() {
        return this.layers[0].getWidth();
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public Image createTintedVersion(Color color) {
        Image[] newLayers = new Image[this.layers.length];
        for (int i = 0; i < newLayers.length; ++i) {
            newLayers[i] = this.layers[i].createTintedVersion(color);
        }
        return new ComposedImage(newLayers, this.border);
    }
}

