/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.textarea;

import de.matthiasmann.twl.textarea.StyleAttribute;
import de.matthiasmann.twl.textarea.StyleSheetKey;
import de.matthiasmann.twl.textarea.StyleSheetResolver;
import java.util.HashMap;
import java.util.Map;

public class Style {
    private final Style parent;
    private final StyleSheetKey styleSheetKey;
    private Object[] values;

    public Style() {
        this(null, null);
    }

    public Style(Style parent, StyleSheetKey styleSheetKey) {
        this.parent = parent;
        this.styleSheetKey = styleSheetKey;
    }

    public Style(Style parent, StyleSheetKey styleSheetKey, Map values) {
        this(parent, styleSheetKey);
        if (values != null) {
            this.putAll(values);
        }
    }

    protected Style(Style src) {
        this.parent = src.parent;
        this.styleSheetKey = src.styleSheetKey;
        this.values = src.values != null ? (Object[])src.values.clone() : null;
    }

    public Style resolve(StyleAttribute attribute, StyleSheetResolver resolver) {
        if (!attribute.isInherited()) {
            return this;
        }
        return Style.doResolve(this, attribute.ordinal(), resolver);
    }

    private static Style doResolve(Style style, int ord, StyleSheetResolver resolver) {
        while (style.parent != null) {
            Style styleSheetStyle;
            if (style.rawGet(ord) != null) {
                return style;
            }
            if (resolver != null && style.styleSheetKey != null && (styleSheetStyle = resolver.resolve(style)) != null && styleSheetStyle.rawGet(ord) != null) {
                return style;
            }
            style = style.parent;
        }
        return style;
    }

    public Object getNoResolve(StyleAttribute attribute, StyleSheetResolver resolver) {
        Object value = this.rawGet(attribute.ordinal());
        if (value == null) {
            Style styleSheetStyle;
            if (resolver != null && this.styleSheetKey != null && (styleSheetStyle = resolver.resolve(this)) != null) {
                value = styleSheetStyle.rawGet(attribute.ordinal());
            }
            if (value == null) {
                return attribute.getDefaultValue();
            }
        }
        return attribute.getDataType().cast(value);
    }

    public Object get(StyleAttribute attribute, StyleSheetResolver resolver) {
        return this.resolve(attribute, resolver).getNoResolve(attribute, resolver);
    }

    public Object getRaw(StyleAttribute attribute) {
        Object value = this.rawGet(attribute.ordinal());
        return attribute.getDataType().cast(value);
    }

    public Style getParent() {
        return this.parent;
    }

    public StyleSheetKey getStyleSheetKey() {
        return this.styleSheetKey;
    }

    public Style with(Map values) {
        Style newStyle = new Style(this);
        newStyle.putAll(values);
        return newStyle;
    }

    public Style with(StyleAttribute attribute, Object value) {
        Style newStyle = new Style(this);
        newStyle.put(attribute, value);
        return newStyle;
    }

    public Style withoutNonInheritable() {
        if (this.values != null) {
            int n = this.values.length;
            for (int i = 0; i < n; ++i) {
                if (this.values[i] == null || StyleAttribute.getAttribute(i).isInherited()) continue;
                return this.withoutNonInheritableCopy();
            }
        }
        return this;
    }

    private Style withoutNonInheritableCopy() {
        Style result = new Style(this.parent, this.styleSheetKey);
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            StyleAttribute attribute;
            Object value = this.values[i];
            if (value == null || !(attribute = StyleAttribute.getAttribute(i)).isInherited()) continue;
            result.put(attribute, value);
        }
        return result;
    }

    protected void put(StyleAttribute attribute, Object value) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        if (value == null) {
            if (this.values == null) {
                return;
            }
        } else {
            if (!attribute.getDataType().isInstance(value)) {
                throw new IllegalArgumentException("value is a " + value.getClass() + " but must be a " + attribute.getDataType());
            }
            this.ensureValues();
        }
        this.values[attribute.ordinal()] = value;
    }

    protected final void putAll(Map values) {
        for (Map.Entry e : values.entrySet()) {
            this.put((StyleAttribute)e.getKey(), e.getValue());
        }
    }

    protected final void putAll(Style src) {
        if (src.values != null) {
            this.ensureValues();
            int n = this.values.length;
            for (int i = 0; i < n; ++i) {
                Object value = src.values[i];
                if (value == null) continue;
                this.values[i] = value;
            }
        }
    }

    protected final void ensureValues() {
        if (this.values == null) {
            this.values = new Object[StyleAttribute.getNumAttributes()];
        }
    }

    protected final Object rawGet(int idx) {
        Object[] vals = this.values;
        if (vals != null) {
            return vals[idx];
        }
        return null;
    }

    public Map toMap() {
        HashMap<StyleAttribute, Object> result = new HashMap<StyleAttribute, Object>();
        for (int ord = 0; ord < this.values.length; ++ord) {
            Object value = this.values[ord];
            if (value == null) continue;
            result.put(StyleAttribute.getAttribute(ord), value);
        }
        return result;
    }
}

