/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer;

import de.matthiasmann.twl.Color;
import java.util.HashMap;

public final class FontParameter {
    static final HashMap parameterMap = new HashMap();
    public static final Parameter COLOR = FontParameter.newParameter("color", Color.WHITE);
    public static final Parameter UNDERLINE = FontParameter.newParameter("underline", false);
    public static final Parameter LINETHROUGH = FontParameter.newParameter("linethrough", false);
    private Object[] values;

    public FontParameter() {
        this.values = new Object[8];
    }

    public FontParameter(FontParameter base) {
        this.values = (Object[])base.values.clone();
    }

    public void put(Parameter param, Object value) {
        if (param == null) {
            throw new NullPointerException("type");
        }
        if (value != null && !param.dataClass.isInstance(value)) {
            throw new ClassCastException("value");
        }
        int ordinal = param.ordinal;
        int curLength = this.values.length;
        if (ordinal >= curLength) {
            Object[] tmp = new Object[Math.max(ordinal + 1, curLength * 2)];
            System.arraycopy(this.values, 0, tmp, 0, curLength);
            this.values = tmp;
        }
        this.values[ordinal] = value;
    }

    public Object get(Parameter param) {
        Object raw;
        if (param.ordinal < this.values.length && (raw = this.values[param.ordinal]) != null) {
            return param.dataClass.cast(raw);
        }
        return param.defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Parameter[] getRegisteredParameter() {
        HashMap hashMap = parameterMap;
        synchronized (hashMap) {
            return parameterMap.values().toArray(new Parameter[parameterMap.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Parameter getParameter(String name) {
        HashMap hashMap = parameterMap;
        synchronized (hashMap) {
            return (Parameter)parameterMap.get(name);
        }
    }

    public static Parameter newParameter(String name, Object defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue");
        }
        Class<?> dataClass = defaultValue.getClass();
        return FontParameter.newParameter(name, dataClass, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Parameter newParameter(String name, Class dataClass, Object defaultValue) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (dataClass == null) {
            throw new NullPointerException("dataClass");
        }
        HashMap hashMap = parameterMap;
        synchronized (hashMap) {
            Parameter existing = (Parameter)parameterMap.get(name);
            if (existing != null) {
                if (existing.dataClass != dataClass || !FontParameter.equals(existing.defaultValue, defaultValue)) {
                    throw new IllegalStateException("type '" + name + "' already registered but different");
                }
                Parameter type = existing;
                return type;
            }
            Parameter type = new Parameter(name, dataClass, defaultValue, parameterMap.size());
            parameterMap.put(name, type);
            return type;
        }
    }

    private static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static final class Parameter {
        final String name;
        final Class dataClass;
        final Object defaultValue;
        final int ordinal;

        Parameter(String name, Class dataClass, Object defaultValue, int ordinal) {
            this.name = name;
            this.dataClass = dataClass;
            this.defaultValue = defaultValue;
            this.ordinal = ordinal;
        }

        public final String getName() {
            return this.name;
        }

        public final Class getDataClass() {
            return this.dataClass;
        }

        public final Object getDefaultValue() {
            return this.defaultValue;
        }

        public String toString() {
            return this.ordinal + ":" + this.name + ":" + this.dataClass.getSimpleName();
        }
    }
}

