/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.ObservableCharSequence;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.AttributedString;
import java.util.ArrayList;
import java.util.BitSet;

public class StringAttributes
implements AttributedString {
    private final CharSequence seq;
    private final AnimationState baseAnimState;
    private final ArrayList markers;
    private int position;
    private int markerIdx;
    private static final int NOT_FOUND = Integer.MIN_VALUE;
    private static final int IDX_MASK = Integer.MAX_VALUE;

    private StringAttributes(AnimationState baseAnimState, CharSequence seq) {
        if (seq == null) {
            throw new NullPointerException("seq");
        }
        this.seq = seq;
        this.baseAnimState = baseAnimState;
        this.markers = new ArrayList();
    }

    public StringAttributes(String text, AnimationState baseAnimState) {
        this(baseAnimState, text);
    }

    public StringAttributes(String text) {
        this(text, null);
    }

    public StringAttributes(ObservableCharSequence cs, AnimationState baseAnimState) {
        this(baseAnimState, cs);
        cs.addCallback(new ObservableCharSequence.Callback(){

            @Override
            public void charactersChanged(int start, int oldCount, int newCount) {
                if (start < 0) {
                    throw new IllegalArgumentException("start");
                }
                if (oldCount > 0) {
                    StringAttributes.this.delete(start, oldCount);
                }
                if (newCount > 0) {
                    StringAttributes.this.insert(start, newCount);
                }
            }
        });
    }

    public StringAttributes(ObservableCharSequence cs) {
        this(cs, null);
    }

    @Override
    public char charAt(int index) {
        return this.seq.charAt(index);
    }

    @Override
    public int length() {
        return this.seq.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.seq.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.seq.toString();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int pos) {
        if (pos < 0 || pos > this.seq.length()) {
            throw new IllegalArgumentException("pos");
        }
        this.position = pos;
        int idx = this.find(pos);
        this.markerIdx = idx >= 0 ? idx : (pos > this.lastMarkerPos() ? this.markers.size() : (idx & Integer.MAX_VALUE) - 1);
    }

    @Override
    public int advance() {
        if (this.markerIdx + 1 < this.markers.size()) {
            ++this.markerIdx;
            this.position = ((Marker)this.markers.get((int)this.markerIdx)).position;
        } else {
            this.position = this.seq.length();
        }
        return this.position;
    }

    @Override
    public boolean getAnimationState(AnimationState.StateKey state) {
        int bitIdx;
        Marker marker;
        if (this.markerIdx >= 0 && this.markerIdx < this.markers.size() && (marker = (Marker)this.markers.get(this.markerIdx)).get(bitIdx = state.getID() << 1)) {
            return marker.get(bitIdx + 1);
        }
        if (this.baseAnimState != null) {
            return this.baseAnimState.getAnimationState(state);
        }
        return false;
    }

    @Override
    public int getAnimationTime(AnimationState.StateKey state) {
        if (this.baseAnimState != null) {
            return this.baseAnimState.getAnimationTime(state);
        }
        return 0;
    }

    @Override
    public boolean getShouldAnimateState(AnimationState.StateKey state) {
        if (this.baseAnimState != null) {
            return this.baseAnimState.getShouldAnimateState(state);
        }
        return false;
    }

    public void setAnimationState(AnimationState.StateKey key, int from, int end, boolean active) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (from > end) {
            throw new IllegalArgumentException("negative range");
        }
        if (from < 0 || end > this.seq.length()) {
            throw new IllegalArgumentException("range outside of sequence");
        }
        if (from == end) {
            return;
        }
        int fromIdx = this.markerIndexAt(from);
        int endIdx = this.markerIndexAt(end);
        int bitIdx = key.getID() << 1;
        for (int i = fromIdx; i < endIdx; ++i) {
            Marker m = (Marker)this.markers.get(i);
            m.set(bitIdx);
            m.set(bitIdx + 1, active);
        }
    }

    public void removeAnimationState(AnimationState.StateKey key, int from, int end) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (from > end) {
            throw new IllegalArgumentException("negative range");
        }
        if (from < 0 || end > this.seq.length()) {
            throw new IllegalArgumentException("range outside of sequence");
        }
        if (from == end) {
            return;
        }
        int fromIdx = this.markerIndexAt(from);
        int endIdx = this.markerIndexAt(end);
        this.removeRange(fromIdx, endIdx, key);
    }

    public void removeAnimationState(AnimationState.StateKey key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.removeRange(0, this.markers.size(), key);
    }

    private void removeRange(int start, int end, AnimationState.StateKey key) {
        int bitIdx = key.getID() << 1;
        for (int i = start; i < end; ++i) {
            ((Marker)this.markers.get(i)).clear(bitIdx);
            ((Marker)this.markers.get(i)).clear(bitIdx + 1);
        }
    }

    public void clearAnimationStates() {
        this.markers.clear();
    }

    public void optimize() {
        if (this.markers.size() > 1) {
            Marker prev = (Marker)this.markers.get(0);
            int i = 1;
            while (i < this.markers.size()) {
                Marker cur = (Marker)this.markers.get(i);
                if (prev.equals(cur)) {
                    this.markers.remove(i);
                    continue;
                }
                prev = cur;
                ++i;
            }
        }
    }

    void insert(int pos, int count) {
        int end = this.markers.size();
        for (int idx = this.find(pos) & Integer.MAX_VALUE; idx < end; ++idx) {
            ((Marker)this.markers.get((int)idx)).position += count;
        }
    }

    void delete(int pos, int count) {
        int idx;
        int startIdx;
        int removeIdx = startIdx = this.find(pos) & Integer.MAX_VALUE;
        int end = this.markers.size();
        for (idx = startIdx; idx < end; ++idx) {
            Marker m = (Marker)this.markers.get(idx);
            int newPos = m.position - count;
            if (newPos <= pos) {
                newPos = pos;
                removeIdx = idx;
            }
            m.position = newPos;
        }
        idx = removeIdx;
        while (idx > startIdx) {
            this.markers.remove(--idx);
        }
    }

    private int lastMarkerPos() {
        int numMarkers = this.markers.size();
        if (numMarkers > 0) {
            return ((Marker)this.markers.get((int)(numMarkers - 1))).position;
        }
        return 0;
    }

    private int markerIndexAt(int pos) {
        int idx = this.find(pos);
        if (idx < 0) {
            this.insertMarker(idx &= Integer.MAX_VALUE, pos);
        }
        return idx;
    }

    private void insertMarker(int idx, int pos) {
        Marker newMarker = new Marker();
        if (idx > 0) {
            Marker leftMarker = (Marker)this.markers.get(idx - 1);
            assert (leftMarker.position < pos);
            newMarker.or(leftMarker);
        }
        newMarker.position = pos;
        this.markers.add(idx, newMarker);
    }

    private int find(int pos) {
        int lo = 0;
        int hi = this.markers.size();
        while (lo < hi) {
            int mid = lo + hi >>> 1;
            int markerPos = ((Marker)this.markers.get((int)mid)).position;
            if (pos < markerPos) {
                hi = mid;
                continue;
            }
            if (pos > markerPos) {
                lo = mid + 1;
                continue;
            }
            return mid;
        }
        return lo | Integer.MIN_VALUE;
    }

    static class Marker
    extends BitSet {
        int position;

        Marker() {
        }
    }
}

