/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.AbstractProperty;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.PropertyList;
import java.util.ArrayList;
import java.util.Arrays;

public class SimplePropertyList
extends AbstractProperty
implements PropertyList {
    private final String name;
    private final ArrayList properties;

    public SimplePropertyList(String name) {
        this.name = name;
        this.properties = new ArrayList();
    }

    public SimplePropertyList(String name, Property ... properties) {
        this(name);
        this.properties.addAll(Arrays.asList(properties));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean canBeNull() {
        return false;
    }

    @Override
    public PropertyList getPropertyValue() {
        return this;
    }

    public void setPropertyValue(PropertyList value) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Class getType() {
        return PropertyList.class;
    }

    @Override
    public int getNumProperties() {
        return this.properties.size();
    }

    @Override
    public Property getProperty(int idx) {
        return (Property)this.properties.get(idx);
    }

    public void addProperty(Property property) {
        this.properties.add(property);
        this.fireValueChangedCallback();
    }

    public void addProperty(int idx, Property property) {
        this.properties.add(idx, property);
        this.fireValueChangedCallback();
    }

    public void removeProperty(int idx) {
        this.properties.remove(idx);
        this.fireValueChangedCallback();
    }

    public void removeAllProperties() {
        this.properties.clear();
        this.fireValueChangedCallback();
    }
}

