/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.ListModel;
import de.matthiasmann.twl.model.MRUListModel;
import de.matthiasmann.twl.utils.CallbackSupport;
import java.util.ArrayList;

public class SimpleMRUListModel
implements MRUListModel {
    protected final ArrayList entries;
    protected final int maxEntries;
    protected ListModel.ChangeListener[] listeners;

    public SimpleMRUListModel(int maxEntries) {
        if (maxEntries <= 1) {
            throw new IllegalArgumentException("maxEntries <= 1");
        }
        this.entries = new ArrayList();
        this.maxEntries = maxEntries;
    }

    @Override
    public int getMaxEntries() {
        return this.maxEntries;
    }

    @Override
    public int getNumEntries() {
        return this.entries.size();
    }

    @Override
    public Object getEntry(int index) {
        return this.entries.get(index);
    }

    @Override
    public void addEntry(Object entry) {
        int idx = this.entries.indexOf(entry);
        if (idx >= 0) {
            this.doDeleteEntry(idx);
        } else if (this.entries.size() == this.maxEntries) {
            this.doDeleteEntry(this.maxEntries - 1);
        }
        this.entries.add(0, entry);
        if (this.listeners != null) {
            for (ListModel.ChangeListener cl : this.listeners) {
                cl.entriesInserted(0, 0);
            }
        }
        this.saveEntries();
    }

    @Override
    public void removeEntry(int index) {
        if (index < 0 && index >= this.entries.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.doDeleteEntry(index);
        this.saveEntries();
    }

    @Override
    public void addChangeListener(ListModel.ChangeListener listener) {
        this.listeners = (ListModel.ChangeListener[])CallbackSupport.addCallbackToList(this.listeners, listener, ListModel.ChangeListener.class);
    }

    @Override
    public void removeChangeListener(ListModel.ChangeListener listener) {
        this.listeners = (ListModel.ChangeListener[])CallbackSupport.removeCallbackFromList((Object[])this.listeners, listener);
    }

    protected void doDeleteEntry(int idx) {
        this.entries.remove(idx);
        if (this.listeners != null) {
            for (ListModel.ChangeListener cl : this.listeners) {
                cl.entriesDeleted(idx, idx);
            }
        }
    }

    protected void saveEntries() {
    }

    @Override
    public Object getEntryTooltip(int index) {
        return null;
    }

    @Override
    public boolean matchPrefix(int index, String prefix) {
        return false;
    }
}

