/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.AbstractEnumModel;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class PersistentEnumModel
extends AbstractEnumModel {
    private final Preferences prefs;
    private final String prefKey;
    private Enum value;

    public PersistentEnumModel(Preferences prefs, String prefKey, Enum defaultValue) {
        this(prefs, prefKey, defaultValue.getDeclaringClass(), defaultValue);
    }

    public PersistentEnumModel(Preferences prefs, String prefKey, Class enumClass, Enum defaultValue) {
        super(enumClass);
        if (prefs == null) {
            throw new NullPointerException("prefs");
        }
        if (prefKey == null) {
            throw new NullPointerException("prefKey");
        }
        if (defaultValue == null) {
            throw new NullPointerException("value");
        }
        this.prefs = prefs;
        this.prefKey = prefKey;
        Enum storedValue = defaultValue;
        String storedStr = prefs.get(prefKey, null);
        if (storedStr != null) {
            try {
                storedValue = Enum.valueOf(enumClass, storedStr);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(PersistentEnumModel.class.getName()).log(Level.WARNING, "Unable to parse value '" + storedStr + "' of key '" + prefKey + "' of type " + enumClass, ex);
            }
        }
        this.setValue(storedValue);
    }

    @Override
    public Enum getValue() {
        return this.value;
    }

    @Override
    public void setValue(Enum value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (this.value != value) {
            this.value = value;
            this.storeSetting();
            this.doCallback();
        }
    }

    private void storeSetting() {
        if (this.prefs != null) {
            this.prefs.put(this.prefKey, this.value.name());
        }
    }
}

