/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.AbstractTreeTableModel;
import de.matthiasmann.twl.model.FileSystemModel;
import de.matthiasmann.twl.model.TreeTableNode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;

public class FileSystemTreeModel
extends AbstractTreeTableModel {
    private final FileSystemModel fsm;
    private final boolean includeLastModified;
    protected Comparator sorter;
    static final FolderNode[] NO_CHILDREN = new FolderNode[0];

    public FileSystemTreeModel(FileSystemModel fsm, boolean includeLastModified) {
        this.fsm = fsm;
        this.includeLastModified = includeLastModified;
        this.insertRoots();
    }

    public FileSystemTreeModel(FileSystemModel fsm) {
        this(fsm, false);
    }

    @Override
    public int getNumColumns() {
        return this.includeLastModified ? 2 : 1;
    }

    @Override
    public String getColumnHeaderText(int column) {
        switch (column) {
            case 0: {
                return "Folder";
            }
            case 1: {
                return "Last modified";
            }
        }
        return "";
    }

    public FileSystemModel getFileSystemModel() {
        return this.fsm;
    }

    public void insertRoots() {
        this.removeAllChildren();
        for (Object root : this.fsm.listRoots()) {
            this.insertChild(new FolderNode(this, this.fsm, root), this.getNumChildren());
        }
    }

    public FolderNode getNodeForFolder(Object obj) {
        Object parent = this.fsm.getParent(obj);
        TreeTableNode parentNode = parent == null ? this : this.getNodeForFolder(parent);
        if (parentNode != null) {
            for (int i = 0; i < parentNode.getNumChildren(); ++i) {
                FolderNode node = (FolderNode)parentNode.getChild(i);
                if (!this.fsm.equals(node.folder, obj)) continue;
                return node;
            }
        }
        return null;
    }

    public Comparator getSorter() {
        return this.sorter;
    }

    public void setSorter(Comparator sorter) {
        if (this.sorter != sorter) {
            this.sorter = sorter;
            this.insertRoots();
        }
    }

    public static final class FolderFilter
    implements FileSystemModel.FileFilter {
        public static final FolderFilter instance = new FolderFilter();

        @Override
        public boolean accept(FileSystemModel model, Object file) {
            return model.isFolder(file);
        }
    }

    public static class FolderNode
    implements TreeTableNode {
        private final TreeTableNode parent;
        private final FileSystemModel fsm;
        final Object folder;
        FolderNode[] children;

        protected FolderNode(TreeTableNode parent, FileSystemModel fsm, Object folder) {
            this.parent = parent;
            this.fsm = fsm;
            this.folder = folder;
        }

        public Object getFolder() {
            return this.folder;
        }

        @Override
        public Object getData(int column) {
            switch (column) {
                case 0: {
                    return this.fsm.getName(this.folder);
                }
                case 1: {
                    return this.getlastModified();
                }
            }
            return null;
        }

        @Override
        public Object getTooltipContent(int column) {
            StringBuilder sb = new StringBuilder(this.fsm.getPath(this.folder));
            Date lastModified = this.getlastModified();
            if (lastModified != null) {
                sb.append("\nLast modified: ").append(lastModified);
            }
            return sb.toString();
        }

        @Override
        public TreeTableNode getChild(int idx) {
            return this.children[idx];
        }

        @Override
        public int getChildIndex(TreeTableNode child) {
            int n = this.children.length;
            for (int i = 0; i < n; ++i) {
                if (this.children[i] != child) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getNumChildren() {
            if (this.children == null) {
                this.collectChilds();
            }
            return this.children.length;
        }

        @Override
        public TreeTableNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public FileSystemTreeModel getTreeModel() {
            TreeTableNode nodeParent;
            TreeTableNode node = this.parent;
            while ((nodeParent = node.getParent()) != null) {
                node = nodeParent;
            }
            return (FileSystemTreeModel)node;
        }

        private void collectChilds() {
            this.children = NO_CHILDREN;
            try {
                Object[] subFolder = this.fsm.listFolder(this.folder, FolderFilter.instance);
                if (subFolder != null && subFolder.length > 0) {
                    Comparator sorter = this.getTreeModel().sorter;
                    if (sorter != null) {
                        Arrays.sort(subFolder, sorter);
                    }
                    FolderNode[] newChildren = new FolderNode[subFolder.length];
                    for (int i = 0; i < subFolder.length; ++i) {
                        newChildren[i] = new FolderNode(this, this.fsm, subFolder[i]);
                    }
                    this.children = newChildren;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private Date getlastModified() {
            if (this.parent instanceof FileSystemTreeModel) {
                return null;
            }
            return new Date(this.fsm.getLastModified(this.folder));
        }
    }
}

