/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.AbstractTreeTableModel;
import de.matthiasmann.twl.model.TreeTableNode;
import java.util.ArrayList;

public abstract class AbstractTreeTableNode
implements TreeTableNode {
    private final TreeTableNode parent;
    private ArrayList children;
    private boolean leaf;

    protected AbstractTreeTableNode(TreeTableNode parent) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        this.parent = parent;
        assert (this.getTreeTableModel() != null);
    }

    @Override
    public Object getTooltipContent(int column) {
        return null;
    }

    @Override
    public final TreeTableNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    @Override
    public int getNumChildren() {
        return this.children != null ? this.children.size() : 0;
    }

    @Override
    public TreeTableNode getChild(int idx) {
        return (TreeTableNode)this.children.get(idx);
    }

    @Override
    public int getChildIndex(TreeTableNode child) {
        if (this.children != null) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                if (this.children.get(i) != child) continue;
                return i;
            }
        }
        return -1;
    }

    protected void setLeaf(boolean leaf) {
        if (this.leaf != leaf) {
            this.leaf = leaf;
            this.fireNodeChanged();
        }
    }

    protected void insertChild(TreeTableNode node, int idx) {
        assert (this.getChildIndex(node) < 0);
        assert (node.getParent() == this);
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(idx, node);
        this.getTreeTableModel().fireNodesAdded(this, idx, 1);
    }

    protected void removeChild(int idx) {
        this.children.remove(idx);
        this.getTreeTableModel().fireNodesRemoved(this, idx, 1);
    }

    protected void removeAllChildren() {
        if (this.children != null) {
            int count = this.children.size();
            this.children.clear();
            this.getTreeTableModel().fireNodesRemoved(this, 0, count);
        }
    }

    protected AbstractTreeTableModel getTreeTableModel() {
        TreeTableNode n = this.parent;
        TreeTableNode p;
        while ((p = n.getParent()) != null) {
            n = p;
        }
        return (AbstractTreeTableModel)n;
    }

    protected void fireNodeChanged() {
        int selfIdxInParent = this.parent.getChildIndex(this);
        if (selfIdxInParent >= 0) {
            this.getTreeTableModel().fireNodesChanged(this.parent, selfIdxInParent, 1);
        }
    }
}

