/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.utils.CallbackSupport;

public abstract class AbstractOptionModel
implements BooleanModel {
    Runnable[] callbacks;
    Runnable srcCallback;

    @Override
    public void addCallback(Runnable callback) {
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        if (this.callbacks == null) {
            this.srcCallback = new Runnable(){
                boolean lastValue;
                {
                    this.lastValue = AbstractOptionModel.this.getValue();
                }

                @Override
                public void run() {
                    boolean value = AbstractOptionModel.this.getValue();
                    if (this.lastValue != value) {
                        this.lastValue = value;
                        CallbackSupport.fireCallbacks(AbstractOptionModel.this.callbacks);
                    }
                }
            };
            this.callbacks = new Runnable[]{callback};
            this.installSrcCallback(this.srcCallback);
        } else {
            this.callbacks = (Runnable[])CallbackSupport.addCallbackToList(this.callbacks, callback, Runnable.class);
        }
    }

    @Override
    public void removeCallback(Runnable callback) {
        this.callbacks = (Runnable[])CallbackSupport.removeCallbackFromList((Object[])this.callbacks, callback);
        if (this.callbacks == null && this.srcCallback != null) {
            this.removeSrcCallback(this.srcCallback);
            this.srcCallback = null;
        }
    }

    protected abstract void installSrcCallback(Runnable var1);

    protected abstract void removeSrcCallback(Runnable var1);
}

