/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.BoxLayout;
import de.matthiasmann.twl.DraggableButton;
import de.matthiasmann.twl.Widget;

public class SplitPane
extends Widget {
    public static final int CENTER = -1;
    public static final int MIN_SIZE = -2;
    public static final int PREFERRED_SIZE = -3;
    private final DraggableButton splitter = new DraggableButton();
    private Direction direction;
    private int splitPosition = -1;
    private boolean reverseSplitPosition;
    private boolean respectMinSizes;

    public SplitPane() {
        this.splitter.setCanAcceptKeyboardFocus(false);
        this.splitter.setListener(new DraggableButton.DragListener(){
            int initialPos;

            @Override
            public void dragStarted() {
                this.initialPos = SplitPane.this.getEffectiveSplitPosition();
            }

            @Override
            public void dragged(int deltaX, int deltaY) {
                SplitPane.this.dragged(this.initialPos, deltaX, deltaY);
            }

            @Override
            public void dragStopped() {
            }
        });
        this.setDirection(Direction.HORIZONTAL);
        this.add(this.splitter);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        if (direction == null) {
            throw new NullPointerException("direction");
        }
        this.direction = direction;
        this.splitter.setTheme(direction.splitterTheme);
    }

    public int getMaxSplitPosition() {
        return Math.max(0, this.direction.get(this.getInnerWidth() - this.splitter.getPreferredWidth(), this.getInnerHeight() - this.splitter.getPreferredHeight()));
    }

    public int getSplitPosition() {
        return this.splitPosition;
    }

    public void setSplitPosition(int pos) {
        if (pos < -3) {
            throw new IllegalArgumentException("pos");
        }
        this.splitPosition = pos;
        this.invalidateLayoutLocally();
    }

    public boolean getReverseSplitPosition() {
        return this.reverseSplitPosition;
    }

    public void setReverseSplitPosition(boolean reverseSplitPosition) {
        if (this.reverseSplitPosition != reverseSplitPosition) {
            this.reverseSplitPosition = reverseSplitPosition;
            this.invalidateLayoutLocally();
        }
    }

    public boolean isRespectMinSizes() {
        return this.respectMinSizes;
    }

    public void setRespectMinSizes(boolean respectMinSizes) {
        if (this.respectMinSizes != respectMinSizes) {
            this.respectMinSizes = respectMinSizes;
            this.invalidateLayoutLocally();
        }
    }

    void dragged(int initialPos, int deltaX, int deltaY) {
        int delta = this.direction.get(deltaX, deltaY);
        if (this.reverseSplitPosition) {
            delta = -delta;
        }
        this.setSplitPosition(this.clamp(initialPos + delta));
    }

    @Override
    protected void childRemoved(Widget exChild) {
        super.childRemoved(exChild);
        if (exChild == this.splitter) {
            this.add(this.splitter);
        }
    }

    @Override
    protected void childAdded(Widget child) {
        super.childAdded(child);
        int numChildren = this.getNumChildren();
        if (numChildren > 0 && this.getChild(numChildren - 1) != this.splitter) {
            this.moveChild(this.getChildIndex(this.splitter), numChildren - 1);
        }
    }

    @Override
    public int getMinWidth() {
        int min = this.direction == Direction.HORIZONTAL ? BoxLayout.computeMinWidthHorizontal(this, 0) : BoxLayout.computeMinWidthVertical(this);
        return Math.max(super.getMinWidth(), min);
    }

    @Override
    public int getMinHeight() {
        int min = this.direction == Direction.HORIZONTAL ? BoxLayout.computeMinHeightHorizontal(this) : BoxLayout.computeMinHeightVertical(this, 0);
        return Math.max(super.getMinHeight(), min);
    }

    @Override
    public int getPreferredInnerWidth() {
        if (this.direction == Direction.HORIZONTAL) {
            return BoxLayout.computePreferredWidthHorizontal(this, 0);
        }
        return BoxLayout.computePreferredWidthVertical(this);
    }

    @Override
    public int getPreferredInnerHeight() {
        if (this.direction == Direction.HORIZONTAL) {
            return BoxLayout.computePreferredHeightHorizontal(this);
        }
        return BoxLayout.computePreferredHeightVertical(this, 0);
    }

    @Override
    protected void layout() {
        Widget a = null;
        Widget b = null;
        for (int i = 0; i < this.getNumChildren(); ++i) {
            Widget w = this.getChild(i);
            if (w == this.splitter) continue;
            if (a == null) {
                a = w;
                continue;
            }
            b = w;
            break;
        }
        int innerX = this.getInnerX();
        int innerY = this.getInnerY();
        int splitPos = this.getEffectiveSplitPosition();
        if (this.reverseSplitPosition) {
            splitPos = this.getMaxSplitPosition() - splitPos;
        }
        switch (this.direction) {
            case HORIZONTAL: {
                int innerHeight = this.getInnerHeight();
                this.splitter.setPosition(innerX + splitPos, innerY);
                this.splitter.setSize(this.splitter.getPreferredWidth(), innerHeight);
                if (a != null) {
                    a.setPosition(innerX, innerY);
                    a.setSize(splitPos, innerHeight);
                }
                if (b == null) break;
                b.setPosition(this.splitter.getRight(), innerY);
                b.setSize(Math.max(0, this.getInnerRight() - this.splitter.getRight()), innerHeight);
                break;
            }
            case VERTICAL: {
                int innerWidth = this.getInnerWidth();
                this.splitter.setPosition(innerX, innerY + splitPos);
                this.splitter.setSize(innerWidth, this.splitter.getPreferredHeight());
                if (a != null) {
                    a.setPosition(innerX, innerY);
                    a.setSize(innerWidth, splitPos);
                }
                if (b == null) break;
                b.setPosition(innerX, this.splitter.getBottom());
                b.setSize(innerWidth, Math.max(0, this.getInnerBottom() - this.splitter.getBottom()));
            }
        }
    }

    int getEffectiveSplitPosition() {
        int maxSplitPosition = this.getMaxSplitPosition();
        int pos = this.splitPosition;
        switch (pos) {
            case -1: {
                pos = maxSplitPosition / 2;
                break;
            }
            case -2: {
                Widget w = this.getPrimaryWidget();
                if (w != null) {
                    pos = this.direction.getMinSize(w);
                    break;
                }
                pos = maxSplitPosition / 2;
                break;
            }
            case -3: {
                Widget w = this.getPrimaryWidget();
                if (w != null) {
                    pos = this.direction.getPrefSize(w);
                    break;
                }
                pos = maxSplitPosition / 2;
                break;
            }
        }
        int minValue = 0;
        int maxValue = maxSplitPosition;
        if (this.respectMinSizes) {
            int bMinSize;
            Widget a = null;
            Widget b = null;
            for (int i = 0; i < this.getNumChildren(); ++i) {
                Widget w = this.getChild(i);
                if (w == this.splitter) continue;
                if (a == null) {
                    a = w;
                    continue;
                }
                b = w;
                break;
            }
            int aMinSize = a != null ? this.direction.getMinSize(a) : 0;
            int n = bMinSize = b != null ? this.direction.getMinSize(b) : 0;
            if (this.reverseSplitPosition) {
                minValue = bMinSize;
                maxValue = Math.max(0, maxSplitPosition - aMinSize);
            } else {
                minValue = aMinSize;
                maxValue = Math.max(0, maxSplitPosition - bMinSize);
            }
        }
        return Math.max(minValue, Math.min(maxValue, pos));
    }

    private Widget getPrimaryWidget() {
        int idx;
        int n = idx = this.reverseSplitPosition ? 1 : 0;
        if (this.getNumChildren() > idx) {
            return this.getChild(idx);
        }
        return null;
    }

    private int clamp(int pos) {
        return Math.max(0, Math.min(this.getMaxSplitPosition(), pos));
    }

    public static enum Direction {
        HORIZONTAL("splitterHorizontal"){

            @Override
            int get(int x, int y) {
                return x;
            }

            @Override
            int getMinSize(Widget w) {
                return w.getMinWidth();
            }

            @Override
            int getPrefSize(Widget w) {
                return w.getPreferredWidth();
            }
        }
        ,
        VERTICAL("splitterVertical"){

            @Override
            int get(int x, int y) {
                return y;
            }

            @Override
            int getMinSize(Widget w) {
                return w.getMinHeight();
            }

            @Override
            int getPrefSize(Widget w) {
                return w.getPreferredHeight();
            }
        };

        final String splitterTheme;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Direction() {
            void splitterTheme;
            this.splitterTheme = splitterTheme;
        }

        abstract int get(int var1, int var2);

        abstract int getMinSize(Widget var1);

        abstract int getPrefSize(Widget var1);

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Direction(String x0, 1 x1) {
            this((String)x0, (int)x1, (String)x2);
            void x2;
        }
    }
}

