/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.Dimension;
import de.matthiasmann.twl.DraggableButton;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Scrollbar;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Timer;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;

public class ScrollPane
extends Widget {
    public static final AnimationState.StateKey STATE_DOWNARROW_ARMED = AnimationState.StateKey.get("downArrowArmed");
    public static final AnimationState.StateKey STATE_RIGHTARROW_ARMED = AnimationState.StateKey.get("rightArrowArmed");
    public static final AnimationState.StateKey STATE_HORIZONTAL_SCROLLBAR_VISIBLE = AnimationState.StateKey.get("horizontalScrollbarVisible");
    public static final AnimationState.StateKey STATE_VERTICAL_SCROLLBAR_VISIBLE = AnimationState.StateKey.get("verticalScrollbarVisible");
    public static final AnimationState.StateKey STATE_AUTO_SCROLL_UP = AnimationState.StateKey.get("autoScrollUp");
    public static final AnimationState.StateKey STATE_AUTO_SCROLL_DOWN = AnimationState.StateKey.get("autoScrollDown");
    private static final int AUTO_SCROLL_DELAY = 50;
    final Scrollbar scrollbarH;
    final Scrollbar scrollbarV;
    private final Widget contentArea;
    private DraggableButton dragButton;
    private Widget content;
    private Fixed fixed = Fixed.NONE;
    private Dimension hscrollbarOffset = Dimension.ZERO;
    private Dimension vscrollbarOffset = Dimension.ZERO;
    private Dimension contentScrollbarSpacing = Dimension.ZERO;
    private boolean inLayout;
    private boolean expandContentSize;
    private boolean scrollbarsAlwaysVisible;
    private int scrollbarsToggleFlags;
    private int autoScrollArea;
    private int autoScrollSpeed;
    private Timer autoScrollTimer;
    private int autoScrollDirection;

    public ScrollPane() {
        this((Widget)null);
    }

    public ScrollPane(Widget content) {
        this.scrollbarH = new Scrollbar(Scrollbar.Orientation.HORIZONTAL);
        this.scrollbarV = new Scrollbar(Scrollbar.Orientation.VERTICAL);
        this.contentArea = new Widget();
        Runnable cb = new Runnable(){

            @Override
            public void run() {
                ScrollPane.this.scrollContent();
            }
        };
        this.scrollbarH.addCallback(cb);
        this.scrollbarH.setVisible(false);
        this.scrollbarV.addCallback(cb);
        this.scrollbarV.setVisible(false);
        this.contentArea.setClip(true);
        this.contentArea.setTheme("");
        super.insertChild(this.contentArea, 0);
        super.insertChild(this.scrollbarH, 1);
        super.insertChild(this.scrollbarV, 2);
        this.setContent(content);
        this.setCanAcceptKeyboardFocus(true);
    }

    public Fixed getFixed() {
        return this.fixed;
    }

    public void setFixed(Fixed fixed) {
        if (fixed == null) {
            throw new NullPointerException("fixed");
        }
        if (this.fixed != fixed) {
            this.fixed = fixed;
            this.invalidateLayout();
        }
    }

    public Widget getContent() {
        return this.content;
    }

    public void setContent(Widget content) {
        if (this.content != null) {
            this.contentArea.removeAllChildren();
            this.content = null;
        }
        if (content != null) {
            this.content = content;
            this.contentArea.add(content);
        }
    }

    public boolean isExpandContentSize() {
        return this.expandContentSize;
    }

    public void setExpandContentSize(boolean expandContentSize) {
        if (this.expandContentSize != expandContentSize) {
            this.expandContentSize = expandContentSize;
            this.invalidateLayoutLocally();
        }
    }

    public void updateScrollbarSizes() {
        this.invalidateLayoutLocally();
        this.validateLayout();
    }

    public int getScrollPositionX() {
        return this.scrollbarH.getValue();
    }

    public int getMaxScrollPosX() {
        return this.scrollbarH.getMaxValue();
    }

    public void setScrollPositionX(int pos) {
        this.scrollbarH.setValue(pos);
    }

    public void scrollToAreaX(int start, int size, int extra) {
        this.scrollbarH.scrollToArea(start, size, extra);
    }

    public int getScrollPositionY() {
        return this.scrollbarV.getValue();
    }

    public int getMaxScrollPosY() {
        return this.scrollbarV.getMaxValue();
    }

    public void setScrollPositionY(int pos) {
        this.scrollbarV.setValue(pos);
    }

    public void scrollToAreaY(int start, int size, int extra) {
        this.scrollbarV.scrollToArea(start, size, extra);
    }

    public int getContentAreaWidth() {
        return this.contentArea.getWidth();
    }

    public int getContentAreaHeight() {
        return this.contentArea.getHeight();
    }

    public Scrollbar getHorizontalScrollbar() {
        return this.scrollbarH;
    }

    public Scrollbar getVerticalScrollbar() {
        return this.scrollbarV;
    }

    public DraggableButton.DragListener createDragListener() {
        return new DraggableButton.DragListener(){
            int startScrollX;
            int startScrollY;

            @Override
            public void dragStarted() {
                this.startScrollX = ScrollPane.this.getScrollPositionX();
                this.startScrollY = ScrollPane.this.getScrollPositionY();
            }

            @Override
            public void dragged(int deltaX, int deltaY) {
                ScrollPane.this.setScrollPositionX(this.startScrollX - deltaX);
                ScrollPane.this.setScrollPositionY(this.startScrollY - deltaY);
            }

            @Override
            public void dragStopped() {
            }
        };
    }

    public boolean checkAutoScroll(Event evt) {
        GUI gui = this.getGUI();
        if (gui == null) {
            this.stopAutoScroll();
            return false;
        }
        this.autoScrollDirection = this.getAutoScrollDirection(evt);
        if (this.autoScrollDirection == 0) {
            this.stopAutoScroll();
            return false;
        }
        this.setAutoScrollMarker();
        if (this.autoScrollTimer == null) {
            this.autoScrollTimer = gui.createTimer();
            this.autoScrollTimer.setContinuous(true);
            this.autoScrollTimer.setDelay(50);
            this.autoScrollTimer.setCallback(new Runnable(){

                @Override
                public void run() {
                    ScrollPane.this.doAutoScroll();
                }
            });
            this.doAutoScroll();
        }
        this.autoScrollTimer.start();
        return true;
    }

    public void stopAutoScroll() {
        if (this.autoScrollTimer != null) {
            this.autoScrollTimer.stop();
        }
        this.autoScrollDirection = 0;
        this.setAutoScrollMarker();
    }

    public static ScrollPane getContainingScrollPane(Widget widget) {
        Widget sp;
        Widget ca = widget.getParent();
        if (ca != null && (sp = ca.getParent()) instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)sp;
            assert (scrollPane.getContent() == widget);
            return scrollPane;
        }
        return null;
    }

    @Override
    public int getMinWidth() {
        int minWidth = super.getMinWidth();
        int border = this.getBorderHorizontal();
        if (this.fixed == Fixed.HORIZONTAL && this.content != null) {
            minWidth = Math.max(minWidth, this.content.getMinWidth() + border + this.scrollbarV.getMinWidth());
        }
        return minWidth;
    }

    @Override
    public int getMinHeight() {
        int minHeight = super.getMinHeight();
        int border = this.getBorderVertical();
        if (this.fixed == Fixed.VERTICAL && this.content != null) {
            minHeight = Math.max(minHeight, this.content.getMinHeight() + border + this.scrollbarH.getMinHeight());
        }
        return minHeight;
    }

    @Override
    public int getPreferredInnerWidth() {
        if (this.content != null) {
            switch (this.fixed) {
                case HORIZONTAL: {
                    int prefWidth = ScrollPane.computeSize(this.content.getMinWidth(), this.content.getPreferredWidth(), this.content.getMaxWidth());
                    if (this.scrollbarV.isVisible()) {
                        prefWidth += this.scrollbarV.getPreferredWidth();
                    }
                    return prefWidth;
                }
                case VERTICAL: {
                    return this.content.getPreferredWidth();
                }
            }
        }
        return 0;
    }

    @Override
    public int getPreferredInnerHeight() {
        if (this.content != null) {
            switch (this.fixed) {
                case HORIZONTAL: {
                    return this.content.getPreferredHeight();
                }
                case VERTICAL: {
                    int prefHeight = ScrollPane.computeSize(this.content.getMinHeight(), this.content.getPreferredHeight(), this.content.getMaxHeight());
                    if (this.scrollbarH.isVisible()) {
                        prefHeight += this.scrollbarH.getPreferredHeight();
                    }
                    return prefHeight;
                }
            }
        }
        return 0;
    }

    @Override
    public void insertChild(Widget child, int index) {
        throw new UnsupportedOperationException("use setContent");
    }

    @Override
    public void removeAllChildren() {
        throw new UnsupportedOperationException("use setContent");
    }

    @Override
    public Widget removeChild(int index) {
        throw new UnsupportedOperationException("use setContent");
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.applyThemeScrollPane(themeInfo);
    }

    protected void applyThemeScrollPane(ThemeInfo themeInfo) {
        this.autoScrollArea = themeInfo.getParameter("autoScrollArea", 5);
        this.autoScrollSpeed = themeInfo.getParameter("autoScrollSpeed", this.autoScrollArea * 2);
        this.hscrollbarOffset = (Dimension)themeInfo.getParameterValue("hscrollbarOffset", false, Dimension.class, Dimension.ZERO);
        this.vscrollbarOffset = (Dimension)themeInfo.getParameterValue("vscrollbarOffset", false, Dimension.class, Dimension.ZERO);
        this.contentScrollbarSpacing = (Dimension)themeInfo.getParameterValue("contentScrollbarSpacing", false, Dimension.class, Dimension.ZERO);
        this.scrollbarsAlwaysVisible = themeInfo.getParameter("scrollbarsAlwaysVisible", false);
        boolean hasDragButton = themeInfo.getParameter("hasDragButton", false);
        if (hasDragButton && this.dragButton == null) {
            this.dragButton = new DraggableButton();
            this.dragButton.setTheme("dragButton");
            this.dragButton.setListener(new DraggableButton.DragListener(){

                @Override
                public void dragStarted() {
                    ScrollPane.this.scrollbarH.externalDragStart();
                    ScrollPane.this.scrollbarV.externalDragStart();
                }

                @Override
                public void dragged(int deltaX, int deltaY) {
                    ScrollPane.this.scrollbarH.externalDragged(deltaX, deltaY);
                    ScrollPane.this.scrollbarV.externalDragged(deltaX, deltaY);
                }

                @Override
                public void dragStopped() {
                    ScrollPane.this.scrollbarH.externalDragStopped();
                    ScrollPane.this.scrollbarV.externalDragStopped();
                }
            });
            super.insertChild(this.dragButton, 3);
        } else if (!hasDragButton && this.dragButton != null) {
            assert (super.getChild(3) == this.dragButton);
            super.removeChild(3);
            this.dragButton = null;
        }
    }

    protected int getAutoScrollDirection(Event evt) {
        int areaY;
        int mouseY;
        if (this.content instanceof AutoScrollable) {
            return ((AutoScrollable)((Object)this.content)).getAutoScrollDirection(evt, this.autoScrollArea);
        }
        if (this.contentArea.isMouseInside(evt) && ((mouseY = evt.getMouseY()) - (areaY = this.contentArea.getY()) <= this.autoScrollArea || this.contentArea.getBottom() - mouseY <= this.autoScrollArea)) {
            if (mouseY < areaY + this.contentArea.getHeight() / 2) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateLayout() {
        if (!this.inLayout) {
            try {
                this.inLayout = true;
                if (this.content != null) {
                    this.content.validateLayout();
                }
                super.validateLayout();
            }
            finally {
                this.inLayout = false;
            }
        }
    }

    @Override
    protected void childInvalidateLayout(Widget child) {
        if (child == this.contentArea) {
            this.invalidateLayoutLocally();
        } else {
            super.childInvalidateLayout(child);
        }
    }

    @Override
    protected void paintWidget(GUI gui) {
        this.scrollbarsToggleFlags = 0;
    }

    @Override
    protected void layout() {
        if (this.content != null) {
            int pageSizeY;
            int pageSizeX;
            int requiredHeight;
            int requiredWidth;
            int innerWidth = this.getInnerWidth();
            int innerHeight = this.getInnerHeight();
            int availWidth = innerWidth;
            int availHeight = innerHeight;
            int scrollbarHX = this.hscrollbarOffset.getX();
            int scrollbarHY = innerHeight += this.hscrollbarOffset.getY();
            int scrollbarVX = innerWidth += this.vscrollbarOffset.getX();
            int scrollbarVY = this.vscrollbarOffset.getY();
            boolean visibleH = false;
            boolean visibleV = false;
            switch (this.fixed) {
                case HORIZONTAL: {
                    requiredWidth = availWidth;
                    requiredHeight = this.content.getPreferredHeight();
                    break;
                }
                case VERTICAL: {
                    requiredWidth = this.content.getPreferredWidth();
                    requiredHeight = availHeight;
                    break;
                }
                default: {
                    requiredWidth = this.content.getPreferredWidth();
                    requiredHeight = this.content.getPreferredHeight();
                }
            }
            int hScrollbarMax = 0;
            int vScrollbarMax = 0;
            if (availWidth > 0 && availHeight > 0) {
                boolean repeat;
                do {
                    repeat = false;
                    if (this.fixed != Fixed.HORIZONTAL) {
                        hScrollbarMax = Math.max(0, requiredWidth - availWidth);
                        if (hScrollbarMax > 0 || this.scrollbarsAlwaysVisible || (this.scrollbarsToggleFlags & 3) == 3) {
                            repeat |= !visibleH;
                            visibleH = true;
                            int prefHeight = this.scrollbarH.getPreferredHeight();
                            scrollbarHY = innerHeight - prefHeight;
                            availHeight = Math.max(0, scrollbarHY - this.contentScrollbarSpacing.getY());
                        }
                    } else {
                        hScrollbarMax = 0;
                        requiredWidth = availWidth;
                    }
                    if (this.fixed != Fixed.VERTICAL) {
                        vScrollbarMax = Math.max(0, requiredHeight - availHeight);
                        if (vScrollbarMax <= 0 && !this.scrollbarsAlwaysVisible && (this.scrollbarsToggleFlags & 0xC) != 12) continue;
                        repeat |= !visibleV;
                        visibleV = true;
                        int prefWidth = this.scrollbarV.getPreferredWidth();
                        scrollbarVX = innerWidth - prefWidth;
                        availWidth = Math.max(0, scrollbarVX - this.contentScrollbarSpacing.getX());
                        continue;
                    }
                    vScrollbarMax = 0;
                    requiredHeight = availHeight;
                } while (repeat);
            }
            if (visibleH && !this.scrollbarH.isVisible()) {
                this.scrollbarsToggleFlags |= 1;
            }
            if (!visibleH && this.scrollbarH.isVisible()) {
                this.scrollbarsToggleFlags |= 2;
            }
            if (visibleV && !this.scrollbarV.isVisible()) {
                this.scrollbarsToggleFlags |= 4;
            }
            if (!visibleV && this.scrollbarV.isVisible()) {
                this.scrollbarsToggleFlags |= 8;
            }
            if (visibleH != this.scrollbarH.isVisible() || visibleV != this.scrollbarV.isVisible()) {
                this.invalidateLayoutLocally();
            }
            if (this.content instanceof CustomPageSize) {
                CustomPageSize customPageSize = (CustomPageSize)((Object)this.content);
                pageSizeX = customPageSize.getPageSizeX(availWidth);
                pageSizeY = customPageSize.getPageSizeY(availHeight);
            } else {
                pageSizeX = availWidth;
                pageSizeY = availHeight;
            }
            this.scrollbarH.setVisible(visibleH);
            this.scrollbarH.setMinMaxValue(0, hScrollbarMax);
            this.scrollbarH.setSize(Math.max(0, scrollbarVX - scrollbarHX), Math.max(0, innerHeight - scrollbarHY));
            this.scrollbarH.setPosition(this.getInnerX() + scrollbarHX, this.getInnerY() + scrollbarHY);
            this.scrollbarH.setPageSize(Math.max(1, pageSizeX));
            this.scrollbarH.setStepSize(Math.max(1, pageSizeX / 10));
            this.scrollbarV.setVisible(visibleV);
            this.scrollbarV.setMinMaxValue(0, vScrollbarMax);
            this.scrollbarV.setSize(Math.max(0, innerWidth - scrollbarVX), Math.max(0, scrollbarHY - scrollbarVY));
            this.scrollbarV.setPosition(this.getInnerX() + scrollbarVX, this.getInnerY() + scrollbarVY);
            this.scrollbarV.setPageSize(Math.max(1, pageSizeY));
            this.scrollbarV.setStepSize(Math.max(1, pageSizeY / 10));
            if (this.dragButton != null) {
                this.dragButton.setVisible(visibleH && visibleV);
                this.dragButton.setSize(Math.max(0, innerWidth - scrollbarVX), Math.max(0, innerHeight - scrollbarHY));
                this.dragButton.setPosition(this.getInnerX() + scrollbarVX, this.getInnerY() + scrollbarHY);
            }
            this.contentArea.setPosition(this.getInnerX(), this.getInnerY());
            this.contentArea.setSize(availWidth, availHeight);
            if (this.content instanceof Scrollable) {
                this.content.setPosition(this.contentArea.getX(), this.contentArea.getY());
                this.content.setSize(availWidth, availHeight);
            } else if (this.expandContentSize) {
                this.content.setSize(Math.max(availWidth, requiredWidth), Math.max(availHeight, requiredHeight));
            } else {
                this.content.setSize(Math.max(0, requiredWidth), Math.max(0, requiredHeight));
            }
            AnimationState animationState = this.getAnimationState();
            animationState.setAnimationState(STATE_HORIZONTAL_SCROLLBAR_VISIBLE, visibleH);
            animationState.setAnimationState(STATE_VERTICAL_SCROLLBAR_VISIBLE, visibleV);
            this.scrollContent();
        } else {
            this.scrollbarH.setVisible(false);
            this.scrollbarV.setVisible(false);
        }
    }

    @Override
    protected boolean handleEvent(Event evt) {
        if (evt.isKeyEvent() && this.content != null && this.content.canAcceptKeyboardFocus() && this.content.handleEvent(evt)) {
            this.content.requestKeyboardFocus();
            return true;
        }
        if (super.handleEvent(evt)) {
            return true;
        }
        switch (evt.getType()) {
            case KEY_PRESSED: 
            case KEY_RELEASED: {
                int keyCode = evt.getKeyCode();
                if (keyCode == 203 || keyCode == 205) {
                    return this.scrollbarH.handleEvent(evt);
                }
                if (keyCode != 200 && keyCode != 208 && keyCode != 201 && keyCode != 209) break;
                return this.scrollbarV.handleEvent(evt);
            }
            case MOUSE_WHEEL: {
                if (this.scrollbarV.isVisible()) {
                    return this.scrollbarV.handleEvent(evt);
                }
                return false;
            }
        }
        return evt.isMouseEvent() && this.contentArea.isMouseInside(evt);
    }

    @Override
    protected void paint(GUI gui) {
        if (this.dragButton != null) {
            AnimationState as = this.dragButton.getAnimationState();
            as.setAnimationState(STATE_DOWNARROW_ARMED, this.scrollbarV.isDownRightButtonArmed());
            as.setAnimationState(STATE_RIGHTARROW_ARMED, this.scrollbarH.isDownRightButtonArmed());
        }
        super.paint(gui);
    }

    void scrollContent() {
        if (this.content instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)this.content);
            scrollable.setScrollPosition(this.scrollbarH.getValue(), this.scrollbarV.getValue());
        } else {
            this.content.setPosition(this.contentArea.getX() - this.scrollbarH.getValue(), this.contentArea.getY() - this.scrollbarV.getValue());
        }
    }

    void setAutoScrollMarker() {
        int scrollPos = this.scrollbarV.getValue();
        AnimationState animationState = this.getAnimationState();
        animationState.setAnimationState(STATE_AUTO_SCROLL_UP, this.autoScrollDirection < 0 && scrollPos > 0);
        animationState.setAnimationState(STATE_AUTO_SCROLL_DOWN, this.autoScrollDirection > 0 && scrollPos < this.scrollbarV.getMaxValue());
    }

    void doAutoScroll() {
        this.scrollbarV.setValue(this.scrollbarV.getValue() + this.autoScrollDirection * this.autoScrollSpeed);
        this.setAutoScrollMarker();
    }

    public static interface CustomPageSize {
        public int getPageSizeX(int var1);

        public int getPageSizeY(int var1);
    }

    public static interface AutoScrollable {
        public int getAutoScrollDirection(Event var1, int var2);
    }

    public static interface Scrollable {
        public void setScrollPosition(int var1, int var2);
    }

    public static enum Fixed {
        NONE,
        HORIZONTAL,
        VERTICAL;

    }
}

