/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.CallbackWithReason;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.TextWidget;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.Font;
import de.matthiasmann.twl.utils.CallbackSupport;
import de.matthiasmann.twl.utils.TextUtil;

public class Label
extends TextWidget {
    private boolean autoSize = true;
    private Widget labelFor;
    private CallbackWithReason[] callbacks;

    public Label() {
        this(null, false);
    }

    public Label(AnimationState animState) {
        this(animState, false);
    }

    public Label(AnimationState animState, boolean inherit) {
        super(animState, inherit);
    }

    public Label(String text) {
        this();
        this.setText(text);
    }

    public void addCallback(CallbackWithReason cb) {
        this.callbacks = (CallbackWithReason[])CallbackSupport.addCallbackToList(this.callbacks, cb, CallbackWithReason.class);
    }

    public void removeCallback(CallbackWithReason cb) {
        this.callbacks = (CallbackWithReason[])CallbackSupport.removeCallbackFromList((Object[])this.callbacks, cb);
    }

    protected void doCallback(CallbackReason reason) {
        CallbackSupport.fireCallbacks(this.callbacks, reason);
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public void setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.autoSize) {
            this.invalidateLayout();
        }
    }

    public String getText() {
        return super.getCharSequence().toString();
    }

    public void setText(String text) {
        if (!(text = TextUtil.notNull(text)).equals(this.getText())) {
            super.setCharSequence(text);
            if (this.autoSize) {
                this.invalidateLayout();
            }
        }
    }

    @Override
    public Object getTooltipContent() {
        Object toolTipContent = super.getTooltipContent();
        if (toolTipContent == null && this.labelFor != null) {
            return this.labelFor.getTooltipContent();
        }
        return toolTipContent;
    }

    public Widget getLabelFor() {
        return this.labelFor;
    }

    public void setLabelFor(Widget labelFor) {
        if (labelFor == this) {
            throw new IllegalArgumentException("labelFor == this");
        }
        this.labelFor = labelFor;
    }

    protected void applyThemeLabel(ThemeInfo themeInfo) {
        String themeText = (String)themeInfo.getParameterValue("text", false, String.class);
        if (themeText != null) {
            this.setText(themeText);
        }
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.applyThemeLabel(themeInfo);
    }

    @Override
    public boolean requestKeyboardFocus() {
        if (this.labelFor != null) {
            return this.labelFor.requestKeyboardFocus();
        }
        return super.requestKeyboardFocus();
    }

    @Override
    public int getMinWidth() {
        return Math.max(super.getMinWidth(), this.getPreferredWidth());
    }

    @Override
    public int getMinHeight() {
        return Math.max(super.getMinHeight(), this.getPreferredHeight());
    }

    @Override
    protected boolean handleEvent(Event evt) {
        this.handleMouseHover(evt);
        if (evt.isMouseEvent()) {
            if (evt.getType() == Event.Type.MOUSE_CLICKED) {
                switch (evt.getMouseClickCount()) {
                    case 1: {
                        this.handleClick(false);
                        break;
                    }
                    case 2: {
                        this.handleClick(true);
                    }
                }
            }
            return evt.getType() != Event.Type.MOUSE_WHEEL;
        }
        return false;
    }

    protected void handleClick(boolean doubleClick) {
        this.doCallback(doubleClick ? CallbackReason.DOUBLE_CLICK : CallbackReason.CLICK);
    }

    public static enum CallbackReason {
        CLICK,
        DOUBLE_CLICK;

    }
}

