/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.CallbackWithReason;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.InfoWindow;
import de.matthiasmann.twl.ListBox;
import de.matthiasmann.twl.model.AutoCompletionDataSource;
import de.matthiasmann.twl.model.AutoCompletionResult;
import de.matthiasmann.twl.model.SimpleListModel;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EditFieldAutoCompletionWindow
extends InfoWindow {
    private final ResultListModel listModel = new ResultListModel();
    private final ListBox listBox = new ListBox(this.listModel);
    private boolean captureKeys;
    private boolean useInvokeAsync;
    private AutoCompletionDataSource dataSource;
    private ExecutorService executorService;
    private Future future;

    public EditFieldAutoCompletionWindow(EditField editField) {
        super(editField);
        this.add(this.listBox);
        Callbacks cb = new Callbacks();
        this.listBox.addCallback(cb);
    }

    public EditFieldAutoCompletionWindow(EditField editField, AutoCompletionDataSource dataSource) {
        this(editField);
        this.dataSource = dataSource;
    }

    public EditFieldAutoCompletionWindow(EditField editField, AutoCompletionDataSource dataSource, ExecutorService executorService) {
        this(editField);
        this.dataSource = dataSource;
        this.executorService = executorService;
    }

    public final EditField getEditField() {
        return (EditField)this.getOwner();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public boolean isUseInvokeAsync() {
        return this.useInvokeAsync;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        this.useInvokeAsync = false;
        this.cancelFuture();
    }

    public void setUseInvokeAsync(boolean useInvokeAsync) {
        this.executorService = null;
        this.useInvokeAsync = useInvokeAsync;
        this.cancelFuture();
    }

    public AutoCompletionDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(AutoCompletionDataSource dataSource) {
        this.dataSource = dataSource;
        this.cancelFuture();
        if (this.isOpen()) {
            this.updateAutoCompletion();
        }
    }

    public void updateAutoCompletion() {
        EditField ef;
        int cursorPos;
        this.cancelFuture();
        AutoCompletionResult result = null;
        if (this.dataSource != null && (cursorPos = (ef = this.getEditField()).getCursorPos()) > 0) {
            String text = ef.getText();
            GUI gui = ef.getGUI();
            if (this.listModel.result != null) {
                result = this.listModel.result.refine(text, cursorPos);
            }
            if (result == null) {
                if (gui != null && (this.useInvokeAsync || this.executorService != null)) {
                    this.future = (this.useInvokeAsync ? gui.executorService : this.executorService).submit(new AsyncQuery(gui, this.dataSource, text, cursorPos, this.listModel.result));
                } else {
                    try {
                        result = this.dataSource.collectSuggestions(text, cursorPos, this.listModel.result);
                    }
                    catch (Exception ex) {
                        this.reportQueryException(ex);
                    }
                }
            }
        }
        this.updateAutoCompletion(result);
    }

    public void stopAutoCompletion() {
        this.listModel.setResult(null);
        this.installAutoCompletion();
    }

    @Override
    protected void infoWindowClosed() {
        this.stopAutoCompletion();
    }

    protected void updateAutoCompletion(AutoCompletionResult results) {
        this.listModel.setResult(results);
        this.captureKeys = false;
        this.installAutoCompletion();
    }

    void checkFuture() {
        if (this.future != null && this.future.isDone()) {
            AutoCompletionResult result = null;
            try {
                result = (AutoCompletionResult)this.future.get();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                this.reportQueryException(ex.getCause());
            }
            this.future = null;
            this.updateAutoCompletion(result);
        }
    }

    void cancelFuture() {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
    }

    protected void reportQueryException(Throwable ex) {
        Logger.getLogger(EditFieldAutoCompletionWindow.class.getName()).log(Level.SEVERE, "Exception while collecting auto completion results", ex);
    }

    @Override
    protected boolean handleEvent(Event evt) {
        if (evt.isKeyEvent()) {
            if (this.captureKeys) {
                if (evt.isKeyPressedEvent()) {
                    switch (evt.getKeyCode()) {
                        case 28: 
                        case 156: {
                            return this.acceptAutoCompletion();
                        }
                        case 1: {
                            this.stopAutoCompletion();
                            break;
                        }
                        case 199: 
                        case 200: 
                        case 201: 
                        case 207: 
                        case 208: 
                        case 209: {
                            this.listBox.handleEvent(evt);
                            break;
                        }
                        case 203: 
                        case 205: {
                            return false;
                        }
                        default: {
                            if (!evt.hasKeyChar() && evt.getKeyCode() != 14) break;
                            if (!this.acceptAutoCompletion()) {
                                this.stopAutoCompletion();
                            }
                            return false;
                        }
                    }
                }
                return true;
            }
            switch (evt.getKeyCode()) {
                case 200: 
                case 208: 
                case 209: {
                    this.listBox.handleEvent(evt);
                    this.startCapture();
                    return this.captureKeys;
                }
                case 1: {
                    this.stopAutoCompletion();
                    return false;
                }
                case 57: {
                    if ((evt.getModifiers() & 0x24) != 0) {
                        this.updateAutoCompletion();
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
        return super.handleEvent(evt);
    }

    boolean acceptAutoCompletion() {
        int selected = this.listBox.getSelected();
        if (selected >= 0) {
            EditField editField = this.getEditField();
            String text = this.listModel.getEntry(selected);
            int pos = this.listModel.getCursorPosForEntry(selected);
            editField.setText(text);
            if (pos >= 0 && pos < text.length()) {
                editField.setCursorPos(pos);
            }
            this.stopAutoCompletion();
            return true;
        }
        return false;
    }

    private void startCapture() {
        this.captureKeys = true;
        this.installAutoCompletion();
    }

    private void installAutoCompletion() {
        if (this.listModel.getNumEntries() > 0) {
            this.openInfo();
        } else {
            this.captureKeys = false;
            this.closeInfo();
        }
    }

    class AsyncQuery
    implements Callable,
    Runnable {
        private final GUI gui;
        private final AutoCompletionDataSource dataSource;
        private final String text;
        private final int cursorPos;
        private final AutoCompletionResult prevResult;

        public AsyncQuery(GUI gui, AutoCompletionDataSource dataSource, String text, int cursorPos, AutoCompletionResult prevResult) {
            this.gui = gui;
            this.dataSource = dataSource;
            this.text = text;
            this.cursorPos = cursorPos;
            this.prevResult = prevResult;
        }

        public AutoCompletionResult call() throws Exception {
            AutoCompletionResult acr = this.dataSource.collectSuggestions(this.text, this.cursorPos, this.prevResult);
            this.gui.invokeLater(this);
            return acr;
        }

        @Override
        public void run() {
            EditFieldAutoCompletionWindow.this.checkFuture();
        }
    }

    class Callbacks
    implements CallbackWithReason {
        Callbacks() {
        }

        public void callback(ListBox.CallbackReason reason) {
            switch (reason) {
                case MOUSE_DOUBLE_CLICK: {
                    EditFieldAutoCompletionWindow.this.acceptAutoCompletion();
                }
            }
        }
    }

    static class ResultListModel
    extends SimpleListModel {
        AutoCompletionResult result;

        ResultListModel() {
        }

        public void setResult(AutoCompletionResult result) {
            this.result = result;
            this.fireAllChanged();
        }

        @Override
        public int getNumEntries() {
            return this.result == null ? 0 : this.result.getNumResults();
        }

        @Override
        public String getEntry(int index) {
            return this.result.getResult(index);
        }

        public int getCursorPosForEntry(int index) {
            return this.result.getCursorPosForResult(index);
        }
    }
}

