/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Alignment;
import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.Dimension;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.ParameterMap;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DialogLayout
extends Widget {
    public static final int SMALL_GAP = -1;
    public static final int MEDIUM_GAP = -2;
    public static final int LARGE_GAP = -3;
    public static final int DEFAULT_GAP = -4;
    private static final boolean DEBUG_LAYOUT_GROUPS = Widget.getSafeBooleanProperty("debugLayoutGroups");
    protected Dimension smallGap;
    protected Dimension mediumGap;
    protected Dimension largeGap;
    protected Dimension defaultGap;
    protected ParameterMap namedGaps;
    protected boolean addDefaultGaps = true;
    protected boolean includeInvisibleWidgets = true;
    protected boolean redoDefaultGaps;
    protected boolean isPrepared;
    protected boolean blockInvalidateLayoutTree;
    protected boolean warnOnIncomplete;
    private Group horz;
    private Group vert;
    Throwable debugStackTrace;
    final HashMap widgetSprings = new HashMap();
    static final int AXIS_X = 0;
    static final int AXIS_Y = 1;
    static final Gap NO_GAP = new Gap(0, 0, Short.MAX_VALUE);

    public DialogLayout() {
        this.collectDebugStack();
    }

    public Group getHorizontalGroup() {
        return this.horz;
    }

    public void setHorizontalGroup(Group g) {
        if (g != null) {
            g.checkGroup(this);
        }
        this.horz = g;
        this.collectDebugStack();
        this.layoutGroupsChanged();
    }

    public Group getVerticalGroup() {
        return this.vert;
    }

    public void setVerticalGroup(Group g) {
        if (g != null) {
            g.checkGroup(this);
        }
        this.vert = g;
        this.collectDebugStack();
        this.layoutGroupsChanged();
    }

    public Dimension getSmallGap() {
        return this.smallGap;
    }

    public void setSmallGap(Dimension smallGap) {
        this.smallGap = smallGap;
        this.maybeInvalidateLayoutTree();
    }

    public Dimension getMediumGap() {
        return this.mediumGap;
    }

    public void setMediumGap(Dimension mediumGap) {
        this.mediumGap = mediumGap;
        this.maybeInvalidateLayoutTree();
    }

    public Dimension getLargeGap() {
        return this.largeGap;
    }

    public void setLargeGap(Dimension largeGap) {
        this.largeGap = largeGap;
        this.maybeInvalidateLayoutTree();
    }

    public Dimension getDefaultGap() {
        return this.defaultGap;
    }

    public void setDefaultGap(Dimension defaultGap) {
        this.defaultGap = defaultGap;
        this.maybeInvalidateLayoutTree();
    }

    public boolean isAddDefaultGaps() {
        return this.addDefaultGaps;
    }

    public void setAddDefaultGaps(boolean addDefaultGaps) {
        this.addDefaultGaps = addDefaultGaps;
    }

    public void removeDefaultGaps() {
        if (this.horz != null && this.vert != null) {
            this.horz.removeDefaultGaps();
            this.vert.removeDefaultGaps();
            this.maybeInvalidateLayoutTree();
        }
    }

    public void addDefaultGaps() {
        if (this.horz != null && this.vert != null) {
            this.horz.addDefaultGap();
            this.vert.addDefaultGap();
            this.maybeInvalidateLayoutTree();
        }
    }

    public boolean isIncludeInvisibleWidgets() {
        return this.includeInvisibleWidgets;
    }

    public void setIncludeInvisibleWidgets(boolean includeInvisibleWidgets) {
        if (this.includeInvisibleWidgets != includeInvisibleWidgets) {
            this.includeInvisibleWidgets = includeInvisibleWidgets;
            this.layoutGroupsChanged();
        }
    }

    private void collectDebugStack() {
        this.warnOnIncomplete = true;
        if (DEBUG_LAYOUT_GROUPS) {
            this.debugStackTrace = new Throwable("DialogLayout created/used here").fillInStackTrace();
        }
    }

    private void warnOnIncomplete() {
        this.warnOnIncomplete = false;
        DialogLayout.getLogger().log(Level.WARNING, "Dialog layout has incomplete state", this.debugStackTrace);
    }

    static Logger getLogger() {
        return Logger.getLogger(DialogLayout.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyThemeDialogLayout(ThemeInfo themeInfo) {
        try {
            this.blockInvalidateLayoutTree = true;
            this.setSmallGap((Dimension)themeInfo.getParameterValue("smallGap", true, Dimension.class, Dimension.ZERO));
            this.setMediumGap((Dimension)themeInfo.getParameterValue("mediumGap", true, Dimension.class, Dimension.ZERO));
            this.setLargeGap((Dimension)themeInfo.getParameterValue("largeGap", true, Dimension.class, Dimension.ZERO));
            this.setDefaultGap((Dimension)themeInfo.getParameterValue("defaultGap", true, Dimension.class, Dimension.ZERO));
            this.namedGaps = themeInfo.getParameterMap("namedGaps");
        }
        finally {
            this.blockInvalidateLayoutTree = false;
        }
        this.invalidateLayout();
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.applyThemeDialogLayout(themeInfo);
    }

    @Override
    public int getMinWidth() {
        if (this.horz != null) {
            this.prepare();
            return this.horz.getMinSize(0) + this.getBorderHorizontal();
        }
        return super.getMinWidth();
    }

    @Override
    public int getMinHeight() {
        if (this.vert != null) {
            this.prepare();
            return this.vert.getMinSize(1) + this.getBorderVertical();
        }
        return super.getMinHeight();
    }

    @Override
    public int getPreferredInnerWidth() {
        if (this.horz != null) {
            this.prepare();
            return this.horz.getPrefSize(0);
        }
        return super.getPreferredInnerWidth();
    }

    @Override
    public int getPreferredInnerHeight() {
        if (this.vert != null) {
            this.prepare();
            return this.vert.getPrefSize(1);
        }
        return super.getPreferredInnerHeight();
    }

    @Override
    public void adjustSize() {
        if (this.horz != null && this.vert != null) {
            this.prepare();
            int minWidth = this.horz.getMinSize(0);
            int minHeight = this.vert.getMinSize(1);
            int prefWidth = this.horz.getPrefSize(0);
            int prefHeight = this.vert.getPrefSize(1);
            int maxWidth = this.getMaxWidth();
            int maxHeight = this.getMaxHeight();
            this.setInnerSize(DialogLayout.computeSize(minWidth, prefWidth, maxWidth), DialogLayout.computeSize(minHeight, prefHeight, maxHeight));
            this.doLayout();
        }
    }

    @Override
    protected void layout() {
        if (this.horz != null && this.vert != null) {
            this.prepare();
            this.doLayout();
        } else if (this.warnOnIncomplete) {
            this.warnOnIncomplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepare() {
        if (this.redoDefaultGaps) {
            if (this.addDefaultGaps) {
                try {
                    this.blockInvalidateLayoutTree = true;
                    this.removeDefaultGaps();
                    this.addDefaultGaps();
                }
                finally {
                    this.blockInvalidateLayoutTree = false;
                }
            }
            this.redoDefaultGaps = false;
            this.isPrepared = false;
        }
        if (!this.isPrepared) {
            for (WidgetSpring s : this.widgetSprings.values()) {
                if (!this.includeInvisibleWidgets && !s.w.isVisible()) continue;
                s.prepare();
            }
            this.isPrepared = true;
        }
    }

    protected void doLayout() {
        this.horz.setSize(0, this.getInnerX(), this.getInnerWidth());
        this.vert.setSize(1, this.getInnerY(), this.getInnerHeight());
        try {
            for (WidgetSpring s : this.widgetSprings.values()) {
                if (!this.includeInvisibleWidgets && !s.w.isVisible()) continue;
                s.apply();
            }
        }
        catch (IllegalStateException ex) {
            if (this.debugStackTrace != null && ex.getCause() == null) {
                ex.initCause(this.debugStackTrace);
            }
            throw ex;
        }
    }

    @Override
    public void invalidateLayout() {
        this.isPrepared = false;
        super.invalidateLayout();
    }

    @Override
    protected void paintWidget(GUI gui) {
        this.isPrepared = false;
    }

    @Override
    protected void sizeChanged() {
        this.isPrepared = false;
        super.sizeChanged();
    }

    @Override
    protected void afterAddToGUI(GUI gui) {
        this.isPrepared = false;
        super.afterAddToGUI(gui);
    }

    public Group createParallelGroup() {
        return new ParallelGroup();
    }

    public Group createParallelGroup(Widget ... widgets) {
        return this.createParallelGroup().addWidgets(widgets);
    }

    public Group createParallelGroup(Group ... groups) {
        return this.createParallelGroup().addGroups(groups);
    }

    public Group createSequentialGroup() {
        return new SequentialGroup();
    }

    public Group createSequentialGroup(Widget ... widgets) {
        return this.createSequentialGroup().addWidgets(widgets);
    }

    public Group createSequentialGroup(Group ... groups) {
        return this.createSequentialGroup().addGroups(groups);
    }

    @Override
    public void insertChild(Widget child, int index) throws IndexOutOfBoundsException {
        super.insertChild(child, index);
        this.widgetSprings.put(child, new WidgetSpring(child));
    }

    @Override
    public void removeAllChildren() {
        super.removeAllChildren();
        this.widgetSprings.clear();
        this.recheckWidgets();
        this.layoutGroupsChanged();
    }

    @Override
    public Widget removeChild(int index) throws IndexOutOfBoundsException {
        Widget widget = super.removeChild(index);
        this.widgetSprings.remove(widget);
        this.recheckWidgets();
        this.layoutGroupsChanged();
        return widget;
    }

    public boolean setWidgetAlignment(Widget widget, Alignment alignment) {
        if (widget == null) {
            throw new NullPointerException("widget");
        }
        if (alignment == null) {
            throw new NullPointerException("alignment");
        }
        WidgetSpring ws = (WidgetSpring)this.widgetSprings.get(widget);
        if (ws != null) {
            assert (widget.getParent() == this);
            ws.alignment = alignment;
            return true;
        }
        return false;
    }

    protected void recheckWidgets() {
        if (this.horz != null) {
            this.horz.recheckWidgets();
        }
        if (this.vert != null) {
            this.vert.recheckWidgets();
        }
    }

    protected void layoutGroupsChanged() {
        this.redoDefaultGaps = true;
        this.maybeInvalidateLayoutTree();
    }

    protected void maybeInvalidateLayoutTree() {
        if (this.horz != null && this.vert != null && !this.blockInvalidateLayoutTree) {
            this.invalidateLayout();
        }
    }

    @Override
    protected void childVisibilityChanged(Widget child) {
        if (!this.includeInvisibleWidgets) {
            this.layoutGroupsChanged();
        }
    }

    void removeChild(WidgetSpring widgetSpring) {
        Widget widget = widgetSpring.w;
        int idx = this.getChildIndex(widget);
        assert (idx >= 0);
        super.removeChild(idx);
        this.widgetSprings.remove(widget);
    }

    class ParallelGroup
    extends Group {
        ParallelGroup() {
        }

        @Override
        int getMinSize(int axis) {
            int size = 0;
            int n = this.springs.size();
            for (int i = 0; i < n; ++i) {
                Spring s = (Spring)this.springs.get(i);
                if (!DialogLayout.this.includeInvisibleWidgets && !s.isVisible()) continue;
                size = Math.max(size, s.getMinSize(axis));
            }
            return size;
        }

        @Override
        int getPrefSize(int axis) {
            int size = 0;
            int n = this.springs.size();
            for (int i = 0; i < n; ++i) {
                Spring s = (Spring)this.springs.get(i);
                if (!DialogLayout.this.includeInvisibleWidgets && !s.isVisible()) continue;
                size = Math.max(size, s.getPrefSize(axis));
            }
            return size;
        }

        @Override
        int getMaxSize(int axis) {
            int size = 0;
            int n = this.springs.size();
            for (int i = 0; i < n; ++i) {
                Spring s = (Spring)this.springs.get(i);
                if (!DialogLayout.this.includeInvisibleWidgets && !s.isVisible()) continue;
                size = Math.max(size, s.getMaxSize(axis));
            }
            return size;
        }

        @Override
        void setSize(int axis, int pos, int size) {
            int n = this.springs.size();
            for (int i = 0; i < n; ++i) {
                Spring s = (Spring)this.springs.get(i);
                if (!DialogLayout.this.includeInvisibleWidgets && !s.isVisible()) continue;
                s.setSize(axis, pos, size);
            }
        }

        @Override
        public Group addGap() {
            DialogLayout.getLogger().log(Level.WARNING, "Useless call to addGap() on ParallelGroup", new Throwable());
            return this;
        }
    }

    class SequentialGroup
    extends Group {
        SequentialGroup() {
        }

        @Override
        int getMinSize(int axis) {
            int size = 0;
            int n = this.springs.size();
            for (int i = 0; i < n; ++i) {
                Spring s = (Spring)this.springs.get(i);
                if (!DialogLayout.this.includeInvisibleWidgets && !s.isVisible()) continue;
                size += s.getMinSize(axis);
            }
            return size;
        }

        @Override
        int getPrefSize(int axis) {
            int size = 0;
            int n = this.springs.size();
            for (int i = 0; i < n; ++i) {
                Spring s = (Spring)this.springs.get(i);
                if (!DialogLayout.this.includeInvisibleWidgets && !s.isVisible()) continue;
                size += s.getPrefSize(axis);
            }
            return size;
        }

        @Override
        int getMaxSize(int axis) {
            int size = 0;
            boolean hasMax = false;
            int n = this.springs.size();
            for (int i = 0; i < n; ++i) {
                Spring s = (Spring)this.springs.get(i);
                if (!DialogLayout.this.includeInvisibleWidgets && !s.isVisible()) continue;
                int max = s.getMaxSize(axis);
                if (max > 0) {
                    size += max;
                    hasMax = true;
                    continue;
                }
                size += s.getPrefSize(axis);
            }
            return hasMax ? size : 0;
        }

        @Override
        public void addDefaultGap() {
            if (this.springs.size() > 1) {
                boolean wasGap = true;
                for (int i = 0; i < this.springs.size(); ++i) {
                    boolean isGap;
                    Spring s = (Spring)this.springs.get(i);
                    if (!DialogLayout.this.includeInvisibleWidgets && !s.isVisible()) continue;
                    boolean bl = isGap = s instanceof GapSpring || s instanceof NamedGapSpring;
                    if (!isGap && !wasGap) {
                        this.springs.add(i++, new GapSpring(-4, -4, -4, true));
                    }
                    wasGap = isGap;
                }
            }
            super.addDefaultGap();
        }

        @Override
        void setSize(int axis, int pos, int size) {
            int prefSize = this.getPrefSize(axis);
            if (size == prefSize) {
                for (Spring s : this.springs) {
                    if (!DialogLayout.this.includeInvisibleWidgets && !s.isVisible()) continue;
                    int spref = s.getPrefSize(axis);
                    s.setSize(axis, pos, spref);
                    pos += spref;
                }
            } else if (this.springs.size() == 1) {
                Spring s = (Spring)this.springs.get(0);
                s.setSize(axis, pos, size);
            } else if (this.springs.size() > 1) {
                this.setSizeNonPref(axis, pos, size, prefSize);
            }
        }

        private void setSizeNonPref(int axis, int pos, int size, int prefSize) {
            boolean useMin;
            int delta = size - prefSize;
            boolean bl = useMin = delta < 0;
            if (useMin) {
                delta = -delta;
            }
            Object[] deltas = new SpringDelta[this.springs.size()];
            int resizeable = 0;
            for (int i = 0; i < this.springs.size(); ++i) {
                int sdelta;
                Spring s = (Spring)this.springs.get(i);
                if (!DialogLayout.this.includeInvisibleWidgets && !s.isVisible()) continue;
                int n = sdelta = useMin ? s.getPrefSize(axis) - s.getMinSize(axis) : s.getMaxSize(axis) - s.getPrefSize(axis);
                if (sdelta <= 0) continue;
                deltas[resizeable++] = new SpringDelta(i, sdelta);
            }
            if (resizeable > 0) {
                int i;
                if (resizeable > 1) {
                    Arrays.sort(deltas, 0, resizeable);
                }
                int[] sizes = new int[this.springs.size()];
                int remaining = resizeable;
                for (i = 0; i < resizeable; ++i) {
                    Object d = deltas[i];
                    int sdelta = delta / remaining;
                    int ddelta = Math.min(((SpringDelta)d).delta, sdelta);
                    delta -= ddelta;
                    --remaining;
                    if (useMin) {
                        ddelta = -ddelta;
                    }
                    sizes[((SpringDelta)d).idx] = ddelta;
                }
                for (i = 0; i < this.springs.size(); ++i) {
                    Spring s = (Spring)this.springs.get(i);
                    if (!DialogLayout.this.includeInvisibleWidgets && !s.isVisible()) continue;
                    int ssize = s.getPrefSize(axis) + sizes[i];
                    s.setSize(axis, pos, ssize);
                    pos += ssize;
                }
            } else {
                for (Spring s : this.springs) {
                    int ssize;
                    if (!DialogLayout.this.includeInvisibleWidgets && !s.isVisible()) continue;
                    if (useMin) {
                        ssize = s.getMinSize(axis);
                    } else {
                        ssize = s.getMaxSize(axis);
                        if (ssize == 0) {
                            ssize = s.getPrefSize(axis);
                        }
                    }
                    s.setSize(axis, pos, ssize);
                    pos += ssize;
                }
            }
        }
    }

    static class SpringDelta
    implements Comparable {
        final int idx;
        final int delta;

        SpringDelta(int idx, int delta) {
            this.idx = idx;
            this.delta = delta;
        }

        public int compareTo(SpringDelta o) {
            return this.delta - o.delta;
        }
    }

    public abstract class Group
    extends Spring {
        final ArrayList springs = new ArrayList();
        boolean alreadyAdded;

        void checkGroup(DialogLayout owner) {
            if (DialogLayout.this != owner) {
                throw new IllegalArgumentException("Can't add group from different layout");
            }
            if (this.alreadyAdded) {
                throw new IllegalArgumentException("Group already added to another group");
            }
        }

        public Group addGroup(Group g) {
            g.checkGroup(DialogLayout.this);
            g.alreadyAdded = true;
            this.addSpring(g);
            return this;
        }

        public Group addGroups(Group ... groups) {
            for (Group g : groups) {
                this.addGroup(g);
            }
            return this;
        }

        public Group addWidget(Widget w) {
            WidgetSpring s;
            if (w.getParent() != DialogLayout.this) {
                DialogLayout.this.add(w);
            }
            if ((s = (WidgetSpring)DialogLayout.this.widgetSprings.get(w)) == null) {
                throw new IllegalStateException("WidgetSpring for Widget not found: " + w);
            }
            this.addSpring(s);
            return this;
        }

        public Group addWidget(Widget w, Alignment alignment) {
            this.addWidget(w);
            DialogLayout.this.setWidgetAlignment(w, alignment);
            return this;
        }

        public Group addWidgets(Widget ... widgets) {
            for (Widget w : widgets) {
                this.addWidget(w);
            }
            return this;
        }

        public Group addWidgetsWithGap(String gapName, Widget ... widgets) {
            AnimationState.StateKey stateNotFirst = AnimationState.StateKey.get(gapName.concat("NotFirst"));
            AnimationState.StateKey stateNotLast = AnimationState.StateKey.get(gapName.concat("NotLast"));
            int n = widgets.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    this.addGap(gapName);
                }
                Widget w = widgets[i];
                this.addWidget(w);
                AnimationState as = w.getAnimationState();
                as.setAnimationState(stateNotFirst, i > 0);
                as.setAnimationState(stateNotLast, i < n - 1);
            }
            return this;
        }

        public Group addGap(int min, int pref, int max) {
            this.addSpring(new GapSpring(min, pref, max, false));
            return this;
        }

        public Group addGap(int size) {
            this.addSpring(new GapSpring(size, size, size, false));
            return this;
        }

        public Group addMinGap(int minSize) {
            this.addSpring(new GapSpring(minSize, minSize, Short.MAX_VALUE, false));
            return this;
        }

        public Group addGap() {
            this.addSpring(new GapSpring(0, 0, Short.MAX_VALUE, false));
            return this;
        }

        public Group addGap(String name) {
            if (name.length() == 0) {
                throw new IllegalArgumentException("name");
            }
            this.addSpring(new NamedGapSpring(name));
            return this;
        }

        public void removeDefaultGaps() {
            int i = this.springs.size();
            while (i-- > 0) {
                Spring s = (Spring)this.springs.get(i);
                if (s instanceof GapSpring) {
                    if (!((GapSpring)s).isDefault) continue;
                    this.springs.remove(i);
                    continue;
                }
                if (!(s instanceof Group)) continue;
                ((Group)s).removeDefaultGaps();
            }
        }

        public void addDefaultGap() {
            for (int i = 0; i < this.springs.size(); ++i) {
                Spring s = (Spring)this.springs.get(i);
                if (!(s instanceof Group)) continue;
                ((Group)s).addDefaultGap();
            }
        }

        public boolean removeGroup(Group g, boolean removeWidgets) {
            for (int i = 0; i < this.springs.size(); ++i) {
                if (this.springs.get(i) != g) continue;
                this.springs.remove(i);
                if (removeWidgets) {
                    g.removeWidgets();
                    DialogLayout.this.recheckWidgets();
                }
                DialogLayout.this.layoutGroupsChanged();
                return true;
            }
            return false;
        }

        public void clear(boolean removeWidgets) {
            if (removeWidgets) {
                this.removeWidgets();
            }
            this.springs.clear();
            if (removeWidgets) {
                DialogLayout.this.recheckWidgets();
            }
            DialogLayout.this.layoutGroupsChanged();
        }

        void addSpring(Spring s) {
            this.springs.add(s);
            DialogLayout.this.layoutGroupsChanged();
        }

        void recheckWidgets() {
            int i = this.springs.size();
            while (i-- > 0) {
                Spring s = (Spring)this.springs.get(i);
                if (s instanceof WidgetSpring) {
                    if (DialogLayout.this.widgetSprings.containsKey(((WidgetSpring)s).w)) continue;
                    this.springs.remove(i);
                    continue;
                }
                if (!(s instanceof Group)) continue;
                ((Group)s).recheckWidgets();
            }
        }

        void removeWidgets() {
            int i = this.springs.size();
            while (i-- > 0) {
                Spring s = (Spring)this.springs.get(i);
                if (s instanceof WidgetSpring) {
                    DialogLayout.this.removeChild((WidgetSpring)s);
                    continue;
                }
                if (!(s instanceof Group)) continue;
                ((Group)s).removeWidgets();
            }
        }
    }

    private class NamedGapSpring
    extends Spring {
        final String name;

        public NamedGapSpring(String name) {
            this.name = name;
        }

        @Override
        int getMaxSize(int axis) {
            return this.getGap().max;
        }

        @Override
        int getMinSize(int axis) {
            return this.getGap().min;
        }

        @Override
        int getPrefSize(int axis) {
            return this.getGap().preferred;
        }

        @Override
        void setSize(int axis, int pos, int size) {
        }

        private Gap getGap() {
            if (DialogLayout.this.namedGaps != null) {
                return (Gap)DialogLayout.this.namedGaps.getParameterValue(this.name, true, Gap.class, NO_GAP);
            }
            return NO_GAP;
        }
    }

    private class GapSpring
    extends Spring {
        final int min;
        final int pref;
        final int max;
        final boolean isDefault;

        GapSpring(int min, int pref, int max, boolean isDefault) {
            this.convertConstant(0, min);
            this.convertConstant(0, pref);
            this.convertConstant(0, max);
            this.min = min;
            this.pref = pref;
            this.max = max;
            this.isDefault = isDefault;
        }

        @Override
        int getMinSize(int axis) {
            return this.convertConstant(axis, this.min);
        }

        @Override
        int getPrefSize(int axis) {
            return this.convertConstant(axis, this.pref);
        }

        @Override
        int getMaxSize(int axis) {
            return this.convertConstant(axis, this.max);
        }

        @Override
        void setSize(int axis, int pos, int size) {
        }

        private int convertConstant(int axis, int value) {
            Dimension dim;
            if (value >= 0) {
                return value;
            }
            switch (value) {
                case -1: {
                    dim = DialogLayout.this.smallGap;
                    break;
                }
                case -2: {
                    dim = DialogLayout.this.mediumGap;
                    break;
                }
                case -3: {
                    dim = DialogLayout.this.largeGap;
                    break;
                }
                case -4: {
                    dim = DialogLayout.this.defaultGap;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid gap size: " + value);
                }
            }
            if (dim == null) {
                return 0;
            }
            if (axis == 0) {
                return dim.getX();
            }
            return dim.getY();
        }
    }

    private static class WidgetSpring
    extends Spring {
        final Widget w;
        Alignment alignment;
        int x;
        int y;
        int width;
        int height;
        int minWidth;
        int minHeight;
        int maxWidth;
        int maxHeight;
        int prefWidth;
        int prefHeight;
        int flags;

        WidgetSpring(Widget w) {
            this.w = w;
            this.alignment = Alignment.FILL;
        }

        void prepare() {
            this.x = this.w.getX();
            this.y = this.w.getY();
            this.width = this.w.getWidth();
            this.height = this.w.getHeight();
            this.minWidth = this.w.getMinWidth();
            this.minHeight = this.w.getMinHeight();
            this.maxWidth = this.w.getMaxWidth();
            this.maxHeight = this.w.getMaxHeight();
            this.prefWidth = Widget.computeSize(this.minWidth, this.w.getPreferredWidth(), this.maxWidth);
            this.prefHeight = Widget.computeSize(this.minHeight, this.w.getPreferredHeight(), this.maxHeight);
            this.flags = 0;
        }

        @Override
        int getMinSize(int axis) {
            switch (axis) {
                case 0: {
                    return this.minWidth;
                }
                case 1: {
                    return this.minHeight;
                }
            }
            throw new IllegalArgumentException("axis");
        }

        @Override
        int getPrefSize(int axis) {
            switch (axis) {
                case 0: {
                    return this.prefWidth;
                }
                case 1: {
                    return this.prefHeight;
                }
            }
            throw new IllegalArgumentException("axis");
        }

        @Override
        int getMaxSize(int axis) {
            switch (axis) {
                case 0: {
                    return this.maxWidth;
                }
                case 1: {
                    return this.maxHeight;
                }
            }
            throw new IllegalArgumentException("axis");
        }

        @Override
        void setSize(int axis, int pos, int size) {
            this.flags |= 1 << axis;
            switch (axis) {
                case 0: {
                    this.x = pos;
                    this.width = size;
                    break;
                }
                case 1: {
                    this.y = pos;
                    this.height = size;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("axis");
                }
            }
        }

        void apply() {
            if (this.flags != 3) {
                this.invalidState();
            }
            if (this.alignment != Alignment.FILL) {
                int newWidth = Math.min(this.width, this.prefWidth);
                int newHeight = Math.min(this.height, this.prefHeight);
                this.w.setPosition(this.x + this.alignment.computePositionX(this.width, newWidth), this.y + this.alignment.computePositionY(this.height, newHeight));
                this.w.setSize(newWidth, newHeight);
            } else {
                this.w.setPosition(this.x, this.y);
                this.w.setSize(this.width, this.height);
            }
        }

        @Override
        boolean isVisible() {
            return this.w.isVisible();
        }

        void invalidState() {
            StringBuilder sb = new StringBuilder();
            sb.append("Widget ").append(this.w).append(" with theme ").append(this.w.getTheme()).append(" is not part of the following groups:");
            if ((this.flags & 1) == 0) {
                sb.append(" horizontal");
            }
            if ((this.flags & 2) == 0) {
                sb.append(" vertical");
            }
            throw new IllegalStateException(sb.toString());
        }
    }

    static abstract class Spring {
        abstract int getMinSize(int var1);

        abstract int getPrefSize(int var1);

        abstract int getMaxSize(int var1);

        abstract void setSize(int var1, int var2, int var3);

        Spring() {
        }

        void collectAllSprings(HashSet result) {
            result.add(this);
        }

        boolean isVisible() {
            return true;
        }
    }

    public static class Gap {
        public final int min;
        public final int preferred;
        public final int max;

        public Gap() {
            this(0, 0, Short.MAX_VALUE);
        }

        public Gap(int size) {
            this(size, size, size);
        }

        public Gap(int min, int preferred) {
            this(min, preferred, Short.MAX_VALUE);
        }

        public Gap(int min, int preferred, int max) {
            if (min < 0) {
                throw new IllegalArgumentException("min");
            }
            if (preferred < min) {
                throw new IllegalArgumentException("preferred");
            }
            if (max < 0 || max > 0 && max < preferred) {
                throw new IllegalArgumentException("max");
            }
            this.min = min;
            this.preferred = preferred;
            this.max = max;
        }
    }
}

