/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Alignment;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ColumnLayout
extends DialogLayout {
    final ArrayList columnGroups = new ArrayList();
    private final Panel rootPanel = new Panel(null);
    private final HashMap columns = new HashMap();

    public ColumnLayout() {
        this.setHorizontalGroup(this.createParallelGroup());
        this.setVerticalGroup(this.rootPanel.rows);
    }

    public final Panel getRootPanel() {
        return this.rootPanel;
    }

    public Columns getColumns(String ... columnNames) {
        if (columnNames.length == 0) {
            throw new IllegalArgumentException("columnNames");
        }
        Columns key = new Columns(columnNames);
        Columns cl = (Columns)this.columns.get(key);
        if (cl != null) {
            return cl;
        }
        this.createColumns(key);
        return key;
    }

    public Row addRow(Columns columns) {
        return this.rootPanel.addRow(columns);
    }

    public Row addRow(String ... columnNames) {
        return this.rootPanel.addRow(this.getColumns(columnNames));
    }

    private void createColumns(Columns cl) {
        int i;
        int prefixSize = 0;
        Columns prefixColumns = null;
        for (Columns c : this.columns.values()) {
            int match = c.match(cl);
            if (match <= prefixSize) continue;
            prefixSize = match;
            prefixColumns = c;
        }
        int numColumns = 0;
        int n = cl.names.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (cl.isGap(i2)) continue;
            ++numColumns;
        }
        cl.numColumns = numColumns;
        cl.firstColumn = this.columnGroups.size();
        cl.childGroups = new DialogLayout.Group[cl.names.length];
        DialogLayout.Group h = this.createSequentialGroup();
        if (prefixColumns == null) {
            this.getHorizontalGroup().addGroup(h);
        } else {
            for (i = 0; i < prefixSize; ++i) {
                if (cl.isGap(i)) continue;
                DialogLayout.Group g = (DialogLayout.Group)this.columnGroups.get(prefixColumns.firstColumn + i);
                this.columnGroups.add(g);
            }
            System.arraycopy(prefixColumns.childGroups, 0, cl.childGroups, 0, prefixSize);
            cl.childGroups[prefixSize - 1].addGroup(h);
        }
        int n2 = cl.names.length;
        for (i = prefixSize; i < n2; ++i) {
            if (cl.isGap(i)) {
                h.addGap();
            } else {
                DialogLayout.Group g = this.createParallelGroup();
                h.addGroup(g);
                this.columnGroups.add(g);
            }
            DialogLayout.Group nextSequential = this.createSequentialGroup();
            DialogLayout.Group childGroup = this.createParallelGroup().addGroup(nextSequential);
            h.addGroup(childGroup);
            h = nextSequential;
            cl.childGroups[i] = childGroup;
        }
        this.columns.put(cl, cl);
    }

    public final class Panel {
        final Panel parent;
        final ArrayList usedColumnGroups;
        final ArrayList children;
        final DialogLayout.Group rows;
        boolean valid;

        Panel(Panel parent) {
            this.parent = parent;
            this.usedColumnGroups = new ArrayList();
            this.children = new ArrayList();
            this.rows = ColumnLayout.this.createSequentialGroup();
            this.valid = true;
        }

        public boolean isValid() {
            return this.valid;
        }

        public Columns getColumns(String ... columnNames) {
            return ColumnLayout.this.getColumns(columnNames);
        }

        public Row addRow(String ... columnNames) {
            return this.addRow(ColumnLayout.this.getColumns(columnNames));
        }

        public Row addRow(Columns columns) {
            if (columns == null) {
                throw new NullPointerException("columns");
            }
            this.checkValid();
            DialogLayout.Group row = ColumnLayout.this.createParallelGroup();
            this.rows.addGroup(row);
            return new Row(columns, this, row);
        }

        public void addVerticalGap(String name) {
            this.checkValid();
            this.rows.addGap(name);
        }

        public Panel addPanel() {
            this.checkValid();
            Panel panel = new Panel(this);
            this.rows.addGroup(panel.rows);
            this.children.add(panel);
            return panel;
        }

        public void removePanel(Panel panel) {
            if (panel == null) {
                throw new NullPointerException("panel");
            }
            if (this.valid && this.children.remove(panel)) {
                panel.markInvalid();
                this.rows.removeGroup(panel.rows, true);
                int n = panel.usedColumnGroups.size();
                for (int i = 0; i < n; ++i) {
                    DialogLayout.Group column = (DialogLayout.Group)panel.usedColumnGroups.get(i);
                    if (column == null) continue;
                    ((DialogLayout.Group)this.usedColumnGroups.get(i)).removeGroup(column, false);
                }
            }
        }

        public void clearPanel() {
            if (this.valid) {
                this.children.clear();
                this.rows.clear(true);
                int n = this.usedColumnGroups.size();
                for (int i = 0; i < n; ++i) {
                    DialogLayout.Group column = (DialogLayout.Group)this.usedColumnGroups.get(i);
                    if (column == null) continue;
                    column.clear(false);
                }
            }
        }

        void markInvalid() {
            this.valid = false;
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                ((Panel)this.children.get(i)).markInvalid();
            }
        }

        void checkValid() {
            if (!this.valid) {
                throw new IllegalStateException("Panel has been removed");
            }
        }

        DialogLayout.Group getColumn(int idx) {
            DialogLayout.Group column;
            this.checkValid();
            if (this.usedColumnGroups.size() > idx && (column = (DialogLayout.Group)this.usedColumnGroups.get(idx)) != null) {
                return column;
            }
            return this.makeColumn(idx);
        }

        private DialogLayout.Group makeColumn(int idx) {
            DialogLayout.Group parentColumn = this.parent != null ? this.parent.getColumn(idx) : (DialogLayout.Group)ColumnLayout.this.columnGroups.get(idx);
            DialogLayout.Group column = ColumnLayout.this.createParallelGroup();
            parentColumn.addGroup(column);
            while (this.usedColumnGroups.size() <= idx) {
                this.usedColumnGroups.add(null);
            }
            this.usedColumnGroups.set(idx, column);
            return column;
        }
    }

    public final class Row {
        final Columns columns;
        final Panel panel;
        final DialogLayout.Group row;
        int curColumn;

        Row(Columns columns, Panel panel, DialogLayout.Group row) {
            this.columns = columns;
            this.panel = panel;
            this.row = row;
        }

        public int getCurrentColumn() {
            return this.curColumn;
        }

        public Columns getColumns() {
            return this.columns;
        }

        public Row add(Widget w) {
            if (this.curColumn == this.columns.numColumns) {
                throw new IllegalStateException("Too many widgets for column layout");
            }
            this.panel.getColumn(this.columns.firstColumn + this.curColumn).addWidget(w);
            this.row.addWidget(w);
            ++this.curColumn;
            return this;
        }

        public Row add(Widget w, Alignment alignment) {
            this.add(w);
            ColumnLayout.this.setWidgetAlignment(w, alignment);
            return this;
        }

        public Row addLabel(String labelText) {
            if (labelText == null) {
                throw new NullPointerException("labelText");
            }
            return this.add(new Label(labelText));
        }

        public Row addWithLabel(String labelText, Widget w) {
            if (labelText == null) {
                throw new NullPointerException("labelText");
            }
            Label labelWidget = new Label(labelText);
            labelWidget.setLabelFor(w);
            this.add(labelWidget, Alignment.TOPLEFT).add(w);
            return this;
        }

        public Row addWithLabel(String labelText, Widget w, Alignment alignment) {
            this.addWithLabel(labelText, w);
            ColumnLayout.this.setWidgetAlignment(w, alignment);
            return this;
        }
    }

    public static final class Columns {
        final String[] names;
        final int hashcode;
        int firstColumn;
        int numColumns;
        DialogLayout.Group[] childGroups;

        Columns(String[] names) {
            this.names = (String[])names.clone();
            this.hashcode = Arrays.hashCode(this.names);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Columns other = (Columns)obj;
            return this.hashcode == other.hashcode && Arrays.equals(this.names, other.names);
        }

        public int getNumColumns() {
            return this.numColumns;
        }

        public int getNumColumnNames() {
            return this.names.length;
        }

        public String getColumnName(int idx) {
            return this.names[idx];
        }

        public int hashCode() {
            return this.hashcode;
        }

        boolean isGap(int column) {
            String name = this.names[column];
            return name.length() == 0 || "-".equals(name);
        }

        int match(Columns other) {
            int cnt = Math.min(this.names.length, other.names.length);
            for (int i = 0; i < cnt; ++i) {
                if (this.names[i].equals(other.names[i])) continue;
                return i;
            }
            return cnt;
        }
    }
}

