/*
 * Decompiled with CFR 0.152.
 */
package openblocks.utils;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryUtils {
    public static void tryMergeStacks(IInventory targetInventory, int slot, ItemStack stack) {
        if (targetInventory.func_94041_b(slot, stack)) {
            ItemStack targetStack = targetInventory.func_70301_a(slot);
            if (targetStack == null) {
                targetInventory.func_70299_a(slot, stack.func_77946_l());
                stack.field_77994_a = 0;
            } else {
                boolean valid = targetInventory.func_94041_b(slot, stack);
                if (valid && stack.field_77993_c == targetStack.field_77993_c && (!stack.func_77981_g() || stack.func_77960_j() == targetStack.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)targetStack) && targetStack.field_77994_a < targetStack.func_77976_d()) {
                    int space = targetStack.func_77976_d() - targetStack.field_77994_a;
                    int mergeAmount = Math.min(space, stack.field_77994_a);
                    ItemStack copy = targetStack.func_77946_l();
                    copy.field_77994_a += mergeAmount;
                    targetInventory.func_70299_a(slot, copy);
                    stack.field_77994_a -= mergeAmount;
                }
            }
        }
    }

    public static void insertItemIntoInventory(IInventory inventory, ItemStack stack) {
        for (int i = 0; stack.field_77994_a > 0 && i < inventory.func_70302_i_(); ++i) {
            InventoryUtils.tryMergeStacks(inventory, i, stack);
        }
    }

    public static int moveItemInto(IInventory fromInventory, int slot, IInventory targetInventory, int intoSlot, int maxAmount) {
        int merged = 0;
        ItemStack stack = fromInventory.func_70301_a(slot);
        if (stack == null) {
            return merged;
        }
        ItemStack clonedStack = stack.func_77946_l();
        int amountToMerge = clonedStack.field_77994_a = Math.min(clonedStack.field_77994_a, maxAmount);
        InventoryUtils.tryMergeStacks(targetInventory, intoSlot, clonedStack);
        merged = amountToMerge - clonedStack.field_77994_a;
        fromInventory.func_70298_a(slot, merged);
        return merged;
    }

    public static int moveItem(IInventory fromInventory, int slot, IInventory targetInventory, int maxAmount) {
        int merged = 0;
        ItemStack stack = fromInventory.func_70301_a(slot);
        if (stack == null) {
            return 0;
        }
        ItemStack clonedStack = stack.func_77946_l();
        int amountToMerge = clonedStack.field_77994_a = Math.min(clonedStack.field_77994_a, maxAmount);
        InventoryUtils.insertItemIntoInventory(targetInventory, clonedStack);
        merged = amountToMerge - clonedStack.field_77994_a;
        fromInventory.func_70298_a(slot, merged);
        return merged;
    }

    public static boolean consumeInventoryItem(IInventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (stackInSlot == null || !stackInSlot.func_77969_a(stack)) continue;
            --stackInSlot.field_77994_a;
            if (stackInSlot.field_77994_a == 0) {
                inventory.func_70299_a(i, null);
            }
            return true;
        }
        return false;
    }
}

