/*
 * Decompiled with CFR 0.152.
 */
package openblocks.utils;

import net.minecraftforge.common.ForgeDirection;

public class Coord {
    public int x;
    public int y;
    public int z;

    public Coord() {
    }

    public Coord(ForgeDirection direction) {
        this.x = direction.offsetX;
        this.y = direction.offsetY;
        this.z = direction.offsetZ;
    }

    public Coord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void offset(ForgeDirection direction) {
        this.x += direction.offsetX;
        this.y += direction.offsetY;
        this.z += direction.offsetZ;
    }

    public void set(int x, int y, int z) {
        this.x = x;
        this.y = x;
        this.z = z;
    }

    public int hashCode() {
        return this.x + 128 << 16 | this.y + 128 << 8 | this.z + 128;
    }

    public boolean equals(Object that) {
        if (!(that instanceof Coord)) {
            return false;
        }
        Coord otherCoord = (Coord)that;
        return otherCoord.x == this.x && otherCoord.y == this.y && otherCoord.z == this.z;
    }

    public String toString() {
        return String.format("%s,%s,%s", this.x, this.y, this.z);
    }

    public void offset(int ox, int oy, int oz) {
        this.x += ox;
        this.y += oy;
        this.z += oz;
    }

    public void setFrom(Coord copy) {
        this.x = copy.x;
        this.y = copy.y;
        this.z = copy.z;
    }

    public Coord clone() {
        return new Coord(this.x, this.y, this.z);
    }
}

