/*
 * Decompiled with CFR 0.152.
 */
package openblocks.utils;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockUtils {
    public static ForgeDirection get2dOrientation(EntityLiving entity) {
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (l) {
            case 0: {
                return ForgeDirection.SOUTH;
            }
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.EAST;
            }
        }
        return ForgeDirection.SOUTH;
    }

    public static float getRotationFromDirection(ForgeDirection direction) {
        switch (direction) {
            case NORTH: {
                return 0.0f;
            }
            case SOUTH: {
                return 180.0f;
            }
            case WEST: {
                return 90.0f;
            }
            case EAST: {
                return -90.0f;
            }
            case DOWN: {
                return -90.0f;
            }
            case UP: {
                return 90.0f;
            }
        }
        return 0.0f;
    }

    public static ForgeDirection get3dOrientation(EntityLiving entity) {
        if (entity.field_70125_A > 45.5f) {
            return ForgeDirection.DOWN;
        }
        if (entity.field_70125_A < -45.5f) {
            return ForgeDirection.UP;
        }
        return BlockUtils.get2dOrientation(entity);
    }

    public static void dropItemStackInWorld(World worldObj, int x, int y, int z, ItemStack stack) {
        BlockUtils.dropItemStackInWorld(worldObj, (double)x, (double)y, (double)z, stack);
    }

    public static void dropItemStackInWorld(World worldObj, double x, double y, double z, ItemStack stack) {
        float f = 0.7f;
        double d0 = (double)(worldObj.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(worldObj.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(worldObj.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(worldObj, x + d0, y + d1, z + d2, stack);
        entityitem.field_70293_c = 10;
        if (stack.func_77942_o()) {
            entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
        }
        worldObj.func_72838_d((Entity)entityitem);
    }

    public static void dropTileInventory(TileEntity tileEntity) {
        if (tileEntity != null && tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            BlockUtils.dropInventory(inventory, tileEntity.field_70331_k, tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n);
        }
    }

    public static void dropInventory(IInventory inventory, World world, double x, double y, double z) {
        Random rand = world.field_73012_v;
        if (inventory == null) {
            return;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null) continue;
            BlockUtils.dropItemStackInWorld(world, x, y, z, itemStack);
        }
    }

    public static void dropInventory(IInventory inventory, World world, int x, int y, int z) {
        BlockUtils.dropInventory(inventory, world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
    }

    public static TileEntity getTileInDirection(TileEntity tile, ForgeDirection direction) {
        int targetX = tile.field_70329_l + direction.offsetX;
        int targetY = tile.field_70330_m + direction.offsetY;
        int targetZ = tile.field_70327_n + direction.offsetZ;
        return tile.field_70331_k.func_72796_p(targetX, targetY, targetZ);
    }

    public static ForgeDirection sideToDirection(int side) {
        ForgeDirection direction = ForgeDirection.UNKNOWN;
        switch (side) {
            case 0: {
                direction = ForgeDirection.DOWN;
                break;
            }
            case 1: {
                direction = ForgeDirection.UP;
                break;
            }
            case 2: {
                direction = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                direction = ForgeDirection.SOUTH;
                break;
            }
            case 4: {
                direction = ForgeDirection.WEST;
                break;
            }
            default: {
                direction = ForgeDirection.EAST;
            }
        }
        return direction;
    }

    public static int testInventoryInsertion(IInventory inventory, ItemStack item) {
        if (item == null || item.field_77994_a == 0) {
            return 0;
        }
        if (inventory == null) {
            return 0;
        }
        int slotCount = inventory.func_70302_i_();
        int itemSizeCounter = item.field_77994_a;
        for (int i = 0; i < slotCount && itemSizeCounter > 0; ++i) {
            if (!inventory.func_94041_b(i, item)) continue;
            ItemStack inventorySlot = inventory.func_70301_a(i);
            if (inventorySlot == null) {
                itemSizeCounter -= Math.min(Math.min(itemSizeCounter, inventory.func_70297_j_()), item.func_77976_d());
                continue;
            }
            if (item.field_77993_c != inventorySlot.field_77993_c || item.func_77981_g() && item.func_77960_j() != inventorySlot.func_77960_j() || !ItemStack.func_77970_a((ItemStack)item, (ItemStack)inventorySlot) || inventorySlot.field_77994_a >= inventorySlot.func_77976_d()) continue;
            int space = inventorySlot.func_77976_d() - inventorySlot.field_77994_a;
            itemSizeCounter -= Math.min(itemSizeCounter, space);
        }
        if (itemSizeCounter != item.field_77994_a) {
            itemSizeCounter = Math.max(itemSizeCounter, 0);
            return item.field_77994_a - itemSizeCounter;
        }
        return 0;
    }
}

