/*
 * Decompiled with CFR 0.152.
 */
package openblocks.sync;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import openblocks.sync.ISyncableObject;

public class SyncableTank
implements ISyncableObject,
ILiquidTank {
    private LiquidStack liquid;
    private int capacity;
    private int tankPressure;
    private boolean hasChanged;
    private int ticksSinceChanged = 0;

    public SyncableTank(int capacity) {
        this.capacity = capacity;
    }

    public LiquidStack getLiquid() {
        return this.liquid;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getAmount() {
        return this.liquid != null ? this.liquid.amount : 0;
    }

    public double getPercentFull() {
        return (double)this.getAmount() / (double)this.getCapacity();
    }

    public void clear() {
        this.liquid = null;
    }

    public int fill(LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID <= 0) {
            return 0;
        }
        if (this.liquid == null || this.liquid.itemID <= 0) {
            if (resource.amount <= this.capacity) {
                if (doFill) {
                    this.liquid = resource.copy();
                    this.setHasChanged();
                }
                return resource.amount;
            }
            if (doFill) {
                this.liquid = resource.copy();
                this.liquid.amount = this.capacity;
                this.setHasChanged();
            }
            return this.capacity;
        }
        if (!this.liquid.isLiquidEqual(resource)) {
            return 0;
        }
        int space = this.capacity - this.liquid.amount;
        if (resource.amount <= space) {
            if (doFill) {
                this.liquid.amount += resource.amount;
                this.setHasChanged();
            }
            return resource.amount;
        }
        if (doFill) {
            this.liquid.amount = this.capacity;
            this.setHasChanged();
        }
        return space;
    }

    public LiquidStack drain(int maxDrain, boolean doDrain) {
        if (this.liquid == null || this.liquid.itemID <= 0) {
            return null;
        }
        if (this.liquid.amount <= 0) {
            return null;
        }
        int used = maxDrain;
        if (this.liquid.amount < used) {
            used = this.liquid.amount;
        }
        if (doDrain) {
            this.liquid.amount -= used;
            this.setHasChanged();
        }
        LiquidStack drained = new LiquidStack(this.liquid.itemID, used, this.liquid.itemMeta);
        if (this.liquid.amount <= 0) {
            this.liquid = null;
            this.setHasChanged();
        }
        return drained;
    }

    public int getTankPressure() {
        return this.tankPressure;
    }

    public void setTankPressure(int pressure) {
        this.tankPressure = pressure;
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void resetChangeStatus() {
        ++this.ticksSinceChanged;
        this.hasChanged = false;
    }

    @Override
    public void setHasChanged() {
        this.hasChanged = true;
        this.ticksSinceChanged = 0;
    }

    public boolean containsValidLiquid() {
        return LiquidDictionary.findLiquidName((LiquidStack)this.liquid) != null;
    }

    public void setLiquid(LiquidStack liquid) {
        this.liquid = liquid;
        this.setHasChanged();
    }

    public void setCapacity(int capacity) {
        if (capacity != this.capacity) {
            this.capacity = capacity;
            this.setHasChanged();
        }
    }

    @Override
    public void readFromStream(DataInputStream stream) throws IOException {
        int liquidId = stream.readInt();
        int liquidMeta = stream.readInt();
        this.liquid = liquidId == 0 && liquidMeta == 0 ? null : new LiquidStack(liquidId, 1, liquidMeta);
        int amount = stream.readInt();
        if (this.liquid != null) {
            this.liquid.amount = amount;
        }
        if (amount == 0) {
            this.liquid = null;
        }
        this.capacity = stream.readInt();
    }

    @Override
    public void writeToStream(DataOutputStream stream, boolean fullData) throws IOException {
        stream.writeInt(this.liquid == null ? 0 : this.liquid.itemID);
        stream.writeInt(this.liquid == null ? 0 : this.liquid.itemMeta);
        stream.writeInt(this.liquid == null ? 0 : this.liquid.amount);
        stream.writeInt(this.capacity);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        NBTTagCompound tankTag = new NBTTagCompound();
        if (this.containsValidLiquid()) {
            this.liquid.writeToNBT(tankTag);
        }
        tag.func_74766_a(name, tankTag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        NBTTagCompound nbt;
        LiquidStack liquid;
        if (tag.func_74764_b(name) && (liquid = LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)(nbt = tag.func_74775_l(name)))) != null) {
            this.liquid = liquid;
        }
    }

    public int getSpace() {
        return this.getCapacity() - this.getAmount();
    }

    public static enum Flags {
        capacity,
        amount,
        liquid;

    }
}

