/*
 * Decompiled with CFR 0.152.
 */
package openblocks.sync;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import openblocks.sync.ISyncableObject;

public class SyncableShort
implements ISyncableObject {
    private short value = 0;
    private boolean hasChanged = false;
    private int ticksSinceChanged = 0;

    public SyncableShort(short value) {
        this.value = value;
    }

    public SyncableShort() {
        this(0);
    }

    @Override
    public void readFromStream(DataInputStream stream) throws IOException {
        this.value = stream.readShort();
    }

    public void modify(short by) {
        this.setValue((short)(this.value + by));
    }

    public void setValue(short val) {
        if (val != this.value) {
            this.value = val;
            this.setHasChanged();
        }
    }

    public short getValue() {
        return this.value;
    }

    @Override
    public void writeToStream(DataOutputStream stream, boolean fullData) throws IOException {
        stream.writeShort(this.value);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74777_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        if (tag.func_74764_b(name)) {
            this.value = tag.func_74765_d(name);
        }
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void resetChangeStatus() {
        this.hasChanged = false;
        ++this.ticksSinceChanged;
    }

    @Override
    public void setHasChanged() {
        this.hasChanged = true;
        this.ticksSinceChanged = 0;
    }
}

