/*
 * Decompiled with CFR 0.152.
 */
package openblocks.sync;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import openblocks.sync.ISyncableObject;

public class SyncableIntArray
implements ISyncableObject {
    private int[] value;
    private boolean hasChanged = false;
    private int ticksSinceChanged = 0;

    public SyncableIntArray(int[] value) {
        this.value = value;
    }

    public SyncableIntArray() {
        this(new int[0]);
    }

    public void setValue(int[] newValue) {
        if (!Arrays.equals(this.value, newValue)) {
            this.value = newValue;
            this.setHasChanged();
        }
    }

    public int[] getValue() {
        return this.value;
    }

    public int size() {
        if (this.value == null) {
            return 0;
        }
        return this.value.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void readFromStream(DataInputStream stream) throws IOException {
        int length = stream.readInt();
        this.value = new int[length];
        for (int i = 0; i < length; ++i) {
            this.value[i] = stream.readInt();
        }
    }

    @Override
    public void writeToStream(DataOutputStream stream, boolean fullData) throws IOException {
        stream.writeInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            stream.writeInt(this.value[i]);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74783_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        if (tag.func_74764_b(name)) {
            this.value = tag.func_74759_k(name);
        }
    }

    public void clear() {
        this.value = new int[0];
        this.hasChanged = true;
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void resetChangeStatus() {
        this.hasChanged = false;
        ++this.ticksSinceChanged;
    }

    @Override
    public void setHasChanged() {
        this.hasChanged = true;
        this.ticksSinceChanged = 0;
    }
}

