/*
 * Decompiled with CFR 0.152.
 */
package openblocks.sync;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import openblocks.sync.ISyncableObject;

public class SyncableInt
implements ISyncableObject {
    private int value = 0;
    private boolean hasChanged = false;
    private int ticksSinceChanged = 0;

    public SyncableInt(int value) {
        this.value = value;
    }

    public SyncableInt() {
        this(0);
    }

    @Override
    public void readFromStream(DataInputStream stream) throws IOException {
        this.value = stream.readInt();
    }

    public void modify(int by) {
        this.setValue(this.value + by);
    }

    public void setValue(int val) {
        if (val != this.value) {
            this.value = val;
            this.setHasChanged();
        }
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public void writeToStream(DataOutputStream stream, boolean fullData) throws IOException {
        stream.writeInt(this.value);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74768_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        if (tag.func_74764_b(name)) {
            this.value = tag.func_74762_e(name);
        }
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void resetChangeStatus() {
        this.hasChanged = false;
        ++this.ticksSinceChanged;
    }

    @Override
    public void setHasChanged() {
        this.hasChanged = true;
        this.ticksSinceChanged = 0;
    }
}

