/*
 * Decompiled with CFR 0.152.
 */
package openblocks.sync;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import openblocks.sync.ISyncableObject;

public class SyncableFloat
implements ISyncableObject {
    public static final float EPSILON = 1.0E-4f;
    private float value;
    private boolean hasChanged = false;
    private int ticksSinceChanged = 0;

    public SyncableFloat(float value) {
        this.value = value;
    }

    public SyncableFloat() {
        this(0.0f);
    }

    public void setValue(float newValue) {
        if (!this.equals(newValue)) {
            this.value = newValue;
            this.setHasChanged();
        }
    }

    public float getValue() {
        return this.value;
    }

    public boolean equals(float otherValue) {
        return Math.abs(otherValue - this.value) < 1.0E-4f;
    }

    @Override
    public void readFromStream(DataInputStream stream) throws IOException {
        this.value = stream.readFloat();
    }

    @Override
    public void writeToStream(DataOutputStream stream, boolean fullData) throws IOException {
        stream.writeFloat(this.value);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74776_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        if (tag.func_74764_b(name)) {
            this.value = tag.func_74760_g(name);
        }
    }

    public void modify(float by) {
        this.setValue(this.value + by);
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void resetChangeStatus() {
        this.hasChanged = false;
        ++this.ticksSinceChanged;
    }

    @Override
    public void setHasChanged() {
        this.hasChanged = true;
        this.ticksSinceChanged = 0;
    }
}

