/*
 * Decompiled with CFR 0.152.
 */
package openblocks.sync;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import openblocks.sync.ISyncableObject;
import openblocks.utils.ByteUtils;

public class SyncableFlags
implements ISyncableObject {
    private short value;
    private short previousValue;
    private boolean hasChanged = false;
    protected int[] ticksSinceSet = new int[16];
    protected int[] ticksSinceUnset = new int[16];
    protected int ticksSinceChanged = 0;

    public void on(Enum slot) {
        this.on(slot.ordinal());
    }

    public void on(int slot) {
        this.set(slot, true);
    }

    public void off(Enum slot) {
        this.off(slot.ordinal());
    }

    public void off(int slot) {
        this.set(slot, false);
    }

    public void set(Enum slot, boolean bool) {
        this.set(slot.ordinal(), bool);
    }

    public void set(int slot, boolean bool) {
        short newVal = ByteUtils.set(this.value, slot, bool);
        if (newVal != this.value) {
            if (bool) {
                this.ticksSinceSet[slot] = 0;
            } else {
                this.ticksSinceUnset[slot] = 0;
            }
            this.setHasChanged();
        }
        this.value = newVal;
    }

    @Override
    public void setHasChanged() {
        this.hasChanged = true;
        this.ticksSinceChanged = 0;
    }

    public int ticksSinceSet(Enum slot) {
        return this.ticksSinceSet(slot.ordinal());
    }

    public int ticksSinceSet(int slot) {
        return this.ticksSinceSet[slot];
    }

    public int ticksSinceUnset(Enum slot) {
        return this.ticksSinceUnset(slot.ordinal());
    }

    public int ticksSinceUnset(int slot) {
        return this.ticksSinceUnset[slot];
    }

    public int ticksSinceChange(Enum slot) {
        return this.ticksSinceChange(slot.ordinal());
    }

    public int ticksSinceChange(int slot) {
        return this.ticksSinceChanged;
    }

    public boolean get(Enum slot) {
        return this.get(slot.ordinal());
    }

    public boolean get(int slot) {
        return ByteUtils.get(this.value, slot);
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    public boolean hasSlotChanged(Enum slot) {
        return this.hasSlotChanged(slot.ordinal());
    }

    public boolean hasSlotChanged(int slot) {
        return ByteUtils.get(this.value, slot) != ByteUtils.get(this.previousValue, slot);
    }

    @Override
    public void resetChangeStatus() {
        this.previousValue = this.value;
        this.hasChanged = false;
        int i = 0;
        while (i < this.ticksSinceSet.length) {
            int n = i;
            this.ticksSinceSet[n] = this.ticksSinceSet[n] + 1;
            int n2 = i++;
            this.ticksSinceUnset[n2] = this.ticksSinceUnset[n2] + 1;
        }
        ++this.ticksSinceChanged;
    }

    @Override
    public void readFromStream(DataInputStream stream) throws IOException {
        this.value = stream.readShort();
    }

    @Override
    public void writeToStream(DataOutputStream stream, boolean fullData) throws IOException {
        stream.writeShort(this.value);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74777_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        if (tag.func_74764_b(name)) {
            this.value = tag.func_74765_d(name);
        }
    }
}

