/*
 * Decompiled with CFR 0.152.
 */
package openblocks.sync;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import openblocks.sync.ISyncableObject;

public class SyncableDouble
implements ISyncableObject {
    private double value;
    private boolean hasChanged = false;
    private int ticksSinceChanged = 0;

    public SyncableDouble(double value) {
        this.value = value;
    }

    public SyncableDouble() {
        this(0.0);
    }

    public void setValue(double newValue) {
        if (newValue != this.value) {
            this.value = newValue;
            this.setHasChanged();
        }
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void readFromStream(DataInputStream stream) throws IOException {
        this.value = stream.readDouble();
    }

    @Override
    public void writeToStream(DataOutputStream stream, boolean fullData) throws IOException {
        stream.writeDouble(this.value);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74780_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        if (tag.func_74764_b(name)) {
            this.value = tag.func_74769_h(name);
        }
    }

    public void modify(float by) {
        this.setValue(this.value + (double)by);
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void resetChangeStatus() {
        this.hasChanged = false;
        ++this.ticksSinceChanged;
    }

    @Override
    public void setHasChanged() {
        this.hasChanged = true;
        this.ticksSinceChanged = 0;
    }
}

