/*
 * Decompiled with CFR 0.152.
 */
package openblocks.sync;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import openblocks.sync.ISyncableObject;

public class SyncableDirection
implements ISyncableObject {
    private ForgeDirection value = ForgeDirection.UNKNOWN;
    private boolean hasChanged = false;
    private int ticksSinceChanged = 0;

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void resetChangeStatus() {
        this.hasChanged = false;
        ++this.ticksSinceChanged;
    }

    @Override
    public void setHasChanged() {
        this.hasChanged = true;
        this.ticksSinceChanged = 0;
    }

    public ForgeDirection getValue() {
        return this.value;
    }

    public void setValue(ForgeDirection direction) {
        if (direction != this.value) {
            this.setHasChanged();
            this.value = direction;
        }
    }

    @Override
    public void readFromStream(DataInputStream stream) throws IOException {
        this.value = ForgeDirection.getOrientation((int)stream.readByte());
    }

    @Override
    public void writeToStream(DataOutputStream stream, boolean fullData) throws IOException {
        stream.writeByte(this.value.ordinal());
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        if (tag.func_74764_b(name)) {
            this.value = ForgeDirection.getOrientation((int)tag.func_74771_c(name));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        tag.func_74774_a(name, (byte)this.value.ordinal());
    }
}

