/*
 * Decompiled with CFR 0.152.
 */
package openblocks.sync;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.world.World;
import openblocks.network.PacketHandler;
import openblocks.sync.ISyncHandler;
import openblocks.sync.ISyncableObject;
import openblocks.utils.ByteUtils;

public abstract class SyncMap {
    private int trackingRange = 64;
    private long totalTrackingTime = 0L;
    public List usersInRange = new ArrayList();
    private ISyncableObject[] objects = new ISyncableObject[16];

    public SyncMap() {
    }

    public SyncMap(int trackingRange) {
        this.trackingRange = trackingRange;
    }

    public void put(Enum id, ISyncableObject value) {
        this.put(id.ordinal(), value);
    }

    public void put(int id, ISyncableObject value) {
        this.objects[id] = value;
    }

    public List readFromStream(DataInputStream dis) throws IOException {
        short mask = dis.readShort();
        ArrayList<ISyncableObject> changes = new ArrayList<ISyncableObject>();
        for (int i = 0; i < 16; ++i) {
            if (!ByteUtils.get(mask, i) || this.objects[i] == null) continue;
            this.objects[i].readFromStream(dis);
            changes.add(this.objects[i]);
            this.objects[i].setHasChanged();
        }
        return changes;
    }

    public void writeToStream(DataOutputStream dos, boolean regardless) throws IOException {
        int i;
        short mask = 0;
        for (i = 0; i < 16; ++i) {
            mask = ByteUtils.set(mask, i, this.objects[i] != null && (regardless || this.objects[i].hasChanged()));
        }
        dos.writeShort(mask);
        for (i = 0; i < 16; ++i) {
            if (this.objects[i] == null || !regardless && !this.objects[i].hasChanged()) continue;
            this.objects[i].writeToStream(dos, regardless);
        }
    }

    public void resetChangeStatus() {
        for (int i = 0; i < 16; ++i) {
            if (this.objects[i] == null) continue;
            this.objects[i].resetChangeStatus();
        }
    }

    public void sync(World worldObj, ISyncHandler handler, double x, double y, double z) {
        this.sync(worldObj, handler, x, y, z, 20);
    }

    public void sync(World worldObj, ISyncHandler handler, double x, double y, double z, int tickUpdatePeriod) {
        if (!worldObj.field_72995_K) {
            long worldTotalTime = worldObj.func_82737_E();
            if (this.totalTrackingTime == 0L) {
                this.totalTrackingTime = worldTotalTime;
            }
            if (worldTotalTime - this.totalTrackingTime < (long)tickUpdatePeriod) {
                return;
            }
            this.totalTrackingTime = worldTotalTime;
            List players = PacketHandler.getPlayersInRange(worldObj, (int)x, (int)z, this.trackingRange);
            if (players.size() > 0) {
                Packet changePacket = null;
                Packet fullPacket = null;
                boolean hasChanges = false;
                for (ISyncableObject obj : this.objects) {
                    if (obj == null || !obj.hasChanged()) continue;
                    hasChanges = true;
                    break;
                }
                try {
                    ArrayList<Integer> newUsersInRange = new ArrayList<Integer>();
                    for (EntityPlayer player : players) {
                        newUsersInRange.add(player.field_70157_k);
                        if (player == null) continue;
                        Packet packetToSend = null;
                        if (this.usersInRange.contains(player.field_70157_k)) {
                            if (hasChanges) {
                                if (changePacket == null) {
                                    changePacket = this.createPacket(handler, false);
                                }
                                packetToSend = changePacket;
                            }
                        } else {
                            if (fullPacket == null) {
                                fullPacket = this.createPacket(handler, true);
                            }
                            packetToSend = fullPacket;
                        }
                        if (packetToSend == null) continue;
                        ((EntityPlayerMP)player).field_71135_a.func_72567_b(packetToSend);
                    }
                    this.usersInRange = newUsersInRange;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.usersInRange.clear();
            }
        }
        this.resetChangeStatus();
    }

    protected Packet createPacket(ISyncHandler handler, boolean fullPacket) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
        DataOutputStream outputStream = new DataOutputStream(bos);
        this.writeMapType(outputStream);
        handler.writeIdentifier(outputStream);
        this.writeToStream(outputStream, fullPacket);
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "OpenBlocks";
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = packet.field_73629_c.length;
        return packet;
    }

    protected abstract void writeMapType(DataOutputStream var1) throws IOException;
}

