/*
 * Decompiled with CFR 0.152.
 */
package openblocks.shapes;

import java.util.HashMap;
import java.util.Map;
import openblocks.shapes.IShapeGenerator;
import openblocks.shapes.IShapeable;
import openblocks.shapes.ShapeCuboidGenerator;
import openblocks.shapes.ShapeCylinderGenerator;
import openblocks.shapes.ShapeDomeGenerator;
import openblocks.shapes.ShapeEquilateral2dGenerator;
import openblocks.shapes.ShapeSphereGenerator;

public class ShapeFactory {
    private static Map _shapeMap = new HashMap();

    public static void generateShape(int xSize, int ySize, int zSize, IShapeable shapeable, Mode mode) {
        if (!_shapeMap.containsKey((Object)mode)) {
            return;
        }
        ((IShapeGenerator)_shapeMap.get((Object)mode)).generateShape(xSize, ySize, zSize, shapeable);
    }

    static {
        _shapeMap.put(Mode.Sphere, new ShapeSphereGenerator());
        _shapeMap.put(Mode.Cylinder, new ShapeCylinderGenerator());
        _shapeMap.put(Mode.Cuboid, new ShapeCuboidGenerator());
        _shapeMap.put(Mode.Dome, new ShapeDomeGenerator());
        _shapeMap.put(Mode.Triangle, new ShapeEquilateral2dGenerator(3));
        _shapeMap.put(Mode.Pentagon, new ShapeEquilateral2dGenerator(5));
        _shapeMap.put(Mode.Hexagon, new ShapeEquilateral2dGenerator(6));
        _shapeMap.put(Mode.Octagon, new ShapeEquilateral2dGenerator(8));
    }

    public static enum Mode {
        Sphere(false),
        Cylinder(false),
        Cuboid(false),
        Dome(false),
        Triangle(true),
        Pentagon(true),
        Hexagon(true),
        Octagon(true);

        private String displayName;
        private boolean fixedRatio = false;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Mode() {
            this((String)var1_-1, (int)var2_-1, null, (boolean)fixedRatio);
            void fixedRatio;
            void var2_-1;
            void var1_-1;
        }

        /*
         * WARNING - void declaration
         */
        private Mode() {
            void fixedRatio;
            void displayName;
            this.displayName = displayName;
            this.fixedRatio = fixedRatio;
        }

        public String getDisplayName() {
            return this.displayName == null ? this.name() : this.displayName;
        }

        public boolean isFixedRatio() {
            return this.fixedRatio;
        }
    }
}

