/*
 * Decompiled with CFR 0.152.
 */
package openblocks.network;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import openblocks.OpenBlocks;

public class PacketHandler
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        if (packet.field_73630_a.equals("OpenBlocks")) {
            try {
                OpenBlocks.syncableManager.handlePacket(packet);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static List getPlayersInRange(World world, int blockX, int blockZ, int distance) {
        ArrayList<EntityPlayerMP> playerList = new ArrayList<EntityPlayerMP>();
        for (int j = 0; j < world.field_73010_i.size(); ++j) {
            EntityPlayerMP player = (EntityPlayerMP)world.field_73010_i.get(j);
            if (!(Math.abs(player.field_70165_t - (double)blockX) <= (double)distance) || !(Math.abs(player.field_70161_v - (double)blockZ) <= (double)distance)) continue;
            playerList.add(player);
        }
        return playerList;
    }

    public static boolean shouldSendUpdateToPlayer(World worldObj, int sourceX, int sourceZ, Player player) {
        if (worldObj.field_72995_K) {
            return false;
        }
        IChunkProvider chunkProvider = worldObj.func_72863_F();
        if (worldObj.func_72863_F().func_73149_a(sourceX >>= 4, sourceZ >>= 4)) {
            System.out.println("Chunk doesn't exist " + sourceX + "," + sourceZ);
            return false;
        }
        Chunk chunk = chunkProvider.func_73154_d(sourceX, sourceZ);
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP mpInstance = (EntityPlayerMP)player;
            if (mpInstance.field_71129_f != null && !mpInstance.field_71129_f.isEmpty()) {
                for (Chunk testChunk : mpInstance.field_71129_f) {
                    System.out.println("That's a TRUE for updating player");
                    if (testChunk != chunk) continue;
                    return true;
                }
            }
        }
        System.out.println("Thats a FALSE for updating player");
        return false;
    }

    public static List getPlayersThatNeedUpdates(World worldObj, int sourceX, int sourceZ) {
        ArrayList<EntityPlayer> playerList = new ArrayList<EntityPlayer>();
        if (worldObj.field_72995_K) {
            return playerList;
        }
        IChunkProvider chunkProvider = worldObj.func_72863_F();
        if (worldObj.func_72863_F().func_73149_a(sourceX >>= 4, sourceZ >>= 4)) {
            System.out.println("Chunk doesn't exist " + sourceX + "," + sourceZ);
            return playerList;
        }
        Chunk chunk = chunkProvider.func_73154_d(sourceX, sourceZ);
        block0: for (EntityPlayer ent : worldObj.field_73010_i) {
            if (!(ent instanceof EntityPlayerMP)) continue;
            EntityPlayerMP mpInstance = (EntityPlayerMP)ent;
            if (mpInstance.field_71129_f == null || mpInstance.field_71129_f.isEmpty()) continue;
            for (Chunk testChunk : mpInstance.field_71129_f) {
                if (testChunk != chunk) continue;
                playerList.add(ent);
                continue block0;
            }
        }
        return playerList;
    }
}

