/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity.tank;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import openblocks.api.IAwareTile;
import openblocks.common.tileentity.OpenTileEntity;
import openblocks.common.tileentity.tank.TileEntityTank;
import openblocks.sync.ISyncHandler;
import openblocks.sync.SyncMap;
import openblocks.sync.SyncMapTile;

public abstract class TileEntityTankBase
extends OpenTileEntity
implements ISyncHandler,
IAwareTile {
    public HashMap neighbours = new HashMap();
    public HashMap surroundingBlocks = new HashMap();
    public static final ForgeDirection[] horizontalDirections = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
    protected Comparator sortBySpace = new Comparator(){

        public int compare(TileEntityTank c1, TileEntityTank c2) {
            return c2.getSpace() - c1.getSpace();
        }
    };
    protected SyncMapTile syncMap = new SyncMapTile();

    @Override
    public void func_70316_g() {
        super.func_70316_g();
    }

    @Override
    protected void initialize() {
        this.findNeighbours();
    }

    protected void findNeighbours() {
        this.neighbours.clear();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity neighbour = this.getTileInDirection(direction);
            if (neighbour != null && neighbour instanceof TileEntityTank) {
                this.neighbours.put(direction, new WeakReference<TileEntityTank>((TileEntityTank)neighbour));
            }
            this.surroundingBlocks.put(direction, !this.field_70331_k.func_72799_c(this.field_70329_l + direction.offsetX, this.field_70330_m + direction.offsetY, this.field_70327_n + direction.offsetZ));
        }
        if (!this.field_70331_k.field_72995_K) {
            this.sendBlockEvent(0, 0);
        }
    }

    public boolean hasBlockOnSide(ForgeDirection side) {
        return this.surroundingBlocks.containsKey(side) && (Boolean)this.surroundingBlocks.get(side) != false;
    }

    public TileEntityTank getTankInDirection(ForgeDirection direction) {
        WeakReference neighbour;
        if (this.neighbours.containsKey(direction) && (neighbour = (WeakReference)this.neighbours.get(direction)) != null) {
            TileEntityTank otherTank = (TileEntityTank)neighbour.get();
            if (otherTank == null) {
                return null;
            }
            if (otherTank.func_70320_p()) {
                return null;
            }
            if (this instanceof TileEntityTank) {
                if (otherTank.canReceiveLiquid(((TileEntityTank)this).getInternalTank().getLiquid())) {
                    return otherTank;
                }
            } else {
                return otherTank;
            }
        }
        return null;
    }

    public TileEntityTank[] getSurroundingTanks() {
        ArrayList<TileEntityTank> tanks = new ArrayList<TileEntityTank>();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntityTank t = this.getTankInDirection(direction);
            if (t == null) continue;
            tanks.add(t);
        }
        return tanks.toArray(new TileEntityTank[tanks.size()]);
    }

    public ArrayList getHorizontalTanksOrdererdBySpace(HashSet except) {
        ArrayList<TileEntityTank> horizontalTanks = new ArrayList<TileEntityTank>();
        for (ForgeDirection direction : horizontalDirections) {
            TileEntityTank tank = this.getTankInDirection(direction);
            if (tank == null || except.contains(tank)) continue;
            horizontalTanks.add(tank);
        }
        Collections.sort(horizontalTanks, this.sortBySpace);
        return horizontalTanks;
    }

    @Override
    public void onBlockBroken() {
    }

    @Override
    public void onBlockAdded() {
    }

    @Override
    public void onNeighbourChanged(int blockId) {
        this.findNeighbours();
    }

    @Override
    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
    }

    @Override
    public void writeIdentifier(DataOutputStream dos) throws IOException {
        dos.writeInt(this.field_70329_l);
        dos.writeInt(this.field_70330_m);
        dos.writeInt(this.field_70327_n);
    }

    @Override
    public SyncMap getSyncMap() {
        return this.syncMap;
    }

    @Override
    public boolean onBlockEventReceived(int eventId, int eventParam) {
        if (this.field_70331_k.field_72995_K) {
            this.findNeighbours();
        }
        return true;
    }
}

