/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity.tank;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import openblocks.OpenBlocks;
import openblocks.common.tileentity.tank.TileEntityTankBase;
import openblocks.sync.ISyncableObject;
import openblocks.sync.SyncableInt;
import openblocks.sync.SyncableShort;
import openblocks.utils.BlockUtils;
import openblocks.utils.ItemUtils;

public class TileEntityTank
extends TileEntityTankBase
implements ITankContainer {
    private LiquidTank tank = new LiquidTank(TileEntityTank.getTankCapacity());
    private SyncableInt liquidId = new SyncableInt();
    private SyncableInt liquidMeta = new SyncableInt();
    private SyncableShort liquidRenderAmount = new SyncableShort();
    private short interpolatedRenderAmount = 0;
    private static final short adjustRate = 1000;
    private double flowTimer = Math.random() * 100.0;

    public static int getTankCapacity() {
        return 1000 * OpenBlocks.Config.bucketsPerTank;
    }

    public TileEntityTank() {
        this.syncMap.put(Keys.liquidId, (ISyncableObject)this.liquidId);
        this.syncMap.put(Keys.liquidMeta, (ISyncableObject)this.liquidMeta);
        this.syncMap.put(Keys.renderLevel, (ISyncableObject)this.liquidRenderAmount);
    }

    public boolean containsValidLiquid() {
        return this.liquidId.getValue() != 0 && this.tank.getLiquidName() != null;
    }

    private void interpolateLiquidLevel() {
        if (!this.field_70331_k.field_72995_K) {
            return;
        }
        this.interpolatedRenderAmount = this.interpolatedRenderAmount + 1000 < this.liquidRenderAmount.getValue() ? (short)(this.interpolatedRenderAmount + 1000) : (this.interpolatedRenderAmount - 1000 > this.liquidRenderAmount.getValue() ? (short)(this.interpolatedRenderAmount - 1000) : this.liquidRenderAmount.getValue());
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            HashSet<TileEntityTank> except = new HashSet<TileEntityTank>();
            except.add(this);
            if (this.tank.getLiquid() != null) {
                LiquidStack myLiquid;
                TileEntityTank below = this.getTankInDirection(ForgeDirection.DOWN);
                if (below != null && below.getSpace() > 0 && below.canReceiveLiquid(myLiquid = this.tank.getLiquid().copy())) {
                    int toFill;
                    myLiquid.amount = toFill = Math.min(below.getSpace(), myLiquid.amount);
                    int filled = below.fill(myLiquid, true, except);
                    this.tank.drain(filled, true);
                }
                if (this.getAmount() > 0 && this.containsValidLiquid()) {
                    ArrayList horizontals = this.getHorizontalTanksOrdererdBySpace(except);
                    for (TileEntityTank horizontal : horizontals) {
                        int difference;
                        LiquidStack liquid;
                        if (!horizontal.canReceiveLiquid(liquid = this.tank.getLiquid()) || liquid == null || (difference = this.getAmount() - horizontal.getAmount()) <= 0) continue;
                        int halfDifference = Math.max(difference / 2, 1);
                        LiquidStack liquidCopy = liquid.copy();
                        liquidCopy.amount = Math.min(500, halfDifference);
                        int filled = horizontal.fill(liquidCopy, true, except);
                        this.tank.drain(filled, true);
                    }
                }
                if (this.tank.getLiquid() != null) {
                    this.liquidId.setValue(this.tank.getLiquid().itemID);
                    this.liquidMeta.setValue(this.tank.getLiquid().itemMeta);
                }
            }
            if (this.containsValidLiquid()) {
                short newLiquidRender = (short)Math.max(0.0f, Math.min(32767.0f, (float)(Short.MAX_VALUE * this.tank.getLiquid().amount) / (float)this.tank.getCapacity()));
                this.liquidRenderAmount.setValue(newLiquidRender);
            } else {
                this.liquidRenderAmount.setValue((short)0);
                this.liquidId.setValue(0);
                this.liquidMeta.setValue(0);
            }
            this.syncMap.sync(this.field_70331_k, this, (double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5);
        } else {
            this.interpolateLiquidLevel();
            this.flowTimer += (double)0.1f;
        }
    }

    public boolean canReceiveLiquid(LiquidStack liquid) {
        if (!this.tank.containsValidLiquid()) {
            return true;
        }
        if (liquid == null) {
            return true;
        }
        LiquidStack otherLiquid = this.tank.getLiquid();
        if (otherLiquid != null) {
            return otherLiquid.isLiquidEqual(liquid);
        }
        return true;
    }

    public LiquidTank getInternalTank() {
        return this.tank;
    }

    public int getSpace() {
        return this.getInternalTank().getCapacity() - this.getAmount();
    }

    public boolean isFull() {
        return this.getAmount() == this.getInternalTank().getCapacity();
    }

    public int getAmount() {
        if (this.getInternalTank() == null || this.getInternalTank().getLiquid() == null) {
            return 0;
        }
        return this.getInternalTank().getLiquid().amount;
    }

    public int fill(LiquidStack resource, boolean doFill, HashSet except) {
        ArrayList horizontals;
        TileEntityTank above;
        TileEntityTank below = this.getTankInDirection(ForgeDirection.DOWN);
        int filled = 0;
        if (except == null) {
            except = new HashSet<TileEntityTank>();
        }
        if (resource == null) {
            return 0;
        }
        int startAmount = resource.amount;
        if (except.contains(this)) {
            return 0;
        }
        except.add(this);
        resource = resource.copy();
        if (below != null && below.getSpace() > 0) {
            filled = below.fill(resource, doFill, except);
            resource.amount -= filled;
        }
        if (resource.amount > 0) {
            filled = this.tank.fill(resource, doFill);
            resource.amount -= filled;
        }
        if (resource.amount > 0 && (above = this.getTankInDirection(ForgeDirection.UP)) != null) {
            filled = above.fill(resource, doFill, except);
            resource.amount -= filled;
        }
        if (resource.amount > 0 && this.canReceiveLiquid(resource) && (horizontals = this.getHorizontalTanksOrdererdBySpace(except)).size() > 0) {
            int amountPerSide = resource.amount / horizontals.size();
            for (TileEntityTank sideTank : horizontals) {
                LiquidStack copy = resource.copy();
                copy.amount = amountPerSide;
                filled = sideTank.fill(copy, doFill, except);
                resource.amount -= filled;
            }
        }
        return startAmount - resource.amount;
    }

    public LiquidStack drain(int amount, boolean doDrain) {
        return this.tank.drain(amount, doDrain);
    }

    @Override
    public void onSynced(List changes) {
        if (changes.contains(this.liquidId) || changes.contains(this.liquidMeta)) {
            if (this.liquidId.getValue() == 0) {
                this.tank.setLiquid(null);
            } else {
                this.tank.setLiquid(new LiquidStack(this.liquidId.getValue(), 1, this.liquidMeta.getValue()));
            }
        }
    }

    @Override
    public void onBlockBroken() {
    }

    @Override
    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("tank")) {
            NBTTagCompound tankTag = stack.func_77978_p().func_74775_l("tank");
            this.tank.readFromNBT(tankTag);
        }
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.tank.writeToNBT(tag);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.tank.readFromNBT(tag);
        this.interpolatedRenderAmount = (short)((double)this.getAmount() / (double)this.tank.getCapacity() * 32767.0);
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        int filled = this.fill(resource, doFill, null);
        if (doFill && filled > 0 && resource != null) {
            this.liquidId.setValue(resource.itemID);
            this.liquidMeta.setValue(resource.itemMeta);
        }
        return filled;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.fill(ForgeDirection.UNKNOWN, resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.tank;
    }

    public int countDownwardsTanks() {
        int count = 1;
        TileEntityTank below = this.getTankInDirection(ForgeDirection.DOWN);
        if (below != null) {
            count += below.countDownwardsTanks();
        }
        return count;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ForgeDirection direction = BlockUtils.sideToDirection(side);
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null) {
            ItemStack filled;
            LiquidStack liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)current);
            if (liquid != null) {
                int qty = this.fill(direction, liquid, true);
                if (qty != 0 && !player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem(current));
                }
                return true;
            }
            LiquidStack available = this.tank.getLiquid();
            if (available != null && (liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)(filled = LiquidContainerRegistry.fillLiquidContainer((LiquidStack)available, (ItemStack)current)))) != null) {
                if (!player.field_71075_bZ.field_75098_d) {
                    if (current.field_77994_a > 1) {
                        if (!player.field_71071_by.func_70441_a(filled)) {
                            return false;
                        }
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem(current));
                    } else {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem(current));
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filled);
                    }
                }
                this.drain(ForgeDirection.UNKNOWN, liquid.amount, true);
                return true;
            }
        }
        return false;
    }

    public double getHeightForRender() {
        if (this.containsValidLiquid()) {
            if (this.field_70331_k == null || this.field_70331_k.field_72995_K) {
                return (double)this.interpolatedRenderAmount / 32767.0;
            }
            return (double)this.liquidRenderAmount.getValue() / 32767.0;
        }
        return 0.0;
    }

    public double getFlowOffset() {
        return Math.sin(this.flowTimer) / 35.0;
    }

    public double getLiquidHeightForSide(ForgeDirection ... sides) {
        if (this.containsValidLiquid()) {
            double percentFull = this.getHeightForRender();
            if (percentFull > 0.98) {
                return 1.0;
            }
            double fullness = percentFull + this.getFlowOffset();
            int count = 1;
            for (ForgeDirection side : sides) {
                TileEntityTank sideTank = this.getTankInDirection(side);
                if (sideTank == null || !sideTank.canReceiveLiquid(this.tank.getLiquid())) continue;
                fullness += sideTank.getHeightForRender() + sideTank.getFlowOffset();
                ++count;
            }
            return Math.max(0.0, Math.min(1.0, fullness / (double)count));
        }
        return 0.0;
    }

    public void setClientLiquidId(int itemID) {
        this.liquidId.setValue(itemID);
    }

    public void setClientLiquidMeta(int itemMeta) {
        this.liquidMeta.setValue(itemMeta);
    }

    public NBTTagCompound getItemNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public static enum Keys {
        liquidId,
        liquidMeta,
        renderLevel;

    }
}

