/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraftforge.common.ForgeDirection;
import openblocks.common.TrophyHandler;
import openblocks.common.api.IAwareTile;
import openblocks.common.tileentity.OpenTileEntity;
import openblocks.utils.BlockUtils;

public class TileEntityTrophy
extends OpenTileEntity
implements IAwareTile {
    public static TrophyHandler.Trophy debugTrophy = TrophyHandler.Trophy.Wolf;
    public TrophyHandler.Trophy trophyType;
    private ForgeDirection rotation = ForgeDirection.EAST;
    private int sinceLastActivate = 0;

    public Packet func_70319_e() {
        Packet132TileEntityData packet = new Packet132TileEntityData();
        packet.field_73330_d = 0;
        packet.field_73334_a = this.field_70329_l;
        packet.field_73332_b = this.field_70330_m;
        packet.field_73333_c = this.field_70327_n;
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        packet.field_73331_e = nbt;
        return packet;
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        this.func_70307_a(pkt.field_73331_e);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            this.trophyType.executeTickBehavior(this);
            if (this.sinceLastActivate < Integer.MAX_VALUE) {
                ++this.sinceLastActivate;
            }
        }
    }

    @Override
    protected void initialize() {
    }

    @Override
    public void onBlockBroken() {
    }

    @Override
    public void onBlockAdded() {
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!this.field_70331_k.field_72995_K) {
            this.trophyType.playSound(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.trophyType.executeActivateBehavior(this, player);
        }
        return true;
    }

    @Override
    public void onNeighbourChanged(int blockId) {
    }

    public TrophyHandler.Trophy getTrophyType() {
        return this.trophyType;
    }

    @Override
    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        if (!this.field_70331_k.field_72995_K) {
            NBTTagCompound tag;
            if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("entity")) {
                String entityKey = tag.func_74779_i("entity");
                this.trophyType = TrophyHandler.Trophy.valueOf(entityKey);
            }
            if (this.trophyType == null) {
                int next = (debugTrophy.ordinal() + 1) % TrophyHandler.Trophy.values().length;
                this.trophyType = debugTrophy = TrophyHandler.Trophy.values()[next];
            }
            this.rotation = BlockUtils.get2dOrientation((EntityLiving)player);
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Override
    public boolean onBlockEventReceived(int eventId, int eventParam) {
        return false;
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        if (tag.func_74764_b("trophytype")) {
            this.trophyType = TrophyHandler.Trophy.valueOf(tag.func_74779_i("trophytype"));
        }
        if (tag.func_74764_b("rotation")) {
            this.rotation = ForgeDirection.getOrientation((int)tag.func_74762_e("rotation"));
        }
        if (tag.func_74764_b("sinceLastActivate")) {
            this.sinceLastActivate = tag.func_74762_e("sinceLastActivate");
        }
    }

    public int sinceLastActivate() {
        return this.sinceLastActivate;
    }

    public void resetActivationTimer() {
        this.sinceLastActivate = 0;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74778_a("trophytype", this.trophyType.toString());
        tag.func_74768_a("rotation", this.rotation.ordinal());
        tag.func_74768_a("sinceLastActivate", this.sinceLastActivate);
    }

    @Override
    public ForgeDirection getRotation() {
        return this.rotation;
    }
}

