/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import openblocks.OpenBlocks;
import openblocks.common.api.IAwareTile;
import openblocks.common.tileentity.NetworkedTileEntity;
import openblocks.sync.SyncableInt;
import openblocks.sync.SyncableShort;
import openblocks.utils.BlockUtils;
import openblocks.utils.ItemUtils;

public class TileEntityTank
extends NetworkedTileEntity
implements ITankContainer,
IAwareTile {
    private LiquidTank tank = new LiquidTank(TileEntityTank.getTankCapacity());
    private SyncableInt liquidId = new SyncableInt();
    private SyncableInt liquidMeta = new SyncableInt();
    private SyncableShort liquidRenderAmount = new SyncableShort();
    private short interpolatedRenderAmount = 0;
    private static final short adjustRate = 1000;
    private double flowTimer = Math.random() * 100.0;
    public HashMap neighbours = new HashMap();
    public HashMap surroundingBlocks = new HashMap();
    public static final ForgeDirection[] horizontalDirections = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
    protected Comparator sortBySpace = new Comparator(){

        public int compare(TileEntityTank c1, TileEntityTank c2) {
            return c2.getSpace() - c1.getSpace();
        }
    };

    public static int getTankCapacity() {
        return 1000 * OpenBlocks.Config.bucketsPerTank;
    }

    public TileEntityTank() {
        this.addSyncedObject(Keys.liquidId, this.liquidId);
        this.addSyncedObject(Keys.liquidMeta, this.liquidMeta);
        this.addSyncedObject(Keys.renderLevel, this.liquidRenderAmount);
    }

    public int getClientLiquidId() {
        return this.liquidId.getValue();
    }

    public int getClientLiquidMeta() {
        return this.liquidMeta.getValue();
    }

    protected void updateNeighbours() {
        TileEntityTank up = this.getTankInDirection(ForgeDirection.UP);
        TileEntityTank down = this.getTankInDirection(ForgeDirection.DOWN);
        TileEntityTank north = this.getTankInDirection(ForgeDirection.NORTH);
        TileEntityTank south = this.getTankInDirection(ForgeDirection.SOUTH);
        TileEntityTank east = this.getTankInDirection(ForgeDirection.EAST);
        TileEntityTank west = this.getTankInDirection(ForgeDirection.WEST);
        if (up != null) {
            up.findNeighbours();
        }
        if (down != null) {
            down.findNeighbours();
        }
        if (north != null) {
            north.findNeighbours();
        }
        if (south != null) {
            south.findNeighbours();
        }
        if (east != null) {
            east.findNeighbours();
        }
        if (west != null) {
            west.findNeighbours();
        }
    }

    protected void findNeighbours() {
        this.neighbours.clear();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity neighbour = this.getTileInDirection(direction);
            if (neighbour != null && neighbour instanceof TileEntityTank) {
                this.neighbours.put(direction, new WeakReference<TileEntityTank>((TileEntityTank)neighbour));
            }
            this.surroundingBlocks.put(direction, !this.field_70331_k.func_72799_c(this.field_70329_l + direction.offsetX, this.field_70330_m + direction.offsetY, this.field_70327_n + direction.offsetZ));
        }
        if (!this.field_70331_k.field_72995_K) {
            this.sendBlockEvent(0, 0);
        }
    }

    public boolean hasBlockOnSide(ForgeDirection side) {
        return this.surroundingBlocks.containsKey(side) && (Boolean)this.surroundingBlocks.get(side) != false;
    }

    public TileEntityTank getTankInDirection(ForgeDirection direction) {
        WeakReference neighbour;
        if (this.neighbours.containsKey(direction) && (neighbour = (WeakReference)this.neighbours.get(direction)) != null) {
            TileEntityTank otherTank = (TileEntityTank)neighbour.get();
            if (otherTank == null) {
                return null;
            }
            if (otherTank.func_70320_p()) {
                return null;
            }
            if (this instanceof TileEntityTank) {
                if (otherTank.canReceiveLiquid(this.getInternalTank().getLiquid())) {
                    return otherTank;
                }
            } else {
                return otherTank;
            }
        }
        return null;
    }

    public TileEntityTank[] getSurroundingTanks() {
        ArrayList<TileEntityTank> tanks = new ArrayList<TileEntityTank>();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntityTank t = this.getTankInDirection(direction);
            if (t == null) continue;
            tanks.add(t);
        }
        return tanks.toArray(new TileEntityTank[tanks.size()]);
    }

    public ArrayList getHorizontalTanksOrdererdBySpace(HashSet except) {
        ArrayList<TileEntityTank> horizontalTanks = new ArrayList<TileEntityTank>();
        for (ForgeDirection direction : horizontalDirections) {
            TileEntityTank tank = this.getTankInDirection(direction);
            if (tank == null || except.contains(tank)) continue;
            horizontalTanks.add(tank);
        }
        Collections.sort(horizontalTanks, this.sortBySpace);
        return horizontalTanks;
    }

    @Override
    public void onNeighbourChanged(int blockId) {
        this.findNeighbours();
    }

    @Override
    public boolean onBlockEventReceived(int eventId, int eventParam) {
        if (this.field_70331_k.field_72995_K) {
            this.findNeighbours();
        }
        return true;
    }

    public boolean containsValidLiquid() {
        return this.liquidId.getValue() != 0 && this.tank.getLiquidName() != null;
    }

    private void interpolateLiquidLevel() {
        if (!this.field_70331_k.field_72995_K) {
            return;
        }
        this.interpolatedRenderAmount = this.interpolatedRenderAmount + 1000 < this.liquidRenderAmount.getValue() ? (short)(this.interpolatedRenderAmount + 1000) : (this.interpolatedRenderAmount - 1000 > this.liquidRenderAmount.getValue() ? (short)(this.interpolatedRenderAmount - 1000) : this.liquidRenderAmount.getValue());
    }

    @Override
    protected void initialize() {
        this.findNeighbours();
        this.updateNeighbours();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            HashSet<TileEntityTank> except = new HashSet<TileEntityTank>();
            except.add(this);
            if (this.tank.getLiquid() != null) {
                LiquidStack myLiquid;
                TileEntityTank below = this.getTankInDirection(ForgeDirection.DOWN);
                if (below != null && below.getSpace() > 0 && below.canReceiveLiquid(myLiquid = this.tank.getLiquid().copy())) {
                    int toFill;
                    myLiquid.amount = toFill = Math.min(below.getSpace(), myLiquid.amount);
                    int filled = below.fill(myLiquid, true, except);
                    this.tank.drain(filled, true);
                }
                if (this.getAmount() > 0 && this.containsValidLiquid()) {
                    ArrayList horizontals = this.getHorizontalTanksOrdererdBySpace(except);
                    for (TileEntityTank horizontal : horizontals) {
                        int difference;
                        LiquidStack liquid;
                        if (!horizontal.canReceiveLiquid(liquid = this.tank.getLiquid()) || liquid == null || (difference = this.getAmount() - horizontal.getAmount()) <= 0) continue;
                        int halfDifference = Math.max(difference / 2, 1);
                        LiquidStack liquidCopy = liquid.copy();
                        liquidCopy.amount = Math.min(500, halfDifference);
                        int filled = horizontal.fill(liquidCopy, true, except);
                        this.tank.drain(filled, true);
                    }
                }
                if (this.tank.getLiquid() != null) {
                    this.liquidId.setValue(this.tank.getLiquid().itemID);
                    this.liquidMeta.setValue(this.tank.getLiquid().itemMeta);
                }
            }
            if (this.containsValidLiquid()) {
                short newLiquidRender = (short)Math.max(0.0f, Math.min(32767.0f, (float)(Short.MAX_VALUE * this.tank.getLiquid().amount) / (float)this.tank.getCapacity()));
                this.liquidRenderAmount.setValue(newLiquidRender);
            } else {
                this.liquidRenderAmount.setValue((short)0);
                this.liquidId.setValue(0);
                this.liquidMeta.setValue(0);
            }
            this.sync(1);
        } else {
            this.interpolateLiquidLevel();
            this.flowTimer += (double)0.1f;
        }
    }

    public boolean canReceiveLiquid(LiquidStack liquid) {
        if (!this.tank.containsValidLiquid()) {
            return true;
        }
        if (liquid == null) {
            return true;
        }
        LiquidStack otherLiquid = this.tank.getLiquid();
        if (otherLiquid != null) {
            return otherLiquid.isLiquidEqual(liquid);
        }
        return true;
    }

    public LiquidTank getInternalTank() {
        return this.tank;
    }

    public int getSpace() {
        return this.getInternalTank().getCapacity() - this.getAmount();
    }

    public boolean isFull() {
        return this.getAmount() == this.getInternalTank().getCapacity();
    }

    public int getAmount() {
        if (this.getInternalTank() == null || this.getInternalTank().getLiquid() == null) {
            return 0;
        }
        return this.getInternalTank().getLiquid().amount;
    }

    public int fill(LiquidStack resource, boolean doFill, HashSet except) {
        ArrayList horizontals;
        TileEntityTank above;
        TileEntityTank below = this.getTankInDirection(ForgeDirection.DOWN);
        int filled = 0;
        if (except == null) {
            except = new HashSet<TileEntityTank>();
        }
        if (resource == null) {
            return 0;
        }
        int startAmount = resource.amount;
        if (except.contains(this)) {
            return 0;
        }
        except.add(this);
        resource = resource.copy();
        if (below != null && below.getSpace() > 0) {
            filled = below.fill(resource, doFill, except);
            resource.amount -= filled;
        }
        if (resource.amount > 0) {
            filled = this.tank.fill(resource, doFill);
            resource.amount -= filled;
        }
        if (resource.amount > 0 && (above = this.getTankInDirection(ForgeDirection.UP)) != null) {
            filled = above.fill(resource, doFill, except);
            resource.amount -= filled;
        }
        if (resource.amount > 0 && this.canReceiveLiquid(resource) && (horizontals = this.getHorizontalTanksOrdererdBySpace(except)).size() > 0) {
            int amountPerSide = resource.amount / horizontals.size();
            for (TileEntityTank sideTank : horizontals) {
                LiquidStack copy = resource.copy();
                copy.amount = amountPerSide;
                filled = sideTank.fill(copy, doFill, except);
                resource.amount -= filled;
            }
        }
        return startAmount - resource.amount;
    }

    public LiquidStack drain(int amount, boolean doDrain) {
        return this.tank.drain(amount, doDrain);
    }

    @Override
    public void onSynced(List changes) {
        this.interpolatedRenderAmount = this.liquidRenderAmount.getValue();
        if (changes.contains(this.liquidId) || changes.contains(this.liquidMeta)) {
            if (this.liquidId.getValue() == 0) {
                this.tank.setLiquid(null);
            } else {
                this.tank.setLiquid(new LiquidStack(this.liquidId.getValue(), 1, this.liquidMeta.getValue()));
            }
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Override
    public void onBlockBroken() {
    }

    @Override
    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("tank")) {
            NBTTagCompound tankTag = stack.func_77978_p().func_74775_l("tank");
            this.tank.readFromNBT(tankTag);
        }
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.tank.writeToNBT(tag);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.tank.readFromNBT(tag);
        this.interpolatedRenderAmount = (short)((double)this.getAmount() / (double)this.tank.getCapacity() * 32767.0);
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        int filled = this.fill(resource, doFill, null);
        if (doFill && filled > 0 && resource != null) {
            this.liquidId.setValue(resource.itemID);
            this.liquidMeta.setValue(resource.itemMeta);
        }
        return filled;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.fill(ForgeDirection.UNKNOWN, resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.tank;
    }

    public int countDownwardsTanks() {
        int count = 1;
        TileEntityTank below = this.getTankInDirection(ForgeDirection.DOWN);
        if (below != null) {
            count += below.countDownwardsTanks();
        }
        return count;
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        super.onDataPacket(net, pkt);
        this.interpolatedRenderAmount = this.liquidRenderAmount.getValue();
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ForgeDirection direction = BlockUtils.sideToDirection(side);
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null) {
            ItemStack filled;
            LiquidStack liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)current);
            if (liquid != null) {
                int qty = this.fill(direction, liquid, true);
                if (qty != 0 && !player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem(current));
                }
                return true;
            }
            if (this.field_70331_k.field_72995_K && this.liquidRenderAmount.getValue() > 0) {
                return true;
            }
            LiquidStack available = this.tank.getLiquid();
            if (available != null && (liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)(filled = LiquidContainerRegistry.fillLiquidContainer((LiquidStack)available, (ItemStack)current)))) != null) {
                if (!player.field_71075_bZ.field_75098_d) {
                    if (current.field_77994_a > 1) {
                        if (!player.field_71071_by.func_70441_a(filled)) {
                            return false;
                        }
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem(current));
                    } else {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem(current));
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filled);
                    }
                }
                this.drain(ForgeDirection.UNKNOWN, liquid.amount, true);
                return true;
            }
        }
        return false;
    }

    public double getHeightForRender() {
        double percent = this.getPercentFull();
        if (this.field_70331_k == null || this.field_70331_k.field_72995_K) {
            return Math.max(percent > 0.001 ? 0.1 : 0.0, percent);
        }
        return percent;
    }

    public double getPercentFull() {
        if (this.containsValidLiquid()) {
            if (this.field_70331_k == null || this.field_70331_k.field_72995_K) {
                return (double)this.interpolatedRenderAmount / 32767.0;
            }
            return (double)this.liquidRenderAmount.getValue() / 32767.0;
        }
        return 0.0;
    }

    public double getFlowOffset() {
        return Math.sin(this.flowTimer) / 35.0;
    }

    public double getLiquidHeightForSide(ForgeDirection ... sides) {
        if (this.containsValidLiquid()) {
            double percentFull = this.getHeightForRender();
            if (percentFull > 0.98) {
                return 1.0;
            }
            double fullness = percentFull + this.getFlowOffset();
            int count = 1;
            for (ForgeDirection side : sides) {
                TileEntityTank sideTank = this.getTankInDirection(side);
                if (sideTank == null || !sideTank.canReceiveLiquid(this.tank.getLiquid())) continue;
                fullness += sideTank.getHeightForRender() + sideTank.getFlowOffset();
                ++count;
            }
            return Math.max(0.0, Math.min(1.0, fullness / (double)count));
        }
        return 0.0;
    }

    public void setClientLiquidId(int itemID) {
        this.liquidId.setValue(itemID);
    }

    public void setClientLiquidMeta(int itemMeta) {
        this.liquidMeta.setValue(itemMeta);
    }

    public NBTTagCompound getItemNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public void onBlockAdded() {
    }

    public static enum Keys {
        liquidId,
        liquidMeta,
        renderLevel;

    }
}

