/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.FakePlayer;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import openblocks.OpenBlocks;
import openblocks.common.GenericInventory;
import openblocks.common.api.IAwareTile;
import openblocks.common.api.ISurfaceAttachment;
import openblocks.common.tileentity.OpenTileEntity;
import openblocks.utils.BlockUtils;
import openblocks.utils.InventoryUtils;

public class TileEntitySprinkler
extends OpenTileEntity
implements IAwareTile,
ISurfaceAttachment,
ITankContainer,
IInventory {
    private LiquidStack water = new LiquidStack(Block.field_71943_B, 1);
    private ItemStack bonemeal = new ItemStack(Item.field_77756_aW, 1, 15);
    private LiquidTank tank = new LiquidTank(1000);
    private GenericInventory inventory = new GenericInventory("sprinkler", true, 9);
    private boolean hasBonemeal = false;

    private void attemptFertilize() {
        if (this.field_70331_k == null || this.field_70331_k.field_72995_K) {
            return;
        }
        double d = this.field_70331_k.field_73012_v.nextDouble();
        int n = this.hasBonemeal ? OpenBlocks.Config.sprinklerBonemealFertizizeChance : OpenBlocks.Config.sprinklerFertilizeChance;
        if (d < 1.0 / (double)n) {
            Random random = this.field_70331_k.field_73012_v;
            int x = (random.nextInt(OpenBlocks.Config.sprinklerEffectiveRange) + 1) * (random.nextBoolean() ? 1 : -1) + this.field_70329_l;
            int z = (random.nextInt(OpenBlocks.Config.sprinklerEffectiveRange) + 1) * (random.nextBoolean() ? 1 : -1) + this.field_70327_n;
            for (int i = -1; i <= 1; ++i) {
                int y = this.field_70330_m + i;
                for (int a = 0; a < 10 && !ItemDye.applyBonemeal((ItemStack)this.bonemeal.func_77946_l(), (World)this.field_70331_k, (int)x, (int)y, (int)z, (EntityPlayer)new FakePlayer(this.field_70331_k, "sprinkler")); ++a) {
                }
            }
        }
    }

    private void sprayParticles() {
        if (this.field_70331_k == null || !this.field_70331_k.field_72995_K) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            float offset = ((float)i - 2.5f) / 5.0f;
            ForgeDirection rotation = this.getRotation();
            OpenBlocks.proxy.spawnLiquidSpray(this.field_70331_k, this.water, (double)this.field_70329_l + 0.5 + (double)offset * 0.6 * (double)rotation.offsetX, this.field_70330_m, (double)this.field_70327_n + 0.5 + (double)offset * 0.6 * (double)rotation.offsetZ, rotation, this.getSprayPitch(), 2.0f * offset);
        }
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            ITankContainer belowTank;
            LiquidStack drained;
            TileEntity below;
            if ((this.tank.getLiquid() == null || this.tank.getLiquid().amount == 0) && (below = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n)) instanceof ITankContainer && (drained = (belowTank = (ITankContainer)below).drain(ForgeDirection.UP, this.tank.getCapacity(), false)) != null && drained.isLiquidEqual(this.water) && (drained = belowTank.drain(ForgeDirection.UP, this.tank.getCapacity(), true)) != null) {
                this.tank.fill(drained, true);
            }
            if (this.field_70331_k.func_82737_E() % 1200L == 0L) {
                this.hasBonemeal = InventoryUtils.consumeInventoryItem(this.inventory, this.bonemeal);
            }
            if (this.field_70331_k.func_82737_E() % 60L == 0L) {
                this.setEnabled(this.tank.drain(1, true) != null);
                this.sync();
            }
        }
        if (this.isEnabled()) {
            this.attemptFertilize();
            this.sprayParticles();
        }
    }

    private void setEnabled(boolean b) {
        this.setFlag1(b);
    }

    private boolean isEnabled() {
        return this.getFlag1();
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return this.inventory.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public String func_70303_b() {
        return this.inventory.func_70303_b();
    }

    public boolean func_94042_c() {
        return this.inventory.func_94042_c();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.inventory.func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.inventory.func_94041_b(i, itemstack);
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (resource != null && resource.isLiquidEqual(this.water)) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.fill(ForgeDirection.UNKNOWN, resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.tank;
    }

    @Override
    public ForgeDirection getSurfaceDirection() {
        return ForgeDirection.DOWN;
    }

    @Override
    public void onBlockBroken() {
    }

    @Override
    public void onBlockAdded() {
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        if (!this.field_70331_k.field_72995_K) {
            this.openGui(player, OpenBlocks.Gui.Sprinkler);
        }
        return true;
    }

    @Override
    public void onNeighbourChanged(int blockId) {
    }

    @Override
    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        this.setRotation(BlockUtils.get2dOrientation((EntityLiving)player));
        this.sync();
    }

    @Override
    public boolean onBlockEventReceived(int eventId, int eventParam) {
        return false;
    }

    public float getSprayPitch() {
        return (float)((double)this.getSprayAngle() * Math.PI);
    }

    public float getSprayAngle() {
        if (this.isEnabled()) {
            float angle = (float)((double)MathHelper.func_76126_a((float)((float)this.field_70331_k.func_82737_E() * 0.02f)) * Math.PI * (double)0.035f);
            return angle;
        }
        return 0.0f;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.inventory.writeToNBT(tag);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.inventory.readFromNBT(tag);
        if (tag.func_74764_b("rotation")) {
            byte ordinal = tag.func_74771_c("rotation");
            this.setRotation(ForgeDirection.getOrientation((int)ordinal));
            this.sync();
        }
    }
}

