/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.ForgeDirection;
import openblocks.api.IShapeProvider;
import openblocks.common.tileentity.NetworkedTileEntity;
import openblocks.shapes.IShapeable;
import openblocks.shapes.ShapeFactory;
import openblocks.sync.SyncableInt;

public class TileEntityGuide
extends NetworkedTileEntity
implements IShapeable,
IShapeProvider {
    private boolean[][][] shape;
    private boolean[][][] previousShape;
    private float timeSinceChange = 0.0f;
    protected SyncableInt width = new SyncableInt(8);
    protected SyncableInt height = new SyncableInt(8);
    protected SyncableInt depth = new SyncableInt(8);
    protected SyncableInt mode = new SyncableInt(0);

    public TileEntityGuide() {
        this.addSyncedObject(Keys.width, this.width);
        this.addSyncedObject(Keys.height, this.height);
        this.addSyncedObject(Keys.depth, this.depth);
        this.addSyncedObject(Keys.mode, this.mode);
    }

    public int getWidth() {
        return this.width.getValue();
    }

    public int getHeight() {
        return this.height.getValue();
    }

    public int getDepth() {
        return this.depth.getValue();
    }

    public void setWidth(int w) {
        this.width.setValue(w);
    }

    public void setDepth(int d) {
        this.depth.setValue(d);
    }

    public void setHeight(int h) {
        this.height.setValue(h);
    }

    public ShapeFactory.Mode getCurrentMode() {
        return ShapeFactory.Mode.values()[this.mode.getValue()];
    }

    @Override
    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K && (double)this.timeSinceChange < 1.0) {
            this.timeSinceChange = (float)Math.min(1.0, (double)this.timeSinceChange + 0.1);
        }
    }

    public float getTimeSinceChange() {
        return this.timeSinceChange;
    }

    private void recreateShape() {
        this.previousShape = this.shape;
        this.shape = new boolean[this.getHeight() * 2 + 1][this.getWidth() * 2 + 1][this.getDepth() * 2 + 1];
        ShapeFactory.generateShape(this.getWidth(), this.getHeight(), this.getDepth(), this, this.getCurrentMode());
        this.timeSinceChange = 0.0f;
    }

    @Override
    public void setBlock(int x, int y, int z) {
        try {
            this.shape[this.getHeight() + y][this.getWidth() + x][this.getDepth() + z] = true;
        }
        catch (IndexOutOfBoundsException iobe) {
            // empty catch block
        }
    }

    public boolean[][][] getShape() {
        return this.shape;
    }

    public boolean[][][] getPreviousShape() {
        return this.previousShape;
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.width.readFromNBT(tag, "width");
        this.height.readFromNBT(tag, "height");
        this.depth.readFromNBT(tag, "depth");
        this.mode.readFromNBT(tag, "mode");
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.width.writeToNBT(tag, "width");
        this.height.writeToNBT(tag, "height");
        this.depth.writeToNBT(tag, "depth");
        this.mode.writeToNBT(tag, "mode");
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB box = super.getRenderBoundingBox();
        return box.func_72314_b((double)this.getWidth(), (double)this.getHeight(), (double)this.getDepth());
    }

    public void switchMode(EntityPlayer player) {
        this.switchMode();
        if (player != null) {
            player.func_70006_a(String.format("Changing to %s mode", this.getCurrentMode().getDisplayName()));
        }
    }

    public void switchMode() {
        int nextMode = this.mode.getValue() + 1;
        if (nextMode >= ShapeFactory.Mode.values().length) {
            nextMode = 0;
        }
        this.mode.setValue(nextMode);
        if (this.getCurrentMode().isFixedRatio()) {
            this.setHeight(this.getWidth());
            this.setDepth(this.getWidth());
        }
        this.recreateShape();
        this.sync();
    }

    public void changeDimensions(EntityPlayer player, ForgeDirection orientation) {
        this.changeDimensions(orientation);
        player.func_70006_a(String.format("Changing size to %sx%sx%s", this.width.getValue(), this.height.getValue(), this.depth.getValue()));
    }

    public void changeDimensions(ForgeDirection orientation) {
        if (this.width.getValue() > 0 && orientation == ForgeDirection.EAST) {
            this.width.modify(-1);
        } else if (orientation == ForgeDirection.WEST) {
            this.width.modify(1);
        } else if (orientation == ForgeDirection.NORTH) {
            this.depth.modify(1);
        } else if (this.depth.getValue() > 0 && orientation == ForgeDirection.SOUTH) {
            this.depth.modify(-1);
        } else if (orientation == ForgeDirection.UP) {
            this.height.modify(1);
        } else if (this.height.getValue() > 0 && orientation == ForgeDirection.DOWN) {
            this.height.modify(-1);
        }
        if (this.getCurrentMode().isFixedRatio()) {
            int h = this.getHeight();
            int w = this.getWidth();
            int d = this.getDepth();
            if (w != h && w != d) {
                this.setHeight(w);
                this.setDepth(w);
            } else if (h != w && h != d) {
                this.depth.setValue(h);
                this.width.setValue(h);
            } else if (d != w && d != h) {
                this.width.setValue(d);
                this.height.setValue(d);
            }
        }
        this.recreateShape();
        this.sync();
    }

    @Override
    public ChunkCoordinates[] getShapeCoordinates() {
        if (this.shape == null) {
            this.recreateShape();
        }
        ArrayList<ChunkCoordinates> coords = new ArrayList<ChunkCoordinates>();
        if (this.shape != null) {
            for (int y2 = 0; y2 < this.shape.length; ++y2) {
                for (int x2 = 0; x2 < this.shape[y2].length; ++x2) {
                    for (int z2 = 0; z2 < this.shape[y2][x2].length; ++z2) {
                        if (!this.shape[y2][x2][z2]) continue;
                        coords.add(new ChunkCoordinates(this.field_70329_l + x2 - this.getWidth(), this.field_70330_m + y2 - this.getHeight(), this.field_70327_n + z2 - this.getDepth()));
                    }
                }
            }
        }
        return coords.toArray(new ChunkCoordinates[coords.size()]);
    }

    @Override
    public void onSynced(List changes) {
        this.recreateShape();
    }

    public void fill(EntityPlayer player) {
        ItemStack held;
        if (player.func_70694_bm() != null && (held = player.func_70694_bm()).func_77973_b() instanceof ItemBlock) {
            ItemBlock itemblock = (ItemBlock)held.func_77973_b();
            for (ChunkCoordinates coord : this.getShapeCoordinates()) {
                this.field_70331_k.func_94575_c(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c, itemblock.func_77883_f());
            }
        }
    }

    public static enum Keys {
        width,
        height,
        depth,
        mode;

    }
}

