/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.common.api.IAwareTile;
import openblocks.common.api.ISurfaceAttachment;
import openblocks.common.block.BlockFlag;
import openblocks.common.tileentity.NetworkedTileEntity;
import openblocks.sync.SyncableFloat;
import openblocks.sync.SyncableInt;
import openblocks.utils.BlockUtils;

public class TileEntityFlag
extends NetworkedTileEntity
implements ISurfaceAttachment,
IAwareTile {
    private SyncableFloat angle = new SyncableFloat(0.0f);
    private SyncableInt colorIndex = new SyncableInt(0);

    public TileEntityFlag() {
        this.addSyncedObject(Keys.angle, this.angle);
        this.addSyncedObject(Keys.colorIndex, this.colorIndex);
    }

    @Override
    protected void initialize() {
    }

    @Override
    public void onSynced(List changes) {
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.colorIndex.readFromNBT(tag, "color");
        this.angle.readFromNBT(tag, "angle");
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.colorIndex.writeToNBT(tag, "color");
        this.angle.writeToNBT(tag, "angle");
    }

    public Icon getIcon() {
        return OpenBlocks.Blocks.flag.func_71858_a(0, 0);
    }

    public void setColorIndex(int index) {
        this.colorIndex.setValue(index);
    }

    public void setAngle(float ang) {
        this.angle.setValue(ang);
    }

    public void setOnGround(boolean onGround) {
        this.setFlag1(onGround);
    }

    public boolean isOnGround() {
        return this.getFlag1();
    }

    public int getColor() {
        if (this.colorIndex.getValue() >= BlockFlag.COLORS.length) {
            this.colorIndex.setValue(0);
        }
        return BlockFlag.COLORS[this.colorIndex.getValue()];
    }

    @Override
    public ForgeDirection getSurfaceDirection() {
        ForgeDirection rotation = this.getFlag1() ? ForgeDirection.DOWN : this.getRotation();
        return rotation;
    }

    public float getAngle() {
        return this.angle.getValue();
    }

    @Override
    public void onBlockBroken() {
    }

    @Override
    public void onBlockAdded() {
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player != null && player.func_70093_af()) {
            return true;
        }
        if (!this.field_70331_k.field_72995_K && this.getSurfaceDirection() == ForgeDirection.DOWN) {
            this.angle.setValue(this.angle.getValue() + 10.0f);
            this.sync();
            return false;
        }
        return true;
    }

    @Override
    public void onNeighbourChanged(int blockId) {
    }

    @Override
    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        float ang = player.field_70759_as;
        ForgeDirection surface = side.getOpposite();
        if (surface != ForgeDirection.DOWN) {
            ang = -BlockUtils.getRotationFromDirection(side.getOpposite());
        }
        this.setAngle(ang);
        this.setColorIndex(stack.func_77960_j());
        this.setRotation(side.getOpposite());
        this.setOnGround(surface == ForgeDirection.DOWN);
        this.sync();
    }

    @Override
    public boolean onBlockEventReceived(int eventId, int eventParam) {
        return false;
    }

    public static enum Keys {
        angle,
        colorIndex;

    }
}

